<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'Login';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

//login
$route['user/login']			=	'Login/auth';
$route['login']					=	'Login/index';
//dashboard
$route['dashboard']				=	'Main/index';
$route['signout']				=	'Main/logout';
//branch
$route['branch']				=	'Main/create_branch';
$route['branch/create']			=	'Main/add_branch';
$route['branch_manage']			=	'Main/manage_branch';
$route['branch/show/(:num)']	=	'Main/view_branch';
$route['branch/update']			=	'Main/update_branch';
$route['branch/delete/(:num)']	=	'Main/delete_branch';

$route['asset']				=	'Main/create_asset';
$route['asset/create']		=	'Main/add_asset';
$route['asset_manage']		=	'Main/manage_asset';
$route['asset/delete/(:num)']=	'Main/delete_asset';
//user
$route['user']					=	'Main/create_user';
$route['user/create']			=	'Main/add_user';
$route['user_manage']			=	'Main/manage_user';
$route['user/show/(:num)']		=	'Main/view_user';
$route['user/update']			=	'Main/update_user';
$route['user/delete/(:num)']	=	'Main/delete_user';
$route['open_cash']				=	'Main/open_cash';
$route['open_cash/(:num)']		=	'Main/update_open_cash';
$route['update_name/(:num)']		=	'Product/update_name';
//bank & expense
$route['bank']					=	'Main/create_bank';
$route['bank/create']			=	'Main/add_bank';
$route['bank_manage']			=	'Main/manage_bank';
$route['bank/delete/(:num)']	=	'Main/delete_bank';

$route['voucher']					=	'Product/create_voucher';
$route['voucher/create']			=	'Product/add_voucher';
$route['voucher_manage']			=	'Product/manage_voucher';
$route['voucher/delete/(:num)']	=	'Product/delete_voucher';

$route['stock/ime/(:num)']	=	'Report/stock_report_print_ime';
$route['ime_inactive/(:num)']	=	'Report/ime_inactive';
$route['product/auto_ime']	=	'Product/autocomplete_ime';
$route['auto_ime/product']	=	'Product/auto_product_ime';

$route['transport']					=	'Main/create_transport';
$route['transport/create']			=	'Main/add_transport';
$route['transport_manage']			=	'Main/manage_transport';
$route['transport/delete/(:num)']	=	'Main/delete_transport';

$route['sale_incentive_manage']			=	'Main/manage_sale_incentive';

$route['bank_withdraw']					=	'Main/create_bank_withdraw';
$route['bank_withdraw/create']			=	'Main/add_bank_withdraw';
$route['bank_withdraw_manage']			=	'Main/manage_bank_withdraw';
$route['bank_withdraw/delete/(:num)']	=	'Main/delete_bank_withdraw';

$route['head']					=	'Main/create_head';
$route['head/create']			=	'Main/add_head';
$route['head_manage']			=	'Main/manage_head';
$route['head/delete/(:num)']	=	'Main/delete_head';

$route['prson_head']					=	'Main/create_prson_head';
$route['prson_head/create']			=	'Main/add_prson_head';
$route['prson_head_manage']			=	'Main/manage_prson_head';
$route['prson_head/delete/(:num)']	=	'Main/delete_prson_head';

$route['subject']					=	'Main/create_subject';
$route['subject/create']			=	'Main/add_subject';
$route['subject_manage']			=	'Main/manage_subject';
$route['subject/delete/(:num)']	=	'Main/delete_subject';

$route['place']					=	'Main/create_place';
$route['place/create']			=	'Main/add_place';
$route['place_manage']			=	'Main/manage_place';
$route['place/delete/(:num)']	=	'Main/delete_place';

$route['khat']					=	'Main/create_khat';
$route['khat/create']			=	'Main/add_khat';
$route['khat_manage']			=	'Main/manage_khat';
$route['khat/delete/(:num)']	=	'Main/delete_khat';

$route['loan_head']					=	'Main/create_loan_head';
$route['loan_head/create']			=	'Main/add_loan_head';
$route['loan_head_manage']			=	'Main/manage_loan_head';
$route['loan_head/delete/(:num)']	=	'Main/delete_loan_head';

$route['loan']					=	'Main/create_loan';
$route['loan/create']			=	'Main/add_loan';
$route['loan_manage']			=	'Main/manage_loan';
$route['loan/delete/(:num)']	=	'Main/delete_loan';

$route['take_loan']					=	'Main/create_take_loan';
$route['take_loan/create']			=	'Main/add_take_loan';
$route['take_loan_manage']			=	'Main/manage_take_loan';
$route['take_loan/delete/(:num)']	=	'Main/delete_take_loan';

$route['account']				=	'Main/create_account';
$route['account/create']		=	'Main/add_account';
$route['account_manage']		=	'Main/manage_account';
$route['account/show/(:num)']	=	'Main/view_account';
$route['account/update']		=	'Main/update_account';
$route['account/delete/(:num)']	=	'Main/delete_account';

$route['other_expense']				=	'Main/create_other_expense';
$route['other_expense/create']		=	'Main/add_other_expense';
$route['other_expense_manage']		=	'Main/manage_other_expense';

$route['deposit']				=	'Main/create_deposit';
$route['deposit/create']		=	'Main/add_other_expense';
$route['deposit_manage']		=	'Main/manage_deposit';
$route['other_expense/show/(:num)']	=	'Main/view_other_expense';
$route['other_expense/update']		=	'Main/update_other_expense';
$route['other_expense/delete/(:num)']	=	'Main/delete_other_expense';

//product
$route['complain']				=	'Main/create_complain';
$route['complain/create']		=	'Main/add_complain';
$route['complain/update']		=	'Main/update_complain';
$route['complain_view/(:num)']	=	'Main/view_complain';
$route['complain_manage']		=	'Main/manage_complain';
$route['complain/delete/(:num)']=	'Main/delete_complain';
$route['complain_print']		=	'Report/complain_print';

$route['category']				=	'Main/create_category';
$route['category/create']		=	'Main/add_category';
$route['category_manage']		=	'Main/manage_category';
$route['category/show/(:num)']	=	'Main/view_category';
$route['category/update']		=	'Main/update_category';
$route['category/delete/(:num)']	=	'Main/delete_category';

$route['service']				=	'Main/create_service';
$route['service/create']		=	'Main/add_service';
$route['service_manage']		=	'Main/manage_service';
$route['service/show/(:num)']	=	'Main/view_service';
$route['service/update']		=	'Main/update_service';
$route['service/delete/(:num)']	=	'Main/delete_service';

$route['brand']				=	'Main/create_brand';
$route['brand/create']		=	'Main/add_brand';
$route['brand_manage']		=	'Main/manage_brand';
$route['brand/show/(:num)']	=	'Main/view_brand';
$route['brand/update']		=	'Main/update_brand';
$route['brand/delete/(:num)']	=	'Main/delete_brand';

$route['supplier']				=	'Main/create_supplier';
$route['supplier/create']		=	'Main/add_supplier';
$route['supplier_manage']		=	'Main/manage_supplier';
$route['supplier/show/(:num)']	=	'Main/view_supplier';
$route['supplier/update']		=	'Main/update_supplier';
$route['supplier/delete/(:num)']	=	'Main/delete_supplier';

$route['suppliern']				=	'Main/create_suppliern';
$route['suppliern/create']		=	'Main/add_suppliern';
$route['suppliern_manage']		=	'Main/manage_suppliern';
$route['suppliern/show/(:num)']	=	'Main/view_suppliern';
$route['suppliern/update']		=	'Main/update_suppliern';
$route['suppliern/delete/(:num)']	=	'Main/delete_suppliern';

$route['customer']				=	'Main/create_customer';
$route['customer/create']		=	'Main/add_customer';
$route['customer_manage']		=	'Main/manage_customer';
$route['customer/show/(:num)']	=	'Main/view_customer';
$route['customer/update']		=	'Main/update_customer';
$route['customer/delete/(:num)']	=	'Main/delete_customer';

$route['salesman']				=	'Main/create_salesman';
$route['salesman/create']		=	'Main/add_salesman';
$route['salesman_manage']		=	'Main/manage_salesman';
$route['salesman/show/(:num)']	=	'Main/view_salesman';
$route['salesman/update']		=	'Main/update_salesman';
$route['salesman/delete/(:num)']	=	'Main/delete_salesman';
//product

$route['product_purchase']		=	'Product/create_purchase';
$route['product_purchase/create']		=	'Product/purchase';
$route['product_purchase_manage']		=	'Product/manage_purchase';
$route['product_purchase/show/(:num)']	=	'Product/view_purchase';
$route['product_purchase/update']		=	'Product/update_purchase';
$route['product_purchase/delete/(:num)']	=	'Product/delete_purchase';

$route['product_purchasen']		=	'Product/create_purchasen';
$route['product_purchasen/create']		=	'Product/purchasen';
$route['product_purchasen_manage']		=	'Product/manage_purchasen';
$route['product_purchasen/show/(:num)']	=	'Product/view_purchasen';
$route['product_purchasen/update']		=	'Product/update_purchasen';
$route['product_purchasen/delete/(:num)']	=	'Product/delete_purchasen';

$route['product/auto']	=	'Product/autocomplete';
$route['product/auto1']	=	'Product/autocomplete1';
$route['auto/product']	=	'Product/auto_product';
$route['product/float/create']	=	'Product/float_purchase';
$route['cheque_purchase/(:num)']	=	'Product/purchase_cheque';
$route['pur_apr_chk/(:num)']	=	'Product/purchase_cheque_approved';
$route['pur_apr_chk_ret/(:num)']	=	'Product/purchase_cheque_return';
$route['cheque_sale/(:num)']	=	'Product/sale_cheque';
$route['sale_apr_chk/(:num)']	=	'Product/sale_cheque_approved';
$route['sale_apr_chk_ret/(:num)']	=	'Product/sale_cheque_return';
//product return

$route['product_return']		=	'Product/create_product_return';
$route['product_return/create']		=	'Product/product_return';
$route['product_return_manage']		=	'Product/manage_product_return';
$route['product_return/delete/(:num)']		=	'Product/delete_product_return'
;

//insentive 
$route['insentive']				=	'Main/create_commison';
$route['insentive/create']		=	'Main/add_commison';
$route['insentive_manage']		=	'Main/manage_commison';
$route['insentive/delete/(:num)']=	'Main/delete_commison';

//sale
$route['sale']		=	'Product/create_sale';
$route['product_sale/create']		=	'Product/sale';
$route['manage_sale']		=	'Product/sale_manage';
$route['temp_sale']		=	'Product/float_sale';
$route['sale/delete/(:num)']		=	'Product/delete_sale';
$route['sale/show/(:num)']		=	'Product/show_sale';
$route['sale/update']		=	'Product/update_sale';

//sale return

$route['sale_return']		=	'Product/create_sale_return';
$route['product_sale_return/create']		=	'Product/sale_return';
$route['manage_sale_return']		=	'Product/sale_return_manage';
$route['sale_return/delete/(:num)']		=	'Product/delete_sale_return';

//sale return

$route['collection']		=	'Main/create_collection';
$route['collection/create']		=	'Main/add_collection';
$route['collection/info']		=	'Main/customer_due';
$route['collection/inv']		=	'Main/customer_invoices';
$route['collection/inv/due']		=	'Main/customer_invoices_due';
$route['collection/inv_due']		=	'Main/customer_invoice_due';
$route['manage_collection']		=	'Main/collection_manage';
$route['collection/delete/(:num)']	=	'Main/delete_collection';
$route['collection/show/(:num)']		=	'Main/view_collection';
$route['collection/update']		=	'Main/update_collection';

//payment 
$route['payment']		=	'Main/create_payment';
$route['payment/create']		=	'Main/add_payment';
$route['payment/info']		=	'Main/supplier_due';
$route['payment/inv']		=	'Main/supplier_invoices';
$route['payment/inv/due']		=	'Main/supplier_invoices_due';
$route['payment/inv_due']		=	'Main/supplier_invoice_due';
$route['manage_payment']		=	'Main/payment_manage';
$route['payment/delete/(:num)']	=	'Main/delete_payment';
$route['payment/show/(:num)']		=	'Main/show_payment';
$route['payment/update']		=	'Main/update_payment';


$route['paymentn']		=	'Main/create_paymentn';
$route['paymentn/create']		=	'Main/add_paymentn';
$route['paymentn/info']		=	'Main/suppliern_due';

$route['manage_paymentn']		=	'Main/paymentn_manage';
$route['paymentn/delete/(:num)']	=	'Main/delete_paymentn';




$route['supplier_collection']		=	'Main/create_supplier_collection';
$route['supplier_collection/create']		=	'Main/add_supplier_collection';
$route['payment/info']		=	'Main/supplier_due';
$route['manage_supplier_collection']		=	'Main/supplier_collection_manage';
$route['supplier_collection/delete/(:num)']	=	'Main/delete_supplier_collection';

//report
$route['collection_sheet']		=	'Report/collection_sheet';
$route['collection_sheet_print']		=	'Report/collection_sheet_print';
$route['purchase_report']		=	'Report/purchase_report';
$route['purchase_report_date']		=	'Report/purchase_report_search_date';
$route['purchase_report_inv']		=	'Report/purchase_report_search_inv';

$route['purchase_report_uniq/(:num)']		=	'Report/purchase_report_popup';
$route['complain_report_uniqm/(:num)']		=	'Report/complain_report_popup_m';
$route['complain_report_view/(:num)']		=	'Report/complain_report_popup_view';
$route['purchase_report/popup']	=	'Report/purchase_report_print';
$route['purchase_report/popup/(:any)/(:any)']	=	'Report/purchase_report_print_date';

$route['purchase_reportn']		=	'Report/purchase_reportn';
$route['purchase_reportn_date']		=	'Report/purchase_reportn_search_date';
$route['purchase_reportn_inv']		=	'Report/purchase_reportn_search_inv';
$route['purchase_reportn_uniq/(:num)']		=	'Report/purchase_reportn_popup';
$route['purchase_reportn/popup']	=	'Report/purchase_reportn_print';
$route['purchase_reportn/popup/(:any)/(:any)']	=	'Report/purchase_reportn_print_date';

$route['purchase_return_report']		=	'Report/purchase_return_report';
$route['purchase_return_report_date']		=	'Report/purchase_return_report_search_date';
$route['purchase_return_report_uniq/(:num)']		=	'Report/purchase_return_report_popup';
$route['purchase_return_report/popup']	=	'Report/purchase_return_report_print';
$route['purchase_return_report/popup/(:any)/(:any)']	=	'Report/purchase_return_report_print_date';

$route['sale_report']		=	'Report/sale_report';
$route['sale_report_date']		=	'Report/sale_report_search_date';
$route['sale_report_inv']		=	'Report/sale_report_search_inv';
$route['sale_report_uniq/(:num)']		=	'Report/sale_report_popup';
$route['complain_report_uniq/(:any)']		=	'Report/complain_report_popup';
$route['sale_report/popup']	=	'Report/sale_report_print';
$route['sale_report/popup/(:any)/(:any)']	=	'Report/sale_report_print_date';
$route['sale_report_date_user']		=	'Report/sale_report_search_date_user';
$route['sale_report/popup/(:any)/(:any)/(:any)']	=	'Report/sale_report_print_date_user';

$route['sale_return_report']		=	'Report/sale_return_report';
$route['sale_return_report_date']		=	'Report/sale_return_report_search_date';
$route['sale_return_report_uniq/(:num)']		=	'Report/sale_return_report_popup';
$route['sale_return_report/popup']	=	'Report/sale_return_report_print';
$route['sale_return_report/popup/(:any)/(:any)']	=	'Report/sale_return_report_print_date';

$route['stock']	=	'Report/stock_report';
$route['stock/popup']	=	'Report/stock_report_print';
$route['stock_brand']	=	'Report/stock_report_brand';
$route['stock/popup/(:num)']	=	'Report/stock_report_print_brand';
$route['stock_category']	=	'Report/stock_report_category';
$route['stock/category/(:num)']	=	'Report/stock_report_print_category';
$route['low_stock']	=	'Report/low_stock_report';
$route['low_stock/popup']	=	'Report/low_stock_report_print';

$route['damage_stock']	=	'Report/damage_stock_report';
$route['damage_stock/popup']	=	'Report/damage_stock_report_print';

$route['collection_report']		=	'Report/collection_report';
$route['collection_report_date']		=	'Report/collection_report_search_date';
$route['collection_report_uniq/(:num)']		=	'Report/collection_report_popup';
$route['collection_report/popup']	=	'Report/collection_report_print';
$route['collection_report/popup/(:any)/(:any)']	=	'Report/collection_report_print_date';
$route['cheque_collection/(:num)']	=	'Main/collection_cheque';
$route['collection_apr_chk/(:num)']	=	'Main/collection_cheque_approved';

$route['collection_apr_chk_ret/(:num)']	=	'Main/collection_cheque_return';

//warranty receive//
$route['send_approved/(:num)']	=	'Main/send_approved';
$route['nsend_approved/(:num)']	=	'Main/nsend_approved';

$route['wreceive_approved/(:num)']	=	'Main/wreceive_approved';
$route['nwreceive_approved/(:num)']	=	'Main/nwreceive_approved';

$route['wdelivery_approved/(:num)']	=	'Main/wdelivery_approved';
$route['nwdelivery_approved/(:num)']	=	'Main/nwdelivery_approved';

//warranty receive//

//warranty return//
$route['receive_approved/(:num)']	='Main/receive_approved';
$route['nreceive_approved/(:num)']	='Main/nreceive_approved';
$route['mreceive_approved/(:num)']	='Main/mreceive_approved';
$route['nmreceive_approved/(:num)']	='Main/nmreceive_approved';
$route['preceive_approved/(:num)']	='Main/preceive_approved';
$route['npreceive_approved/(:num)']	='Main/npreceive_approved';
//warranty return//

//warranty Vendor return//
//warranty receive//
$route['taka_approved']	=	'Main/taka_approved';
$route['ntaka_approved/(:num)']	=	'Main/ntaka_approved';
$route['ntaka_returned/(:num)']	=	'Main/ntaka_returned';

$route['productrec_approved/(:num)']	=	'Main/productrec_approved';
$route['nproductrec_approved/(:num)']	=	'Main/nproductrec_approved';

$route['damage_approved/(:num)']	=	'Main/damage_approved';
$route['ndamage_approved/(:num)']	=	'Main/ndamage_approved';
//warranty Vendor return//



//service//
$route['delivery_approved/(:num)']	='Main/delivery_approved';
$route['ndelivery_approved/(:num)']='Main/ndelivery_approved';

$route['complete_approved/(:num)']	='Main/complete_approved';
$route['ncomplete_approved/(:num)']='Main/ncomplete_approved';

$route['deliverys_approved/(:num)']	='Main/deliverys_approved';
$route['ndeliverys_approved/(:num)']='Main/ndeliverys_approved';

$route['service_approved/(:num)']	='Main/service_approved';
$route['nservice_approved/(:num)']='Main/nservice_approved';


//service//

$route['payment_report']		=	'Report/payment_report';
$route['payment_report_date']		=	'Report/payment_report_search_date';
$route['payment_report_uniq/(:num)']		=	'Report/payment_report_popup';
$route['payment_report/popup']	=	'Report/payment_report_print';
$route['payment_report/popup/(:any)/(:any)']	=	'Report/payment_report_print_date';
$route['cheque_payment/(:num)']	=	'Main/payment_cheque';
$route['payment_apr_chk/(:num)']	=	'Main/payment_cheque_approved';
$route['payment_apr_chk_ret/(:num)']	=	'Main/payment_cheque_return';


$route['payment_reportn']		=	'Report/payment_reportn';
$route['payment_reportn_date']		=	'Report/payment_reportn_search_date';
$route['payment_reportn_uniq/(:num)']		=	'Report/payment_reportn_popup';
$route['payment_reportn/popup']	=	'Report/payment_reportn_print';
$route['payment_reportn/popup/(:any)/(:any)']	=	'Report/payment_reportn_print_date';

$route['receivable_report']		=	'Report/receivable_report';
$route['receivable_report/popup']	=	'Report/receivable_report_print';
$route['payble_report']		=	'Report/payble_report';
$route['payble_report/popup']	=	'Report/payble_report_print';

$route['payble_reportn']		=	'Report/payble_reportn';
$route['payble_reportn/popup']	=	'Report/payble_reportn_print';

$route['twenty5_report']		=	'Report/twenty5_report';
$route['twenty5_report/popup']	=	'Report/twenty5_report_print';

$route['lv2_report']		=	'Report/lv2_report';
$route['lv2_report/popup']	=	'Report/lv2_report_print';


$route['expense_report']		=	'Report/expense_report';
$route['expense_report_date']		=	'Report/expense_report_search_date';
$route['expense_report_uniq/(:num)']		=	'Report/expense_report_popup';
$route['expense_report/popup']	=	'Report/expense_report_print';
$route['expense_report/popup/(:any)/(:any)']	=	'Report/expense_report_print_date';
$route['expense_report_head']		=	'Report/expense_report_search_head';
$route['expense_report/popups/(:any)']	=	'Report/expense_report_print_head';

$route['sale_item_report']		=	'Report/sale_item_report';
$route['sale_item_report_date']		=	'Report/sale_item_report_search_date';
$route['sale_item_report/popup']	=	'Report/sale_item_report_print';
$route['sale_item_report/popup/(:any)/(:any)']	=	'Report/sale_item_report_print_date';

$route['purchase_item_report']		=	'Report/purchase_item_report';
$route['purchase_item_report_date']		=	'Report/purchase_item_report_search_date';
$route['purchase_item_report_date_sup']		=	'Report/purchase_item_report_search_date_sup';
$route['purchase_item_report/popup']	=	'Report/purchase_item_report_print';
$route['purchase_item_report/popup/(:any)/(:any)']	=	'Report/purchase_item_report_print_date';
$route['purchase_item_report_sup/popup/(:any)/(:any)/(:any)']	=	'Report/purchase_item_report_print_date_sup';

$route['income']		=	'Report/income';
$route['income_date']		=	'Report/income_search_date';
$route['income/popup']	=	'Report/income_print';
$route['income/popup/(:any)/(:any)']	=	'Report/income_print_date';

$route['customer_history']		=	'Report/hist_cus';
$route['customer_history/popup/(:any)/(:any)/(:any)']	=	'Report/customer_history_print_date';

$route['supplier_history']		=	'Report/hist_sup';
$route['supplier_history/popup/(:any)/(:any)/(:any)']	=	'Report/supplier_history_print_date';

$route['suppliern_history']		=	'Report/hist_supn';
$route['suppliern_history/popup/(:any)/(:any)/(:any)']	=	'Report/suppliern_history_print_date';

$route['cash']		=	'Report/cash_satement';
$route['cash_date']		=	'Report/cash_satement_search';
$route['cash_print/popup/(:any)/(:any)']		=	'Report/cash_satement_print';

$route['bank_statement']			=	'Report/bank_satement';
$route['bank_print/popup/(:any)']	=	'Report/bank_satement_print';
$route['loan_statement']			=	'Report/loan_satement';
$route['loan_print/popup/(:any)']	=	'Report/loan_satement_print';

$route['bank_ledger']			=	'Report/bank_report';
$route['bank_ledger/popup']	=	'Report/bank_report_print';

$route['customer_inv_ledger']		=	'Report/inv_led_cus';
$route['supplier_inv_ledger']		=	'Report/inv_led_sub';
$route['ledger_product']			=	'Report/item_ledger';

$route['backup']		=	'Main/backup_db';

$route['asset']				=	'Main/create_asset';
$route['asset/create']		=	'Main/add_asset';
$route['asset_manage']		=	'Main/manage_asset';
$route['asset/delete/(:num)']=	'Main/delete_asset';

$route['asset_head']					=	'Main/create_asset_head';
$route['asset_head/create']				=	'Main/add_asset_head';
$route['asset_head_manage']				=	'Main/manage_asset_head';
$route['asset_head/delete/(:num)']		=	'Main/delete_asset_head';

//contact
$route['contact']				=	'Main/create_contact';
$route['contact/create']		=	'Main/add_contact';
$route['contact_manage']		=	'Main/manage_contact';
$route['contact/delete/(:num)']=	'Main/delete_contact';


//lost
$route['lost']				=	'Main/create_lost';
$route['lost/create']		=	'Main/add_lost';
$route['lost_manage']		=	'Main/manage_lost';
$route['lost/delete/(:num)']=	'Main/delete_lost';

//student
$route['student']				=	'Main/create_student';
$route['student/create']		=	'Main/add_student';
$route['student_manage']		=	'Main/manage_student';
$route['student/delete/(:num)']=	'Main/delete_student';

$route['studentp']				=	'Main/create_studentp';
$route['studentp/create']		=	'Main/add_studentp';
$route['studentp_manage']		=	'Main/manage_studentp';
$route['studentp/delete/(:num)']=	'Main/delete_studentp';

//user pay
$route['userp']				 =	'Main/create_userp';
$route['userp/create']		 =	'Main/add_userp';
$route['userp_manage']		 =	'Main/manage_userp';
$route['userp/delete/(:num)']=	'Main/delete_userp';

//user pay
$route['promotion']				 =	'Main/create_promotion';
$route['promotion/create']		 =	'Main/add_promotion';
$route['promotion_manage']		 =	'Main/manage_promotion';
$route['promotion/delete/(:num)']=	'Main/delete_promotion';

$route['promotion_approved/(:num)']	='Main/promotion_approved';
$route['npromotion_approved/(:num)']='Main/npromotion_approved';

//vendor return//
$route['vendor_return']		=	'Product/create_vendor_return';
$route['vendor_return/create']		=	'Product/vendor_return';
$route['vendor_return_manage']		=	'Product/vendor_return_manage';
$route['vendor_return/delete/(:num)']		=	'Product/delete_vendor_return';

$route['vendor_return_report']		=	'Report/vendor_return_report';
$route['vendor_return_report_date']		=	'Report/vendor_return_report_search_date';
$route['vendor_return_report/popup']	=	'Report/vendor_return_report_print';
$route['vendor_return_report/popup/(:any)/(:any)']	=	'Report/vendor_return_report_print_date';
$route['vendor_return_report_date_status']		=	'Report/vendor_return_report_search_date_status';
$route['sale_return_report_date_status']		=	'Report/sale_return_report_search_date_status';
$route['product_return_report_date_status']		=	'Report/product_return_report_search_date_status';



//Salary
$route['employee']				=	'Main/create_employee';
$route['employee/create']		=	'Main/add_employee';
$route['employee_manage']		=	'Main/manage_employee';
$route['employee/show/(:num)']	=	'Main/view_employee';
$route['employee/update']		=	'Main/update_employee';
$route['employee/delete/(:num)']	=	'Main/delete_employee';

$route['salary_head']						=	'Main/create_salary_head';
$route['salary_head/create']				=	'Main/add_salary_head';
$route['salary_head_manage']				=	'Main/manage_salary_head';
$route['salary_head/delete/(:num)']		=	'Main/delete_salary_head';

$route['pay_salary']				=	'Main/create_pay_salary';
$route['pay_salary/create']			=	'Main/add_pay_salary';
$route['pay_salary_manage']			=	'Main/manage_pay_salary';
$route['pay_salary/delete/(:num)']	=	'Main/delete_pay_salary';

$route['mns']				=	'Main/create_mns';
$route['mns/create']		=	'Main/add_mns';
$route['mns_manage']		=	'Main/manage_mns';
$route['mns/show/(:num)']	=	'Main/view_mns';
$route['mns/update']		=	'Main/update_mns';
$route['mns/delete/(:num)']	=	'Main/delete_mns';


$route['salary_ledger']		=	'Report/salary_ledger';
$route['salary_report_popup/(:any)/(:any)']	=	'Report/salary_report_print_date';

//Salary


//8.9.22//
$route['barcode']=	'Main/barcode';
$route['generate']=	'Main/generate_barcode';
$route['product_list']=	'Report/product_list';
$route['product/delete/(:num)']		=	'Product/delete_product';

// 07.11.22

$route['engineer']					=	'Main/create_engineer';
$route['engineer/create']			=	'Main/add_engineer';
$route['engineer_manage']			=	'Main/manage_engineer';
$route['engineer/delete/(:num)']	=	'Main/delete_engineer';
$route['engs_napproved/(:num)']	=	'Main/engs_napproved';
$route['engr_napproved/(:num)']	=	'Main/engr_napproved';
$route['sms/(:num)']	=	'Main/due_sms';
$route['dashboard_search']		=	'Main/dashboard_search';
$route['dashboard_search_ime']		=	'Main/dashboard_search_ime';

$route['complain_managep']		=	'Main/manage_complainp';
$route['complain_managed']		=	'Main/manage_complaind';