<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Main extends CI_Controller {
    public function __construct(){
		parent::__construct();
		$this->branch_id = $this->session->userdata('branch_id');
		$this->user_id   = $this->session->userdata('user_id');
		$timezone = 'Asia/Dhaka';
        date_default_timezone_set($timezone);
        $timestamp = time();
    	$da = date('Y-m-d',$timestamp);
    	$time = date('h:i:s',$timestamp);
    	list($month, $day, $year)=explode("-",$da);
    	list($hr, $min, $sec)=explode(":",$time);
    	$this->invoice_number = $month.$day.$year.$hr.$min.$sec.$this->user_id;
    	$this->date = date('Y-m-d',$timestamp);
    	$this->time = date('g:i a');
    	$this->pc = my_col('cash','id',$this->branch_id,'opening_cash');
		if(!$this->session->userdata('logged_in')){
		   $this->session->set_flashdata('message','Sorry,You are Not Logged In');
           $this->session->set_flashdata('message_class','alert-danger');
           return redirect('login');
		}
	}

	public function index()
	{
		$pram = ['title' => 'Dashboard'];
		$purchased = 0;$disp = 0;$duesp = 0;$purchaser = 0;$dispr = 0;$duespr = 0;$saled = 0;$dis = 0;$dues = 0;
		$saledr = 0;$disr = 0;$duesr = 0;$collection = 0;$collectionb = 0;$payment = 0;$paymentb = 0;$expensesd = 0;$sale_out = 0;$sale_in = 0;$purchase_out = 0;$purchase_in = 0;
		
		//sale
		$sl  = view_all_with_branch_report_date('product_sale_invoice',$this->branch_id,$this->date);
		foreach($sl as $s){
			$saled += $s->total_amount;
			$dis += $s->discount + $s->mdiscount;
			$dues += $s->due;
		}
		$slr  = view_all_with_branch_report_date('product_sale_return_invoice',$this->branch_id,$this->date);
		foreach($slr as $s){
			$saledr += $s->total_amount;
			$disr += $s->discount;
			$duesr += $s->due;
		}
		//purchase
		$products  = view_all_with_branch('products',$this->branch_id);
		$pur  = view_all_with_branch_report_date('purchase_invoice',$this->branch_id,$this->date);
		foreach($pur as $p){
			$purchased += $p->total_amount;
			$disp += $p->discount;
			$duesp += $p->due;
		}
		$purr  = view_all_with_branch_report_date('purchase_return_invoice',$this->branch_id,$this->date);
		foreach($purr as $pr){
			$purchaser += $pr->total_amount;
			$dispr += $pr->discount;
			$duespr += $pr->due;
		}


		$cl  = view_all_with_branch_report_date('collections',$this->branch_id,$this->date);
		foreach($cl as $c){
			$collection += $c->paid;
			if($c->approved_st == 0){
				$check_amount = 0;
			}else{
				$check_amount = $c->check_amount;
			}
			$collectionb += $c->bank_amount + $check_amount;
		}

		$pm  = view_all_with_branch_report_date('payments',$this->branch_id,$this->date);
		foreach($pm as $p){
			$payment += $p->paid;
			if($p->approved_st == 0){
				$check_amount = 0;
			}else{
				$check_amount = $p->check_amount;
			}
			$paymentb +=  $check_amount;
		}
		$ex  = view_all_with_branch_report_date('accounts',$this->branch_id,$this->date);
		foreach($ex as $e){			
			$expensesd += $e->amount;
		}
		$sale = $saled - $dis;
		$saler = $saledr - $disr;
		$purchase = $purchased - $disp;
		$amount = 0;
		$cost = 0;
		$discount = 0;
		$r_amount = 0;
		$r_cost = 0;
		$r_discount = 0;
		$expense = 0;
		$ex_amount = 0;
		$tsale= 0;
		$sale  = view_all_with_branch_report_date('product_sale_invoice',$this->branch_id,$this->date);
		foreach ($sale as $value) {
			$amount += $value->total_amount + $value->lab_trans + $value->vat;
			$cost += $value->cost_amount;
			$discount += $value->mdiscount + $value->discount;
			$tsale += $value->total_amount + $value->charge_amount;
			
		}
		
		$sale_return  = view_all_with_branch_report_date('product_sale_return_invoice',$this->branch_id,$this->date);
		foreach ($sale_return as $value) {
			$r_amount += $value->total_amount;
			$r_cost += $value->cost_amount;
			$r_discount += $value->discount;
		}
		$expenses  = view_all_with_branch_report_date('accounts',$this->branch_id,$this->date);
		foreach ($expenses as $value) {
			$ex_amount += $value->amount;
		}
		$return = $r_amount - $r_discount;
		$net_sales = $amount - $discount - $return;
		$total_discount = $discount;
		$total_cost = $cost - $r_cost;
		$gross = $net_sales - $total_cost;
		$income = $gross - $ex_amount;

		$previous_balance = 0;


	$date = date("Y-m-d");
	// ++
	$prev_sale = get_sum_prev_by_two('cash_paid','product_sale_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_col = get_sum_prev_by_two('paid','collections','branch_id',$this->branch_id,'date <',$date);
	$prev_pret = get_sum_prev_by_two('cash_paid','vendor_return','branch_id',$this->branch_id,'date <',$date);
	$with = get_sum_prev_by_two('amount','bank_withdraw','branch_id',$this->branch_id,'date <',$date);
	$supp_col = get_sum_prev_by_two('paid','supplier_collection','branch_id',$this->branch_id,'date <',$date);
	$loan_col_prev = get_sum_prev_by_two('amount','take_loan','branch_id',$this->branch_id,'date <',$date);
	// --
	$prev_pur = get_sum_prev_by_two('cash_paid','purchase_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_payments = get_sum_prev_by_two('paid','payments','branch_id',$this->branch_id,'date <',$date);
	$prev_sret = get_sum_prev_by_two('cash_paid','product_sale_return_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_ex = get_sum_prev_by_two('amount','accounts','branch_id',$this->branch_id,'date <',$date);

	$prev_oex = get_sum_prev_by_two('amount','other_accounts','branch_id',$this->branch_id,'date <',$date);
	$loan_give_prev = get_sum_prev_by_two('amount','loan','branch_id',$this->branch_id,'date <',$date);

		$pc = $this->pc;
		$prev_cash = $prev_sale + $with + $supp_col + $prev_col + $prev_pret - $prev_pur - $prev_sret - $prev_payments - $prev_ex - $prev_oex + $pc + $loan_col_prev - $loan_give_prev; 
		//end prev

		// plus data
		$sale  = get_sum_prev_by_two('cash_paid','product_sale_invoice','branch_id',$this->branch_id,'date',$date);
		$col  = get_sum_prev_by_two('paid','collections','branch_id',$this->branch_id,'date',$date);
		$pret  = get_sum_prev_by_two('cash_paid','vendor_return','branch_id',$this->branch_id,'date',$date);

		$withh  = get_sum_prev_by_two('amount','bank_withdraw','branch_id',$this->branch_id,'date',$date);

		$suppp  = get_sum_prev_by_two('paid','supplier_collection','branch_id',$this->branch_id,'date',$date);

		$loan_col  = get_sum_prev_by_two('amount','take_loan','branch_id',$this->branch_id,'date',$date);
		// plus data

		// minus data

		$pur  = get_sum_prev_by_two('cash_paid','purchase_invoice','branch_id',$this->branch_id,'date',$date);
		$pay  = get_sum_prev_by_two('paid','payments','branch_id',$this->branch_id,'date',$date);
		$sret  = get_sum_prev_by_two('cash_paid','product_sale_return_invoice','branch_id',$this->branch_id,'date',$date);
		$ex  = get_sum_prev_by_two('amount','accounts','branch_id',$this->branch_id,'date',$date);

		$oex  = get_sum_prev_by_two('amount','other_accounts','branch_id',$this->branch_id,'date',$date);

		$loan_give  = get_sum_prev_by_two('amount','loan','branch_id',$this->branch_id,'date',$date);

		$cash = $prev_cash + $sale + $col + $pret + $withh + $suppp + $loan_col - $pur - $pay - $sret - $ex - $oex - $loan_give;
		$purin  = view_all_with_branch_report_date('product_purchase',$this->branch_id,$this->date);
		foreach($purin as $pin){
			$purchase_in += $pin->quantity;
		}
		$purout  = view_all_with_branch_report_date('product_return',$this->branch_id,$this->date);
		foreach($purout as $pout){
			$purchase_out += $pout->quantity;
		}
		$saleout  = view_all_with_branch_report_date('product_sale',$this->branch_id,$this->date);
		foreach($saleout as $saout){
			$sale_out += $saout->quantity;
		}
		$salein  = view_all_with_branch_report_date('product_sale_return',$this->branch_id,$this->date);
		foreach($salein as $sain){
			$sale_in += $sain->quantity;
		}
		$comq = 0;
		$compl  = view_all_with_branch_report_date('complain_items',$this->branch_id,$this->date);
		foreach($compl as $comp){
			$comq += $comp->quantity;
		}
		$out = $purchase_out + $sale_out + $comq;
		$in = $purchase_in + $sale_in;

		$stock = 0;
		$stock_price = 0;

		$products = view_all_with_branch('products',$this->branch_id);
		foreach ($products as $key => $value) {
			$stock += $value->instock;
			$stock_price += $value->instock * $value->cost_price; 
		}
		$cs = view_all_with_branch('customers',$this->branch_id);
      	$tdc = 0;
      	$tc = 0;
      	foreach ($cs as $key => $value) {
      		$tc = ++$key;
      		$customer_id  = $value->id;
          $branch_id  = $value->branch_id;
          $tdc += round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) + get_sum_prev_by_two('due','complain','customer_id',$customer_id,'branch_id',$branch_id) + get_sum_prev_by_two('due','services','customer_id',$customer_id,'branch_id',$branch_id));
      	}
      	$sp = view_all_with_branch('suppliers',$this->branch_id);
      	$tds = 0;
      	$ts = 0;
      	foreach ($sp as $key => $value) {
      		$ts = ++$key;

      		$tds += $value->balance;
      	}
	//	$data = $this->graph();
		$y = date('Y');
		$this->load->view('dashboard',compact('pram','tsale','products','sale','dues','saler','duesr','purchased','duesp','purchaser','duespr','collection','collectionb','payment','paymentb','expensesd','income','cash','in','out','stock','stock_price','y','ts','tds','tc','tdc'));
	}
	public function dashboard_search(){
    $pram = ['title' => 'Dashboard'];
	$name = $this->input->post('name');
	$q = $this->db->where('branch_id',$this->branch_id);
	 $this->db->group_start();
	 	$q = $this->db->like('name',$name);
	 	$q = $this->db->or_like('supported',$name);
	 	$q = $this->db->or_like('barcode',$name);
	 $this->db->group_end();
	$q = $this->db->get('products');
	$productsss  = $q->result();
	
		$purchased = 0;$disp = 0;$duesp = 0;$purchaser = 0;$dispr = 0;$duespr = 0;$saled = 0;$dis = 0;$dues = 0;
		$saledr = 0;$disr = 0;$duesr = 0;$collection = 0;$collectionb = 0;$payment = 0;$paymentb = 0;$expensesd = 0;$sale_out = 0;$sale_in = 0;$purchase_out = 0;$purchase_in = 0;
		
		//sale
		$sl  = view_all_with_branch_report_date('product_sale_invoice',$this->branch_id,$this->date);
		foreach($sl as $s){
			$saled += $s->total_amount;
			$dis += $s->discount + $s->mdiscount;
			$dues += $s->due;
		}
		$slr  = view_all_with_branch_report_date('product_sale_return_invoice',$this->branch_id,$this->date);
		foreach($slr as $s){
			$saledr += $s->total_amount;
			$disr += $s->discount;
			$duesr += $s->due;
		}
		//purchase
		$pur  = view_all_with_branch_report_date('purchase_invoice',$this->branch_id,$this->date);
		foreach($pur as $p){
			$purchased += $p->total_amount;
			$disp += $p->discount;
			$duesp += $p->due;
		}
		$purr  = view_all_with_branch_report_date('purchase_return_invoice',$this->branch_id,$this->date);
		foreach($purr as $pr){
			$purchaser += $pr->total_amount;
			$dispr += $pr->discount;
			$duespr += $pr->due;
		}


		$cl  = view_all_with_branch_report_date('collections',$this->branch_id,$this->date);
		foreach($cl as $c){
			$collection += $c->paid;
			if($c->approved_st == 0){
				$check_amount = 0;
			}else{
				$check_amount = $c->check_amount;
			}
			$collectionb += $c->bank_amount + $check_amount;
		}

		$pm  = view_all_with_branch_report_date('payments',$this->branch_id,$this->date);
		foreach($pm as $p){
			$payment += $p->paid;
			if($p->approved_st == 0){
				$check_amount = 0;
			}else{
				$check_amount = $p->check_amount;
			}
			$paymentb +=  $check_amount;
		}
		$ex  = view_all_with_branch_report_date('accounts',$this->branch_id,$this->date);
		foreach($ex as $e){			
			$expensesd += $e->amount;
		}
		$sale = $saled - $dis;
		$saler = $saledr - $disr;
		$purchase = $purchased - $disp;
		$amount = 0;
		$cost = 0;
		$discount = 0;
		$r_amount = 0;
		$r_cost = 0;
		$r_discount = 0;
		$expense = 0;
		$ex_amount = 0;
		$tsale=0;
		$sale  = view_all_with_branch_report_date('product_sale_invoice',$this->branch_id,$this->date);
		foreach ($sale as $value) {
			$amount += $value->total_amount + $value->lab_trans + $value->vat;
			$cost += $value->cost_amount;
			$discount += $value->mdiscount + $value->discount;
			$tsale += $value->total_amount + $value->charge_amount;
			
		}
		
		$sale_return  = view_all_with_branch_report_date('product_sale_return_invoice',$this->branch_id,$this->date);
		foreach ($sale_return as $value) {
			$r_amount += $value->total_amount;
			$r_cost += $value->cost_amount;
			$r_discount += $value->discount;
		}
		$expenses  = view_all_with_branch_report_date('accounts',$this->branch_id,$this->date);
		foreach ($expenses as $value) {
			$ex_amount += $value->amount;
		}
		$return = $r_amount - $r_discount;
		$net_sales = $amount - $discount - $return;
		$total_discount = $discount;
		$total_cost = $cost - $r_cost;
		$gross = $net_sales - $total_cost;
		$income = $gross - $ex_amount;

		$previous_balance = 0;


	$date = date("Y-m-d");
	// ++
	$prev_sale = get_sum_prev_by_two('cash_paid','product_sale_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_col = get_sum_prev_by_two('paid','collections','branch_id',$this->branch_id,'date <',$date);
	$prev_pret = get_sum_prev_by_two('cash_paid','vendor_return','branch_id',$this->branch_id,'date <',$date);
	$with = get_sum_prev_by_two('amount','bank_withdraw','branch_id',$this->branch_id,'date <',$date);
	$supp_col = get_sum_prev_by_two('paid','supplier_collection','branch_id',$this->branch_id,'date <',$date);
	$loan_col_prev = get_sum_prev_by_two('amount','take_loan','branch_id',$this->branch_id,'date <',$date);
	// --
	$prev_pur = get_sum_prev_by_two('cash_paid','purchase_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_payments = get_sum_prev_by_two('paid','payments','branch_id',$this->branch_id,'date <',$date);
	$prev_sret = get_sum_prev_by_two('cash_paid','product_sale_return_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_ex = get_sum_prev_by_two('amount','accounts','branch_id',$this->branch_id,'date <',$date);

	$prev_oex = get_sum_prev_by_two('amount','other_accounts','branch_id',$this->branch_id,'date <',$date);
	$loan_give_prev = get_sum_prev_by_two('amount','loan','branch_id',$this->branch_id,'date <',$date);

		$pc = $this->pc;
		$prev_cash = $prev_sale + $with + $supp_col + $prev_col + $prev_pret - $prev_pur - $prev_sret - $prev_payments - $prev_ex - $prev_oex + $pc + $loan_col_prev - $loan_give_prev; 
		//end prev

		// plus data
		$sale  = get_sum_prev_by_two('cash_paid','product_sale_invoice','branch_id',$this->branch_id,'date',$date);
		$col  = get_sum_prev_by_two('paid','collections','branch_id',$this->branch_id,'date',$date);
		$pret  = get_sum_prev_by_two('cash_paid','vendor_return','branch_id',$this->branch_id,'date',$date);

		$withh  = get_sum_prev_by_two('amount','bank_withdraw','branch_id',$this->branch_id,'date',$date);

		$suppp  = get_sum_prev_by_two('paid','supplier_collection','branch_id',$this->branch_id,'date',$date);

		$loan_col  = get_sum_prev_by_two('amount','take_loan','branch_id',$this->branch_id,'date',$date);
		// plus data

		// minus data

		$pur  = get_sum_prev_by_two('cash_paid','purchase_invoice','branch_id',$this->branch_id,'date',$date);
		$pay  = get_sum_prev_by_two('paid','payments','branch_id',$this->branch_id,'date',$date);
		$sret  = get_sum_prev_by_two('cash_paid','product_sale_return_invoice','branch_id',$this->branch_id,'date',$date);
		$ex  = get_sum_prev_by_two('amount','accounts','branch_id',$this->branch_id,'date',$date);

		$oex  = get_sum_prev_by_two('amount','other_accounts','branch_id',$this->branch_id,'date',$date);

		$loan_give  = get_sum_prev_by_two('amount','loan','branch_id',$this->branch_id,'date',$date);

		$cash = $prev_cash + $sale + $col + $pret + $withh + $suppp + $loan_col - $pur - $pay - $sret - $ex - $oex - $loan_give;
		$purin  = view_all_with_branch_report_date('product_purchase',$this->branch_id,$this->date);
		foreach($purin as $pin){
			$purchase_in += $pin->quantity;
		}
		$purout  = view_all_with_branch_report_date('product_return',$this->branch_id,$this->date);
		foreach($purout as $pout){
			$purchase_out += $pout->quantity;
		}
		$saleout  = view_all_with_branch_report_date('product_sale',$this->branch_id,$this->date);
		foreach($saleout as $saout){
			$sale_out += $saout->quantity;
		}
		$salein  = view_all_with_branch_report_date('product_sale_return',$this->branch_id,$this->date);
		foreach($salein as $sain){
			$sale_in += $sain->quantity;
		}
		$comq = 0;
		$compl  = view_all_with_branch_report_date('complain_items',$this->branch_id,$this->date);
		foreach($compl as $comp){
			$comq += $comp->quantity;
		}
		$out = $purchase_out + $sale_out + $comq;
		$in = $purchase_in + $sale_in;

		$stock = 0;
		$stock_price = 0;

		$products = view_all_with_branch('products',$this->branch_id);
		foreach ($products as $key => $value) {
			$stock += $value->instock;
			$stock_price += $value->instock * $value->cost_price; 
		}
		$cs = view_all_with_branch('customers',$this->branch_id);
      	$tdc = 0;
      	$tc = 0;
      	foreach ($cs as $key => $value) {
      		$tc = ++$key;
      		$customer_id  = $value->id;
          $branch_id  = $value->branch_id;
          $tdc += round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) + get_sum_prev_by_two('due','complain','customer_id',$customer_id,'branch_id',$branch_id) + get_sum_prev_by_two('due','services','customer_id',$customer_id,'branch_id',$branch_id));
      	}
      	$sp = view_all_with_branch('suppliers',$this->branch_id);
      	$tds = 0;
      	$ts = 0;
      	foreach ($sp as $key => $value) {
      		$ts = ++$key;

      		$tds += $value->balance;
      	}
	//	$data = $this->graph();
		$y = date('Y');
		$this->load->view('dashboard',compact('pram','tsale','sale','dues','saler','duesr','purchased','duesp','purchaser','duespr','collection','collectionb','payment','paymentb','expensesd','income','cash','in','out','stock','stock_price','y','ts','tds','tc','tdc','productsss'));
}
public function dashboard_search_ime(){
    $pram = ['title' => 'Dashboard'];
    $pid = 0;
	$name = $this->input->post('name');
	$q = $this->db->where('branch_id',$this->branch_id);
	$q = $this->db->where('ime',$name);
	$q = $this->db->get('imes');
	
	if($q->num_rows()  > 0){
	    $pid = $q->row()->product_id;
	}
	
	$qp = $this->db->where('id',$pid);
	$qp = $this->db->get('products');
	
	
	$productsss  = $qp->result();
	
		$purchased = 0;$disp = 0;$duesp = 0;$purchaser = 0;$dispr = 0;$duespr = 0;$saled = 0;$dis = 0;$dues = 0;
		$saledr = 0;$disr = 0;$duesr = 0;$collection = 0;$collectionb = 0;$payment = 0;$paymentb = 0;$expensesd = 0;$sale_out = 0;$sale_in = 0;$purchase_out = 0;$purchase_in = 0;
		
		//sale
		$sl  = view_all_with_branch_report_date('product_sale_invoice',$this->branch_id,$this->date);
		foreach($sl as $s){
			$saled += $s->total_amount;
			$dis += $s->discount + $s->mdiscount;
			$dues += $s->due;
		}
		$slr  = view_all_with_branch_report_date('product_sale_return_invoice',$this->branch_id,$this->date);
		foreach($slr as $s){
			$saledr += $s->total_amount;
			$disr += $s->discount;
			$duesr += $s->due;
		}
		//purchase
		$pur  = view_all_with_branch_report_date('purchase_invoice',$this->branch_id,$this->date);
		foreach($pur as $p){
			$purchased += $p->total_amount;
			$disp += $p->discount;
			$duesp += $p->due;
		}
		$purr  = view_all_with_branch_report_date('purchase_return_invoice',$this->branch_id,$this->date);
		foreach($purr as $pr){
			$purchaser += $pr->total_amount;
			$dispr += $pr->discount;
			$duespr += $pr->due;
		}


		$cl  = view_all_with_branch_report_date('collections',$this->branch_id,$this->date);
		foreach($cl as $c){
			$collection += $c->paid;
			if($c->approved_st == 0){
				$check_amount = 0;
			}else{
				$check_amount = $c->check_amount;
			}
			$collectionb += $c->bank_amount + $check_amount;
		}

		$pm  = view_all_with_branch_report_date('payments',$this->branch_id,$this->date);
		foreach($pm as $p){
			$payment += $p->paid;
			if($p->approved_st == 0){
				$check_amount = 0;
			}else{
				$check_amount = $p->check_amount;
			}
			$paymentb +=  $check_amount;
		}
		$ex  = view_all_with_branch_report_date('accounts',$this->branch_id,$this->date);
		foreach($ex as $e){			
			$expensesd += $e->amount;
		}
		$sale = $saled - $dis;
		$saler = $saledr - $disr;
		$purchase = $purchased - $disp;
		$amount = 0;
		$cost = 0;
		$discount = 0;
		$r_amount = 0;
		$r_cost = 0;
		$r_discount = 0;
		$expense = 0;
		$ex_amount = 0;
		$tsale=0;
		$sale  = view_all_with_branch_report_date('product_sale_invoice',$this->branch_id,$this->date);
		foreach ($sale as $value) {
			$amount += $value->total_amount + $value->lab_trans + $value->vat;
			$cost += $value->cost_amount;
			$discount += $value->mdiscount + $value->discount;
			$tsale += $value->total_amount + $value->charge_amount;
			
		}
		
		$sale_return  = view_all_with_branch_report_date('product_sale_return_invoice',$this->branch_id,$this->date);
		foreach ($sale_return as $value) {
			$r_amount += $value->total_amount;
			$r_cost += $value->cost_amount;
			$r_discount += $value->discount;
		}
		$expenses  = view_all_with_branch_report_date('accounts',$this->branch_id,$this->date);
		foreach ($expenses as $value) {
			$ex_amount += $value->amount;
		}
		$return = $r_amount - $r_discount;
		$net_sales = $amount - $discount - $return;
		$total_discount = $discount;
		$total_cost = $cost - $r_cost;
		$gross = $net_sales - $total_cost;
		$income = $gross - $ex_amount;

		$previous_balance = 0;


	$date = date("Y-m-d");
	// ++
	$prev_sale = get_sum_prev_by_two('cash_paid','product_sale_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_col = get_sum_prev_by_two('paid','collections','branch_id',$this->branch_id,'date <',$date);
	$prev_pret = get_sum_prev_by_two('cash_paid','vendor_return','branch_id',$this->branch_id,'date <',$date);
	$with = get_sum_prev_by_two('amount','bank_withdraw','branch_id',$this->branch_id,'date <',$date);
	$supp_col = get_sum_prev_by_two('paid','supplier_collection','branch_id',$this->branch_id,'date <',$date);
	$loan_col_prev = get_sum_prev_by_two('amount','take_loan','branch_id',$this->branch_id,'date <',$date);
	// --
	$prev_pur = get_sum_prev_by_two('cash_paid','purchase_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_payments = get_sum_prev_by_two('paid','payments','branch_id',$this->branch_id,'date <',$date);
	$prev_sret = get_sum_prev_by_two('cash_paid','product_sale_return_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_ex = get_sum_prev_by_two('amount','accounts','branch_id',$this->branch_id,'date <',$date);

	$prev_oex = get_sum_prev_by_two('amount','other_accounts','branch_id',$this->branch_id,'date <',$date);
	$loan_give_prev = get_sum_prev_by_two('amount','loan','branch_id',$this->branch_id,'date <',$date);

		$pc = $this->pc;
		$prev_cash = $prev_sale + $with + $supp_col + $prev_col + $prev_pret - $prev_pur - $prev_sret - $prev_payments - $prev_ex - $prev_oex + $pc + $loan_col_prev - $loan_give_prev; 
		//end prev

		// plus data
		$sale  = get_sum_prev_by_two('cash_paid','product_sale_invoice','branch_id',$this->branch_id,'date',$date);
		$col  = get_sum_prev_by_two('paid','collections','branch_id',$this->branch_id,'date',$date);
		$pret  = get_sum_prev_by_two('cash_paid','vendor_return','branch_id',$this->branch_id,'date',$date);

		$withh  = get_sum_prev_by_two('amount','bank_withdraw','branch_id',$this->branch_id,'date',$date);

		$suppp  = get_sum_prev_by_two('paid','supplier_collection','branch_id',$this->branch_id,'date',$date);

		$loan_col  = get_sum_prev_by_two('amount','take_loan','branch_id',$this->branch_id,'date',$date);
		// plus data

		// minus data

		$pur  = get_sum_prev_by_two('cash_paid','purchase_invoice','branch_id',$this->branch_id,'date',$date);
		$pay  = get_sum_prev_by_two('paid','payments','branch_id',$this->branch_id,'date',$date);
		$sret  = get_sum_prev_by_two('cash_paid','product_sale_return_invoice','branch_id',$this->branch_id,'date',$date);
		$ex  = get_sum_prev_by_two('amount','accounts','branch_id',$this->branch_id,'date',$date);

		$oex  = get_sum_prev_by_two('amount','other_accounts','branch_id',$this->branch_id,'date',$date);

		$loan_give  = get_sum_prev_by_two('amount','loan','branch_id',$this->branch_id,'date',$date);

		$cash = $prev_cash + $sale + $col + $pret + $withh + $suppp + $loan_col - $pur - $pay - $sret - $ex - $oex - $loan_give;
		$purin  = view_all_with_branch_report_date('product_purchase',$this->branch_id,$this->date);
		foreach($purin as $pin){
			$purchase_in += $pin->quantity;
		}
		$purout  = view_all_with_branch_report_date('product_return',$this->branch_id,$this->date);
		foreach($purout as $pout){
			$purchase_out += $pout->quantity;
		}
		$saleout  = view_all_with_branch_report_date('product_sale',$this->branch_id,$this->date);
		foreach($saleout as $saout){
			$sale_out += $saout->quantity;
		}
		$salein  = view_all_with_branch_report_date('product_sale_return',$this->branch_id,$this->date);
		foreach($salein as $sain){
			$sale_in += $sain->quantity;
		}
		$comq = 0;
		$compl  = view_all_with_branch_report_date('complain_items',$this->branch_id,$this->date);
		foreach($compl as $comp){
			$comq += $comp->quantity;
		}
		$out = $purchase_out + $sale_out + $comq;
		$in = $purchase_in + $sale_in;

		$stock = 0;
		$stock_price = 0;

		$products = view_all_with_branch('products',$this->branch_id);
		foreach ($products as $key => $value) {
			$stock += $value->instock;
			$stock_price += $value->instock * $value->cost_price; 
		}
		$cs = view_all_with_branch('customers',$this->branch_id);
      	$tdc = 0;
      	$tc = 0;
      	foreach ($cs as $key => $value) {
      		$tc = ++$key;
      		$customer_id  = $value->id;
          $branch_id  = $value->branch_id;
          $tdc += round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) + get_sum_prev_by_two('due','complain','customer_id',$customer_id,'branch_id',$branch_id) + get_sum_prev_by_two('due','services','customer_id',$customer_id,'branch_id',$branch_id));
      	}
      	$sp = view_all_with_branch('suppliers',$this->branch_id);
      	$tds = 0;
      	$ts = 0;
      	foreach ($sp as $key => $value) {
      		$ts = ++$key;

      		$tds += $value->balance;
      	}
	//	$data = $this->graph();
		$y = date('Y');
		$this->load->view('dashboard',compact('pram','tsale','sale','dues','saler','duesr','purchased','duesp','purchaser','duespr','collection','collectionb','payment','paymentb','expensesd','income','cash','in','out','stock','stock_price','y','ts','tds','tc','tdc','productsss'));
}
	//branch
	public function create_branch()
	{
		$pram = ['title' => 'Add Branch'];
// 		$r=$this->db->get('services')->result();
// 		foreach($r as $v){
// 		    $date = $v->date;
// 		    $this->db->set('delivery_date',$date);
// 		  //  $this->db->where('delivery_date','');
// 		    $this->db->where('id',$v->id);
// 		    $this->db->update('services');
// 		}
		$this->load->view('branch/add_branch',compact('pram'));
	}
	public function add_branch(){
			$config =[
	                  'upload_path'		=>'./assets/branch_img/',
	                  'allowed_types'	=>'png|jpg|gif|jpeg|PNG|JPG|JPEG',
	                  'max_size'        => '5120',
			         ];
		    $file = 'assets/branch_img/'. $_FILES['userfile']['name'];
		    $file_type = pathinfo($file, PATHINFO_EXTENSION);
            $file_size = $_FILES['userfile']['size'];

		    if(file_exists($file))
			{
				echo 2;
			}
		    else
		    {
		    	if($file_type == 'png' || $file_type == 'jpg' || $file_type == 'jpeg' ||$file_type == 'PNG' || $file_type == 'JPG' || $file_type == 'JPEG' || $file_type == 'gif')
		    	{
		    	if($file_size < 5242880)
		    	{
               
		    	$this->load->library('upload',$config);
				
                if (  $this->upload->do_upload())
				{
                    
					$post  = $this->input->post();
					$data = $this->upload->data();
					$image_path = 'assets/branch_img/'.$data['raw_name'].$data['file_ext'];
					$post['logo']=addslashes($image_path);
					$post['date']=date("Y-m-d",strtotime($this->input->post('date')));
					$info = add_all($post,'branches');
                    if($info)
					  echo 1;
					else 
					  echo 0;					
				}
				else
				  {	   
                    echo 'n_p';
				  }
		    	}
		    	else
		    	{
		    		echo 'f_s';
		    	}
               
		    	}
		    	else
		    	{
		    		echo 'f_t';
		    	}
		       
		    }
		}
	public function manage_branch()
	{
		$pram = ['title' => 'Manage Branch'];
		$branches = view_all('branches');
		$this->load->view('branch/manage_branch',compact('pram','branches'));
	}
	public function view_branch()
	{
		$pram = ['title' => 'Update Branch'];
		$id=$this->uri->segment(3);
		$branch = view_all_by_id($id,'branches');
		$this->load->view('branch/update_branch',compact('pram','branch'));
	}
	public function update_branch()
	{
        $image = $_FILES['userfile']['name'];
        $id = $this->input->post('id');
        $old_image = my_col('logo','id',$id,'branches');
		if($image){
			$config =[
	                  'upload_path'		=>'./assets/branch_img/',
	                  'allowed_types'	=>'png|jpg|gif|jpeg|PNG|JPG|JPEG',
	                  'max_size'        => '5120',
			         ];;
		    $file = 'assets/branch_img/'. $_FILES['userfile']['name'];
		    $file_type = pathinfo($file, PATHINFO_EXTENSION);
            $file_size = $_FILES['userfile']['size'];     
			if(file_exists($file))
			{
				echo 2;
			}
		    else
		    {
		    	if($file_type == 'png' || $file_type == 'jpg' || $file_type == 'jpeg' ||$file_type == 'PNG' || $file_type == 'JPG' || $file_type == 'JPEG' || $file_type == 'gif')
		    	{
		    	if($file_size < 5242880)
		    	{
               
		    	$this->load->library('upload',$config);
				
                if (  $this->upload->do_upload())
				{
                    
					$post  = $this->input->post();
					$data = $this->upload->data();
					$image_path = 'assets/branch_img/'.$data['raw_name'].$data['file_ext'];
					$post['logo']=addslashes($image_path);					
					$info = update_all($id,'branches',$post);
                    if($info){
                      unlink($old_image);
					  echo 1;    
                    }
					else 
					  echo 0;					
				}
				else
				  {	   
                    echo 'n_p';
				  }
		    	}
		    	else
		    	{
		    		echo 'f_s';
		    	}
               
		    	}
		    	else
		    	{
		    		echo 'f_t';
		    	}
		       
		    }
		}
		else
		{
			$post = $this->input->post();
            $info = update_all($id,'branches',$post);
	            if($info)
				  echo 1;
				else 
			      echo 0;
		}
	}
	public function delete_branch()
	{
		$id=$this->uri->segment(3);
	    $image = my_col('logo','id',$id,'branches');
		$data = delete_by_id($id,'branches');
		if($data){
			unlink($image);
		    echo 1;
		}
		else 
		 echo 0;
	}
	//user
	public function create_user()
	{
		$pram = ['title' => 'Add User'];
		$branches = view_all('branches');
		$this->load->view('user/add_user',compact('pram','branches'));
	}
	public function add_user(){
		$user_name = $this->input->post('user_name');
        
	    $query = username_check($user_name,'users');        
		if($query->num_rows() != 0)
		{
			echo $query->row()->user_name;
		}
		else
		{
		$config =[
                  'upload_path'		=>'./assets/user_img/',
                  'allowed_types'	=>'png|jpg|gif|jpeg|PNG|JPG|JPEG',
                  'max_size'        => '5120',
		         ];
	    $file = 'assets/user_img/'. $_FILES['userfile']['name'];
	    $file_type = pathinfo($file, PATHINFO_EXTENSION);
        $file_size = $_FILES['userfile']['size'];

	    if(file_exists($file))
		{
			echo 2;
		}
	    else
	    {
	    	if($file_type == 'png' || $file_type == 'jpg' || $file_type == 'jpeg' ||$file_type == 'PNG' || $file_type == 'JPG' || $file_type == 'JPEG' || $file_type == 'gif')
	    	{
	    	if($file_size < 5242880)
	    	{
           
	    	$this->load->library('upload',$config);
			
            if (  $this->upload->do_upload())
			{
                $acess = $this->input->post('access_permission');
			    $per = implode(",",$acess);
				$data = $this->upload->data();
				$image_path = 'assets/user_img/'.$data['raw_name'].$data['file_ext'];
				 $img=addslashes($image_path);
				 $date=date("Y-m-d",strtotime($this->input->post('date')));
				$post = [
					'status'	=>	$this->input->post('status'),
					'name'		=>	$this->input->post('name'),
					'user_name'	=>	$this->input->post('user_name'),
					'password'	=>	md5($this->input->post('password')),
					'branch_id'	=>	$this->input->post('branch_id'),
					'contact_no'=>	$this->input->post('contact_no'),
					'image'		=>	$img,
					'permission'=>	$per,
					'date'		=>	$date
				];
				$info = add_all($post,'users');
				
                if($info)
				  echo 1;
				else 
				  echo 0;					
			}
			else
			  {	   
                echo 'n_p';
			  }
	    	}
	    	else
	    	{
	    		echo 'f_s';
	    	}
           
	    	}
	    	else
	    	{
	    		echo 'f_t';
	    	}
	       
	    }
	}
}
	public function manage_user()
	{
	    
		$pram = ['title' => 'Manage User'];
		$users = view_all_with_branch('users',$this->branch_id);
		$this->load->view('user/manage_user',compact('pram','users'));
	}
	public function view_user()
	{
		$pram = ['title' => 'Update User'];
		$id=$this->uri->segment(3);
		$user = view_all_by_id($id,'users');
		$branches = view_all('branches');
		$this->load->view('user/update_user',compact('pram','user','branches'));
	}
	public function update_user()
	{
        $image = $_FILES['userfile']['name'];
        $id = $this->input->post('id');
        $date=date("Y-m-d",strtotime($this->input->post('date')));
        $old_image = my_col('image','id',$id,'users');
		if($image){
			$config =[
	                  'upload_path'		=>'./assets/user_img/',
	                  'allowed_types'	=>'png|jpg|gif|jpeg|PNG|JPG|JPEG',
	                  'max_size'        => '5120',
			         ];;
		    $file = 'assets/user_img/'. $_FILES['userfile']['name'];
		    $file_type = pathinfo($file, PATHINFO_EXTENSION);
            $file_size = $_FILES['userfile']['size'];     
			if(file_exists($file))
			{
				echo 2;
			}
		    else
		    {
		    	if($file_type == 'png' || $file_type == 'jpg' || $file_type == 'jpeg' ||$file_type == 'PNG' || $file_type == 'JPG' || $file_type == 'JPEG' || $file_type == 'gif')
		    	{
		    	if($file_size < 5242880)
		    	{
               
		    	$this->load->library('upload',$config);
				
                if (  $this->upload->do_upload())
				{
                    
					
					$data = $this->upload->data();
					$image_path = 'assets/user_img/'.$data['raw_name'].$data['file_ext'];
					$img=addslashes($image_path);			
					$acess = $this->input->post('access_permission');
					$per = implode(",",$acess);
					$p = $this->input->post('password');
                    if($p){
					$post = [
					'status'	=>	$this->input->post('status'),
					'name'		=>	$this->input->post('name'),
					'branch_id'	=>	$this->input->post('branch_id'),
					'contact_no'=>	$this->input->post('contact_no'),
					'permission'=>	$per,
					'date'		=>	$date,
					'password'		=>	md5($p),
					'image'		=>	$img
				];	
                    }else{
                        $post = [
					'status'	=>	$this->input->post('status'),
					'name'		=>	$this->input->post('name'),
					'branch_id'	=>	$this->input->post('branch_id'),
					'contact_no'=>	$this->input->post('contact_no'),
					'permission'=>	$per,
					'date'		=>	$date,
					'image'		=>	$img
				];
                    }
            	   
            	 
					$info = update_all($id,'users',$post);
                    if($info){
                      unlink($old_image);
					  echo 1;    
                    }
					else 
					  echo 0;					
				}
				else
				  {	   
                    echo 'n_p';
				  }
		    	}
		    	else
		    	{
		    		echo 'f_s';
		    	}
               
		    	}
		    	else
		    	{
		    		echo 'f_t';
		    	}
		       
		    }
		}
		else
		{
			
			$acess = $this->input->post('access_permission');
			$per = implode(",",$acess);
			$p = $this->input->post('password');
                    if($p){
					$post = [
					'status'	=>	$this->input->post('status'),
					'name'		=>	$this->input->post('name'),
					'branch_id'	=>	$this->input->post('branch_id'),
					'contact_no'=>	$this->input->post('contact_no'),
					'permission'=>	$per,
					'date'		=>	$date,
					'password'		=>	md5($p),
				];	
                    }else{
                        $post = [
					'status'	=>	$this->input->post('status'),
					'name'		=>	$this->input->post('name'),
					'branch_id'	=>	$this->input->post('branch_id'),
					'contact_no'=>	$this->input->post('contact_no'),
					'permission'=>	$per,
					'date'		=>	$date,
				];
                    }
            $info = update_all($id,'users',$post);
	            if($info)
				  echo 1;
				else 
			      echo 0;
		}
	}
	public function delete_user()
	{
		$id=$this->uri->segment(3);
	    $image = my_col('image','id',$id,'users');
		$data = delete_by_id($id,'users');
		if($data){
			unlink($image);
		    echo 1;
		}
		else 
		 echo 0;
	}
	public function create_bank()
	{
		$pram = ['title' => 'Add Bank'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('banks');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code+1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('bank/add_bank',compact('pram','code'));
	}
	public function add_bank()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
		$name = $this->input->post('name');
		$post['date'] = date('Y-m-d');
		$post['final_balance'] = $this->input->post('balance');
		$names = num_rows('name',$name,'banks');
		if($names)
			echo $name;
		else{
			$info = add_all($post,'banks');
			if($info)
				echo 1;
			else 
				echo 0;
		}
	}
	public function manage_bank()
	{
		$pram  = ['title' => 'Manage Bank'];
		$banks = view_all_with_branch('banks',$this->branch_id);
		 $this->load->view('bank/manage_bank',compact('pram','banks'));
	}
	
	public function delete_bank()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'banks');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	
	public function create_bank_withdraw()
	{
		$pram = ['title' => 'Bank Withdraw'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('bank_withdraw');
		if($query->num_rows() > 0){
			$id = $query->row()->id;
			if($id){
				$code = $id + 1;
			}
		}else{
			$code = 1;
		}

		$this->load->view('bank/add_withdraw',compact('pram','code'));
	}
	public function add_bank_withdraw()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	  //  $post['date'] = date('Y-m-d');
	    $bank_id = $this->input->post('bank_id');
	    $amount = $this->input->post('amount');
	    $bal = my_col('final_balance','id',$bank_id,'banks');
	    $balance = $bal - $amount;
		$info = add_all($post,'bank_withdraw');
		if($info){
			$up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balance);
			echo 1;
		}
		else 
			echo 0;
	}
	public function manage_bank_withdraw()
	{
		$pram  = ['title' => 'Manage Bank Withdraw'];
		$banks = view_all_with_branch('bank_withdraw',$this->branch_id);
		 $this->load->view('bank/manage_bank_withdraw',compact('pram','banks'));
	}
	
	public function delete_bank_withdraw()
	{
	    $id=$this->uri->segment(3);
	    $bank_id = my_col('bank_id','id',$id,'bank_withdraw');
	    $amount = my_col('amount','id',$id,'bank_withdraw');
	    $bal = my_col('final_balance','id',$bank_id,'banks');
		$balance = $bal + $amount;
		$data = delete_by_id($id,'bank_withdraw');
		if($data){
			$up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balance);    
		 echo 1;
		}
		else 
		 echo 0;	
	}
	public function create_head()
	{
		$pram = ['title' => 'Add Head'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('heads');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		
		$this->load->view('head/add_head',compact('pram','code'));
	}
	public function add_head()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;

			$info = add_all($post,'heads');
			if($info)
				echo 1;
			else 
				echo 0;

	}
	public function manage_head()
	{
		$pram  = ['title' => 'Manage Accpunt Head'];
		$heads = view_all_with_branch('heads',$this->branch_id);
		 $this->load->view('head/manage_head',compact('pram','heads'));
	}
	
	public function delete_head()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'heads');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_subject()
	{
		$pram = ['title' => 'Add subject'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('subjects');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		
		$this->load->view('subject/add',compact('pram','code'));
	}
	public function add_subject()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;

		$info = add_all($post,'subjects');
		if($info)
			echo 1;
		else 
			echo 0;

	}
	public function manage_subject()
	{
		$pram  = ['title' => 'Manage subject'];
		$subjects = view_all_with_branch('subjects',$this->branch_id);
		 $this->load->view('subject/manage',compact('pram','subjects'));
	}
	
	public function delete_subject()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'subjects');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_place()
	{
		$pram = ['title' => 'Add place'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('places');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		
		$this->load->view('place/add',compact('pram','code'));
	}
	public function add_place()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;

		$info = add_all($post,'places');
		if($info)
			echo 1;
		else 
			echo 0;

	}
	public function manage_place()
	{
		$pram  = ['title' => 'Manage Accpunt place'];
		$places = view_all_with_branch('places',$this->branch_id);
		 $this->load->view('place/manage',compact('pram','places'));
	}
	
	public function delete_place()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'places');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_khat()
	{
		$pram = ['title' => 'Add khat'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('khats');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		
		$this->load->view('khat/add',compact('pram','code'));
	}
	public function add_khat()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;

		$info = add_all($post,'khats');
		if($info)
			echo 1;
		else 
			echo 0;

	}
	public function manage_khat()
	{
		$pram  = ['title' => 'Manage Accpunt khat'];
		$khats = view_all_with_branch('khats',$this->branch_id);
		 $this->load->view('khat/manage',compact('pram','khats'));
	}
	
	public function delete_khat()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'khats');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_account()
	{
		$pram = ['title' => 'Add Account'];
		$heads = view_all_with_branch('heads',$this->branch_id);
		$prsons = view_all_with_branch('prsons',$this->branch_id);
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('accounts');
		if($query->num_rows() > 0){
			$id = $query->row()->id;
			if($id){
				$code = $id + 1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('account/add_account',compact('pram','heads','code','prsons'));
	}
	public function add_account()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
			$info = add_all($post,'accounts');
			if($info)
				echo 1;
			else 
				echo 0;
	}
	public function manage_account()
	{
		$pram  = ['title' => 'Manage Account'];
		$accounts = view_all_with_branch('accounts',$this->branch_id);
		 $this->load->view('account/manage_account',compact('pram','accounts'));
	}
	public function view_account()
	{
		$pram  = ['title' => 'Update Accoount'];
		$id = $this->uri->segment(3);
		$account = view_all_by_id($id,'accounts');
		$heads = view_all_with_branch('heads',$this->branch_id);
		$this->load->view('account/update_account',compact('pram','account','heads'));
	}
	public function update_account()
	{        
		$id = $this->input->post('id');
		$post = $this->input->post();
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
		 $done = update_all($id,'accounts',$post);
		 
		 if($done)
		    echo 1;
		 else 
			echo 0;
	}
	
	public function delete_account()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'accounts');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_loan_head()
	{
		$pram = ['title' => 'Add Loan Head'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('loan_head');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		
		$this->load->view('loan_head/add_head',compact('pram','code'));
	}
	public function add_loan_head()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;

			$info = add_all($post,'loan_head');
			if($info)
				echo 1;
			else 
				echo 0;

	}
	public function manage_loan_head()
	{
		$pram  = ['title' => 'Manage Loan Head'];
		$heads = view_all_with_branch('loan_head',$this->branch_id);
		 $this->load->view('loan_head/manage_head',compact('pram','heads'));
	}
	
	public function delete_loan_head()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'loan_head');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	
	public function create_loan()
	{
		$pram = ['title' => 'Add Loan'];
		$heads = view_all_with_branch('loan_head',$this->branch_id);
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('loan');
		if($query->num_rows() > 0){
			$id = $query->row()->id;
			if($id){
				$code = $id + 1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('loan/add_account',compact('pram','heads','code'));
	}
	public function add_loan()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));

			$info = add_all($post,'loan');

			if($info)
				echo 1;
			else 
				echo 0;
	}
	public function manage_loan()
	{
		$pram  = ['title' => 'Manage Loan'];
		$accounts = view_all_with_branch('loan',$this->branch_id);
		 $this->load->view('loan/manage_account',compact('pram','accounts'));
	}
	
	
	public function delete_loan()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'loan');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_take_loan()
	{
		$pram = ['title' => 'Add Take Loan'];
		$heads = view_all_with_branch('loan_head',$this->branch_id);
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('take_loan');
		if($query->num_rows() > 0){
			$id = $query->row()->id;
			if($id){
				$code = $id + 1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('take_loan/add_account',compact('pram','heads','code'));
	}
	public function add_take_loan()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));

			$info = add_all($post,'take_loan');

			if($info)
				echo 1;
			else 
				echo 0;
	}
	public function manage_take_loan()
	{
		$pram  = ['title' => 'Manage Take Loan'];
		$accounts = view_all_with_branch('take_loan',$this->branch_id);
		 $this->load->view('take_loan/manage_account',compact('pram','accounts'));
	}
	
	
	public function delete_take_loan()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'take_loan');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_other_expense()
	{
		$pram = ['title' => 'Add Other Expense'];
		$heads = view_all('heads');
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('other_accounts');
		if($query->num_rows() > 0){
			$id = $query->row()->id;
			if($id){
				$code = $id + 1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('other_account/add_account',compact('pram','heads','code'));
	}
	public function add_other_expense()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['type_id'] = 3;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
	    $bank_id = $this->input->post('bank_id');
	    $amount = $this->input->post('amount');
	    $bal = my_col('final_balance','id',$bank_id,'banks');
	    $balance = $bal + $amount;
		$info = add_all($post,'other_accounts');
		if($info){
			$up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balance);  
			echo 1;
		}
		else 
			echo 0;
	}
	public function manage_other_expense()
	{
		$pram  = ['title' => 'Manage Other Expense'];
		$accounts = view_all_with_branch('other_accounts',$this->branch_id);
		 $this->load->view('other_account/manage_account',compact('pram','accounts'));
	}

	public function create_deposit()
	{
		$pram = ['title' => 'Add Deposit'];
		$heads = view_all('heads');
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('other_accounts');
		if($query->num_rows() > 0){
			$id = $query->row()->id;
			if($id){
				$code = $id + 1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('bank/add_deposit',compact('pram','heads','code'));
	}
	public function manage_deposit()
	{
		$pram  = ['title' => 'Manage Deposit'];
		$accounts = view_all_with_branch('other_accounts',$this->branch_id);
		 $this->load->view('bank/manage_deposit',compact('pram','accounts'));
	}
	public function view_other_expense()
	{
		$pram  = ['title' => 'Update Other Expense'];
		$id = $this->uri->segment(3);
		$account = view_all_by_id($id,'other_accounts');
		$heads = view_all_with_branch('heads',$this->branch_id);
		$this->load->view('other_account/update_account',compact('pram','account','heads'));
	}
	public function update_other_expense()
	{        
		$id = $this->input->post('id');
		$post = $this->input->post();
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
		 $done = update_all($id,'other_accounts',$post);
		 
		 if($done)
		    echo 1;
		 else 
			echo 0;
	}
	
	public function delete_other_expense()
	{
	    $id=$this->uri->segment(3);
	    $bank_id = my_col('bank_id','id',$id,'other_accounts');
	    $amount = my_col('amount','id',$id,'other_accounts');
	    $bal = my_col('final_balance','id',$bank_id,'banks');
		$balance = $bal - $amount;
		$data = delete_by_id($id,'other_accounts');
		if($data){
			$up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balance);  
		 echo 1;
		}
		else 
		 echo 0;	
	}
	public function create_category()
	{
		$pram = ['title' => 'Add Category'];
		$this->load->view('category/add_category',compact('pram'));
	}
	public function add_category()
	{
		$post['name'] = $this->input->post('name');				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
			$info = add_all($post,'categories');
			if($info)
				echo 1;
			else 
				echo 0;
	}
	public function manage_category()
	{
		$pram  = ['title' => 'Manage Category'];
		$categories = view_all_with_branch('categories',$this->branch_id);
		 $this->load->view('category/manage_category',compact('pram','categories'));
	}
	public function view_category()
	{
		$pram  = ['title' => 'Update Category'];
		$id = $this->uri->segment(3);
		$category = view_all_by_id($id,'categories');
		$this->load->view('category/update_category',compact('pram','category'));
	}
	public function update_category()
	{        
		$id = $this->input->post('id');
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['name'] = $this->input->post('name');
		 $done = update_all($id,'categories',$post);
		 
		 if($done)
		    echo 1;
		 else 
			echo 0;
	}
	
	public function delete_category()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'categories');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_transport()
	{
		$pram = ['title' => 'Add Transport'];
		$this->load->view('transport/add_transport',compact('pram'));
	}
	public function add_transport()
	{
		$post['name'] = $this->input->post('name');				
	    $post['branch_id'] = $this->branch_id;
			$info = add_all($post,'transport');
			if($info)
				echo 1;
			else 
				echo 0;
	}
	public function manage_sale_incentive()
	{
		$pram  = ['title' => 'Manage Transport'];
		$categories = view_all_with_branch('sale_commisons',$this->branch_id);
		 $this->load->view('cash/com',compact('pram','categories'));
	}
	public function manage_transport()
	{
		$pram  = ['title' => 'Manage Transport'];
		$categories = view_all_with_branch('transport',$this->branch_id);
		 $this->load->view('transport/manage_transport',compact('pram','categories'));
	}
	
	public function delete_transport()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'transport');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function open_cash()
	{
		$pram  = ['title' => 'Manage Cash'];
		$categories = view_all_with_branch('opening_cash',$this->branch_id);
		 $this->load->view('cash/cash.php',compact('pram','categories'));
	}
	public function update_cash()
	{        
		$id = $this->input->post('id');
		$post['branch_id'] = $this->branch_id;
	    $post['cash'] = $this->input->post('cash');
		$done = update_all($id,'opening_cash',$post);
		 
		 if($done)
		    redirect('open_cash');
		 else 
			echo 0;
	}
	public function update_bank()
	{        
		$id = $this->input->post('id');
	  $post['name'] = $this->input->post('name');
		$done = update_all($id,'banks',$post);		 
		 if($done)
		    redirect('bank_manage');
		 else 
			echo 0;
	}
	public function create_brand()
	{
		$pram = ['title' => 'Add Brand'];
		$this->load->view('brand/add_brand',compact('pram'));
	}
	public function add_brand()
	{
		$post['name'] = $this->input->post('name');				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
			$info = add_all($post,'brands');
			if($info)
				echo 1;
			else 
				echo 0;
	}
	public function manage_brand()
	{
		$pram  = ['title' => 'Manage Brand'];
		$brands = view_all_with_branch('brands',$this->branch_id);
		 $this->load->view('brand/manage_brand',compact('pram','brands'));
	}
	public function view_brand()
	{
		$pram  = ['title' => 'Update Brand'];
		$id = $this->uri->segment(3);
		$brand = view_all_by_id($id,'brands');
		$this->load->view('brand/update_brand',compact('pram','brand'));
	}
	public function update_brand()
	{        
		$id = $this->input->post('id');
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['name'] = $this->input->post('name');
		 $done = update_all($id,'brands',$post);
		 
		 if($done)
		    echo 1;
		 else 
			echo 0;
	}	
	public function delete_brand()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'brands');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_supplier()
	{
		$pram = ['title' => 'Add Supplier'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('suppliers');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('supplier/add_supplier',compact('pram','code'));
	}
	public function add_supplier()
	{
		$post = $this->input->post();
		$post['balance'] = $this->input->post('previous_balance');
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;	    
	    $info = add_all($post,'suppliers');
		if($info)
			echo 1;
		else 
			echo 0;
	}
	public function manage_supplier()
	{
		$pram  = ['title' => 'Manage Supplier'];
		$suppliers = view_all_with_branch('suppliers',$this->branch_id);
		$this->load->view('supplier/manage_supplier',compact('pram','suppliers'));
	}
	public function view_supplier()
	{
		$pram  = ['title' => 'Update Supplier'];
		$id = $this->uri->segment(3);
		$supplier = view_all_by_id($id,'suppliers');
		$this->load->view('supplier/update_supplier',compact('pram','supplier'));
	}
	public function update_supplier()
	{  
		$post = $this->input->post();      
		$id = $this->input->post('id');
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
		$post['prev_bal'] = $this->input->post('previous_balance');	
	//	$post['balance'] = $this->input->post('previous_balance');	
	    $done = update_all($id,'suppliers',$post);
		 
		 if($done)
		    echo 1;
		 else 
			echo 0;
	}
	
	public function delete_supplier()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'suppliers');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}

	public function create_suppliern()
	{
		$pram = ['title' => 'Add Supplier'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('suppliersn');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('suppliern/add_supplier',compact('pram','code'));
	}
	public function add_suppliern()
	{
		$post = $this->input->post();
		$post['balance'] = $this->input->post('previous_balance');
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;	    
	    $info = add_all($post,'suppliersn');
		if($info)
			echo 1;
		else 
			echo 0;
	}
	public function manage_suppliern()
	{
		$pram  = ['title' => 'Manage Supplier'];
		$suppliers = view_all_with_branch('suppliersn',$this->branch_id);
		$this->load->view('suppliern/manage_supplier',compact('pram','suppliers'));
	}
	public function view_suppliern()
	{
		$pram  = ['title' => 'Update Supplier'];
		$id = $this->uri->segment(3);
		$supplier = view_all_by_id($id,'suppliersn');
		$this->load->view('suppliern/update_supplier',compact('pram','supplier'));
	}
	public function update_suppliern()
	{  
		$post = $this->input->post();      
		$id = $this->input->post('id');
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
		$post['prev_bal'] = $this->input->post('previous_balance');	
	    $done = update_all($id,'suppliersn',$post);
		 
		 if($done)
		    echo 1;
		 else 
			echo 0;
	}
	
	public function delete_suppliern()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'suppliersn');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_customer()
	{
		$pram = ['title' => 'Add Customer'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('customers');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		
		$this->load->view('customer/add_customer',compact('pram','code'));
	}
	public function add_customer()
	{
		

		    $image = $_FILES['userfile']['name'];
       // $id = $this->input->post('id');
       // $old_image = my_col('logo','id',$id,'branches');
		if($image){
			$config =[
	                  'upload_path'		=>'./assets/cus/',
	                  'allowed_types'	=>'png|jpg|gif|jpeg|PNG|JPG|JPEG',
	                  'max_size'        => '5120',
			         ];;
		    $file = 'assets/cus/'. $_FILES['userfile']['name'];
		    $file_type = pathinfo($file, PATHINFO_EXTENSION);
            $file_size = $_FILES['userfile']['size'];     
			if(file_exists($file))
			{
				echo 2;
			}
		    else
		    {
		    	if($file_type == 'png' || $file_type == 'jpg' || $file_type == 'jpeg' ||$file_type == 'PNG' || $file_type == 'JPG' || $file_type == 'JPEG' || $file_type == 'gif')
		    	{
		    	if($file_size < 5242880)
		    	{
               
		    	$this->load->library('upload',$config);
				
                if (  $this->upload->do_upload())
				{
                    
					$data = $this->upload->data();
					$image_path = 'assets/cus/'.$data['raw_name'].$data['file_ext'];
					$post = $this->input->post();
					$post['balance'] = $this->input->post('previous_balance');
					$post['branch_id'] = $this->branch_id;
				  $post['user_id'] = $this->user_id;
				  $post['logo']=addslashes($image_path);	    
				  $info = add_all($post,'customers');
					if($info)
						echo 1;
					else 
						echo 0;
								
					// $info = update_all($id,'branches',$post);
     //                if($info){
     //                  unlink($old_image);
					//   echo 1;    
     //                }
					// else 
					//   echo 0;					
				}
				else
				  {	   
                    echo 'n_p';
				  }
		    	}
		    	else
		    	{
		    		echo 'f_s';
		    	}
               
		    	}
		    	else
		    	{
		    		echo 'f_t';
		    	}
		       
		    }
		}
		else
		{
			$post = $this->input->post();
			$post['balance'] = $this->input->post('previous_balance');
			$post['branch_id'] = $this->branch_id;
		    $post['user_id'] = $this->user_id;	    
		    $info = add_all($post,'customers');
			if($info)
				echo 1;
			else 
				echo 0;
		}
	}
	public function manage_customer()
	{
		$pram  = ['title' => 'Manage customer'];
		$customers = view_all_with_branch('customers',$this->branch_id);
		$this->load->view('customer/manage_customer',compact('pram','customers'));
	}
	public function view_customer()
	{
		$pram  = ['title' => 'Update customer'];
		$id = $this->uri->segment(3);
		$customer = view_all_by_id($id,'customers');
		$this->load->view('customer/update_customer',compact('pram','customer'));
	}
	public function update_customer()
	{  
    $image = $_FILES['userfile']['name'];
    $id = $this->input->post('id');
    $old_image = my_col('logo','id',$id,'customers');
		if($image){
			$config =[
	                  'upload_path'		=>'./assets/cus/',
	                  'allowed_types'	=>'png|jpg|gif|jpeg|PNG|JPG|JPEG',
	                  'max_size'        => '5120',
			         ];;
		    $file = 'assets/cus/'. $_FILES['userfile']['name'];
		    $file_type = pathinfo($file, PATHINFO_EXTENSION);
            $file_size = $_FILES['userfile']['size'];     
			if(file_exists($file))
			{
				echo 2;
			}
		    else
		    {
		    	if($file_type == 'png' || $file_type == 'jpg' || $file_type == 'jpeg' ||$file_type == 'PNG' || $file_type == 'JPG' || $file_type == 'JPEG' || $file_type == 'gif')
		    	{
		    	if($file_size < 5242880)
		    	{
               
		    	$this->load->library('upload',$config);
				
                if (  $this->upload->do_upload())
				{
                    
					$data = $this->upload->data();
					$image_path = 'assets/cus/'.$data['raw_name'].$data['file_ext'];
					$post = $this->input->post();
				//	$post['balance'] = $this->input->post('previous_balance');
					$post['branch_id'] = $this->branch_id;
				  $post['user_id'] = $this->user_id;
				  $post['logo']=addslashes($image_path);	    			
					$info = update_all($id,'customers',$post);
                    if($info){
                      unlink($old_image);
					  					echo 1;    
                    }
										else 
										  echo 0;					
				}
				else
				  {	   
                    echo 'n_p';
				  }
		    	}
		    	else
		    	{
		    		echo 'f_s';
		    	}
               
		    	}
		    	else
		    	{
		    		echo 'f_t';
		    	}
		       
		    }
		}
		else
		{
			$post = $this->input->post();      
			$id = $this->input->post('id');
			$post['branch_id'] = $this->branch_id;
		    $post['user_id'] = $this->user_id;	
		//	$post['balance'] = $this->input->post('previous_balance');	
		    $done = update_all($id,'customers',$post);
			 
			 if($done)
			    echo 1;
			 else 
				echo 0;
		}
	}
	
	public function delete_customer()
	{
	  $id=$this->uri->segment(3);
	  $old_image = my_col('logo','id',$id,'customers');

		$data = delete_by_id($id,'customers');
		if($data){
		    if(!empty($old_image))
			unlink($old_image);
		 echo 1;
		}
		else 
		 echo 0;	
	}

	public function create_salesman()
	{
		$pram = ['title' => 'Add salesman'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('salesmans');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		
		$this->load->view('salesman/add_salesman',compact('pram','code'));
	}
	public function add_salesman()
	{
		$post = $this->input->post();			
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
			$info = add_all($post,'salesmans');
			if($info)
				echo 1;
			else 
				echo 0;
	}
	public function manage_salesman()
	{
		$pram  = ['title' => 'Manage salesman'];
		$customers = view_all_with_branch('salesmans',$this->branch_id);
		 $this->load->view('salesman/manage_salesman',compact('pram','customers'));
	}
	public function view_salesman()
	{
		$pram  = ['title' => 'Update salesman'];
		$id = $this->uri->segment(3);
		$customer = view_all_by_id($id,'salesmans');
		$this->load->view('salesman/update_salesman',compact('pram','customer'));
	}
	public function update_salesman()
	{
		$post = $this->input->post();        
		$id = $this->input->post('id');
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
		$done = update_all($id,'salesmans',$post);
		 
		 if($done)
		    echo 1;
		 else 
			echo 0;
	}
	
	public function delete_salesman()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'salesmans');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_collection()
	{
		$pram = ['title' => 'Add Collection'];
		$customers = view_all_with_branch('customers',$this->branch_id);
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('collections');
		if($query->num_rows() > 0){
			$id = $query->row()->id;
			if($id){
				$code = $id + 1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('collection/add_collection',compact('pram','customers','code'));
	}
	public function add_collection()
	{
		$post = $this->input->post();
		$customer_id = $this->input->post('customer_id');
		$discount = $this->input->post('discount')?$this->input->post('discount'):0;
		//$name = my_col('name','id',$customer_id,'customers');
		$type = my_col('type','id',$customer_id,'customers');
		$previous_balance = $this->input->post('previous_balance');
		//$number = "88".my_col('contact_no','id',$customer_id,'customers');
		$paid = $this->input->post('paid'); 
		$paid = $paid ? $paid : 0;
		$bank_amount = $this->input->post('bank_amount'); 
		$bank_amount = $bank_amount ? $bank_amount : 0;
		
		$discount = $this->input->post('discount'); 
		$discount = $discount ? $discount : 0;
		//$check_amount = $this->input->post('check_amount');
		$check_amount = 0;
		$post['approved_st'] = 1;
		$post['type'] = $type;
		$balance = $previous_balance - $paid - $bank_amount - $check_amount - $discount;
        $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['balance'] = $balance;

	    $bank_id = $this->input->post('bank_id');
	    if(!empty($bank_id)){
	    $amount = $this->input->post('bank_amount');
	    $balb = my_col('final_balance','id',$bank_id,'banks');
	    $balanceb = $balb + $amount;
		}
		$info = add_all_insert_id($post,'collections');
			
		if($info)
			{
			$up = update_one_col_with_id('balance','id',$customer_id,'customers',$balance);
			if(!empty($bank_id))
			$up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balanceb);
			
		//	$customer_id = my_col('customer_id','id',$id,'product_sale_return_invoice');
		$no = "88".my_col('contact_no','id',$customer_id,'customers');
		$name = my_col('name','id',$customer_id,'customers');
		
// 		$charge = my_col('charge','id',$id,'product_sale_return_invoice');
// 	//	$paid = my_col('paid','id',$id,'complain');
// 	//	$due = my_col('due','id',$id,'complain');
// 		$paid = $charge - $ud;
		//$pre_due=round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) +  get_sum_prev_by_three('due','complain','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1) + get_sum_prev_by_three('due','services','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1));
		$uname = my_col('name','id',$this->user_id,'users');
		$paid = $previous_balance - $balance - $discount;
		$sms = "Dear Customer, your previous due Tk ".$previous_balance."/- paid Tk ".$paid."/- discount Tk ".$discount."/-  due is Tk ".$balance."/-\n-- Thank you.\n".$uname;
	    sms_send($no,$sms);
			
				echo $info;

			}
		else 
			echo 0;
	}
	public function customer_due()
	{
		$customer_id = $this->input->post('customer');
    $branch_id  = $this->branch_id;
    $bal=round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) + get_sum_prev_by_three('due','complain','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1) +  get_sum_prev_by_three('due','services','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1));
		$pbal = my_col('prev_bal','id',$customer_id,'customers');
		echo $bal."##".$pbal;
	}
	public function vendor_return_supplier_product()
	{
		$supplier_id = $this->input->post('supplier_id');
		$result = [];
		$q = $this->db->where('supplier_id',$supplier_id)->get('vendor_return')->result();
		
		foreach ($q as $value) {
		     
			$quantity = $value->quantity;
			$dquantity = $value->rcv_quantity+$value->taka_quantity;
			$rq = $quantity - $dquantity;
			if($quantity > $dquantity){

				$result[] = [my_col('name','id',$value->product_id,'products')." voucher ".$value->id."&nbsp;&nbsp;&nbsp; Qty = ".$rq."&nbsp;&nbsp;&nbsp; Price = ".$value->total_price];
			}
			
		}
	//	print_r($result);exit;
		echo json_encode($result);
	}
	public function customer_invoices()
	{
		$customer_id = $this->input->post('customer');
		$result = [];
		$q = $this->db->where('customer_id',$customer_id)->where('due >',0)->get('product_sale_invoice');
		$data = $q->result();
		foreach ($data as $key => $value) {
			$result[$value->id] = $value->id;
		}
		echo json_encode($result);
	}
	public function vendor_date_vendor_return()
	{
		$supplier_id = $this->input->post('supplier_id');
		$result = [];
		$q = $this->db->where('supplier_id',$supplier_id)->get('vendor_return')->result();
		foreach ($q as $key => $value) {
			$result[$value->date] = $value->date;
		}
		echo json_encode($result);
	}
	public function vendor_date_sale_return()
	{
		$supplier_id = $this->input->post('supplier_id');
		$result = [];
		$q = $this->db->where('supplier_id',$supplier_id)->get('product_sale_return_invoice')->result();
		foreach ($q as $key => $value) {
			$result[$value->date] = $value->date;
		}
		echo json_encode($result);
	}
	public function name_imei()
	{
		$id = $this->input->post('id');

		$result = [];
		$q = $this->db->where('product_id',$id)->where('status !=',0)->get('imes');
		$data = $q->result();
		foreach ($data as $key => $value) {
			$result[$value->ime] = $value->ime;
		}
		echo json_encode($result);
	}

	public function item_price()
	{
		$product_id = $this->input->post('product_id');
		$q = $this->db->where('id',$product_id)->where('branch_id',$this->branch_id)->get('products');
		$instock=stock_calc($q->row()->id,$q->row()->name,$this->branch_id);
		echo $data = $q->row()->sale_price."##".$q->row()->cost_price."##".$instock."##".$instock * $q->row()->sale_price;
	}
	public function customer_invoices_due()
	{
		$customer_id = $this->input->post('customer');
		$result = [];
		$q = $this->db->where('customer_id',$customer_id)->get('product_sale_invoice');
		$data = $q->result();
		foreach ($data as $key => $value) {
			$result[$value->id] = $value->id;
		}
		echo json_encode($result);
	}
	public function supplier_invoices()
	{
		$customer_id = $this->input->post('customer');
		$result = [];
		$q = $this->db->where('supplier_id',$customer_id)->where('due >',0)->get('purchase_invoice');
		$data = $q->result();
		foreach ($data as $key => $value) {
			$result[$value->id] = $value->id;
		}
		echo json_encode($result);
	}
	public function supplier_invoices_due()
	{
		$supplier_id = $this->input->post('supplier');
		$result = [];
		$q = $this->db->where('supplier_id',$supplier_id)->get('purchase_invoice');
		$data = $q->result();
		foreach ($data as $key => $value) {
			$result[$value->id] = $value->id;
		}
		echo json_encode($result);
	}
	public function supplier_invoice_due()
	{
		$invoice_number = $this->input->post('inv');
		$q = $this->db->where('id',$invoice_number)->get('purchase_invoice');
		$data = $q->result();
		foreach ($data as $key => $value) {
			$due = $value->due;
		}
		echo $due;
	}
	public function customer_invoice_due()
	{
		$invoice_number = $this->input->post('inv');
		$q = $this->db->where('id',$invoice_number)->get('product_sale_invoice');
		$data = $q->result();
		foreach ($data as $key => $value) {
			$due = $value->due;
		}
		echo $due;
	}
	public function collection_manage()
	{
		$pram  = ['title' => 'Manage Collection'];
		$collections = view_all_with_branch('collections',$this->branch_id);
		 $this->load->view('collection/manage_collection',compact('pram','collections'));
	}
	public function view_collection()
	{
		$pram  = ['title' => 'Update Collection'];
		$id = $this->uri->segment(3);
		$collection = view_all_by_id($id,'collections');
		$this->load->view('collection/update_collection',compact('pram','collection'));
	}
	public function update_collection()
	{
		$post = $this->input->post();        
		$id = $this->input->post('id');
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['balance'] = $this->input->post('previous_balance');
		$done = update_all($id,'collections',$post);
		 
		 if($done)
		    echo 1;
		 else 
			echo 0;
	}
	
	public function delete_collection()
	{
	    $id=$this->uri->segment(3);
	    $paid = my_col('paid','id',$id,'collections');
	    $appr = my_col('approved_st','id',$id,'collections');
	    $bank_amount = my_col('bank_amount','id',$id,'collections');
	    $discount = my_col('discount','id',$id,'collections');
	    if($appr == 1){
	    	 $check_amount = my_col('check_amount','id',$id,'collections');
	    }else{
	    	$check_amount = 0;
	    }
	    $customer_id = my_col('customer_id','id',$id,'collections');
	    $previous_balance = my_col('balance','id',$customer_id,'customers');

	    $balance = $previous_balance + $paid + $bank_amount + $check_amount + $discount;

	    $bank_id = my_col('bank_id','id',$id,'collections');
	    if(isset($bank_id)){
	    $amount = my_col('bank_amount','id',$id,'collections');
	    $balb = my_col('final_balance','id',$bank_id,'banks') ? my_col('final_balance','id',$bank_id,'banks') : 0;
		$balancebb = $balb - $amount;
		
		$up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balancebb);
		}
	    $up = update_one_col_with_id('balance','id',$customer_id,'customers',$balance);
	    
	    if($up){
	    	$data = delete_by_id($id,'collections');
			if($data)
			 echo 1;
			else 
			 echo 0;	
	    }
			
	}
	public function collection_cheque()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$message = "";
		$id = $this->uri->segment(2);
		$datas = view_all_by_id($id,'collections');
		$this->load->view('collection/cheque_info',compact('pram','datas','message'));
	}
	public function collection_cheque_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		$datas = view_all_by_id($id,'collections');
		$prev_due = $datas->previous_balance;
		$check_amount = $datas->check_amount;
		$inv_due = $prev_due - $check_amount;
		$customer_id = $datas->customer_id;

		$sup_due = my_col('balance','id',$customer_id,'customers');
		$data = [
				'balance' => $inv_due,
				'approved_st' => 1
				];
		$done = update_all($id,'collections',$data);
		if($done){
			$due = $sup_due - $check_amount;
			$due_up = update_one_col_with_id('balance','id',$customer_id,'customers',$due);
			if($due_up){
				$datas = view_all_by_id($id,'collections');
				$message = "Cheque Approved Successfully!";
				$this->load->view('collection/cheque_info',compact('pram','datas','message'));
			}
			
		}
	}

	
	public function delivery_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		
		
		$id = $this->input->post('id');
		$total_price = $this->input->post('cash') ? $this->input->post('cash') : 0;
		 $advance = $this->input->post('advance') ? $this->input->post('advance') : 0;
		$discount = $this->input->post('discount') ? $this->input->post('discount') : 0;
		$due = my_col('due','id',$id,'complain');
		$ud = $due - $total_price - $discount;
        
		
		$this->db->set('delivery',1);
		$this->db->set('discount',$discount);
		$this->db->set('delivery_date',date('Y-m-d'));
		$this->db->set('due',$ud);
		$this->db->set('cash_paid',$total_price);
		$this->db->where('id',$id);
		$this->db->update('complain');
		
		$customer_id = my_col('customer_id','id',$id,'complain');
		$no = "88".my_col('contact_no','id',$customer_id,'customers');
		$brand = my_col('brand','id',$id,'complain');
		$model = my_col('model','id',$id,'complain');
		
		$charge = my_col('charge','id',$id,'complain');
	//	$paid = my_col('paid','id',$id,'complain');
	//	$due = my_col('due','id',$id,'complain');
		//$paid = $charge - $ud;
		$uname = my_col('name','id',$this->user_id,'users');
		$branch_id = $this->branch_id;
		$pre_due=round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) +  get_sum_prev_by_three('due','complain','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1) + get_sum_prev_by_three('due','services','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1));
		$uname = my_col('name','id',$this->user_id,'users');
		$tdue = $pre_due;
		$paidt = $advance + $total_price;
		$sms = "Dear Customer, Your invoice no ".$id.". Device details ".$model.". Work details ".$brand.". Delivery is successflly done. Bill amount is Tk ".$charge."/- paid Tk ".$paidt."/- discount Tk ".$discount."/- due is Tk ".$ud."/- total due ".$tdue."/-\n-- Thank you.\n".$uname;
	    sms_send($no,$sms);
		
	//	echo 1;
		return redirect('complain_manage');
		
	}
	public function ndelivery_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		
		$id = $this->uri->segment(2);	
		$due = my_col('due','id',$id,'complain');
		$total_price = my_col('cash_paid','id',$id,'complain');
		$discount = my_col('discount','id',$id,'complain');
		$ud =  $due+$total_price + $discount;
		
		$this->db->set('delivery',0);
		$this->db->set('discount',0);
		$this->db->set('delivery_date','');
		$this->db->set('cash_paid',0);
		$this->db->set('due',$ud);
		$this->db->where('id',$id);
	$db=	$this->db->update('complain');
		echo $db;
	
		
	}
	public function engs_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		
		$id = $this->input->post('id');
		$engineer = $this->input->post('engineer');
		
		
		$this->db->set('engs',1);
		$this->db->set('engineer',$engineer);
		$this->db->where('id',$id);
		$this->db->update('complain');
	//	echo 1;
		return redirect('complain_manage');
		
	}
	public function engs_napproved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		
		$id = $this->uri->segment(2);	
		
		
		$this->db->set('engs',0);
		$this->db->set('complete',0);
		$this->db->set('engineer',0);
	$this->db->where('id',$id);
		$db=$this->db->update('complain');
		echo $db;
	
		
	}
	public function engr_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		
		$id = $this->input->post('id');
		$eng_charge = $this->input->post('eng_charge');
		
		
		$this->db->set('engr',1);
		$this->db->set('complete',1);
		$this->db->set('eng_charge',$eng_charge);
		$this->db->set('working_date',date('Y-m-d'));
		$this->db->where('id',$id);
		$this->db->update('complain');
	//	echo 1;
	    $customer_id = my_col('customer_id','id',$id,'complain');
		$no = "88".my_col('contact_no','id',$customer_id,'customers');
		$name = my_col('name','id',$customer_id,'customers');
		$uname = my_col('name','id',$this->user_id,'users');
		
		$sms = "Dear Customer your order is ready. Please Collect your product.\n-- Thank you.\n".$uname;
	    sms_send($no,$sms);
		return redirect('complain_manage');
		
	}
	public function engr_napproved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		
		$id = $this->uri->segment(2);	
		
		
		$this->db->set('eng_charge',0);
		$this->db->set('working_date','');
		$this->db->set('engr',0);
		$this->db->where('id',$id);
	$db=	$this->db->update('complain');
		echo $db;
	
		
	}

	public function deliverys_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		
		$id = $this->input->post('id');
		$total_price = $this->input->post('cash') ? $this->input->post('cash') : 0;
		$discount = $this->input->post('discount') ? $this->input->post('discount') : 0;
		$due = my_col('due','id',$id,'services');
		$charge = my_col('charge','id',$id,'services');
		$paid = my_col('paid','id',$id,'services');
		$ud = $due - $total_price - $discount;	
		
		$this->db->set('delivery',1);
		$this->db->set('discount',$discount);
		$this->db->set('delivery_date',date('Y-m-d'));
		$this->db->set('due',$ud);
		$this->db->set('cash_paid',$total_price);
		$this->db->where('id',$id);
		$this->db->update('services');
		
		
		$customer_id = my_col('customer_id','id',$id,'services');
		$no = "88".my_col('contact_no','id',$customer_id,'customers');
		$name = my_col('name','id',$customer_id,'customers');
		
		//$charge = my_col('charge','id',$id,'services');
		$paid = my_col('paid','id',$id,'services');
		$due = my_col('due','id',$id,'services');
		$branch_id = $this->branch_id;
	  	$pre_due=round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) +  get_sum_prev_by_three('due','complain','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1) + get_sum_prev_by_three('due','services','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1));
		$uname = my_col('name','id',$this->user_id,'users');
		$tdue = $pre_due;
		$paidt = $paid + $total_price;

		$sms = "Dear Customer your service deliveried successflly.Invoice no ".$id.".Bill amount Tk ".$charge."/- paid Tk ".$paidt."/- discount Tk ".$discount."/-  invoice due Tk ".$ud."/- total due Tk ".$tdue."/-\n-- Thank you.\n".$uname;

		
	    sms_send($no,$sms);
	//	echo 1;
		return redirect('service_manage');
		
	}
	public function ndeliverys_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		
		$id = $this->uri->segment(2);	
		$due = my_col('due','id',$id,'services');
		$total_price = my_col('cash_paid','id',$id,'services');
		$discount = my_col('discount','id',$id,'services');
		$ud = $due + $total_price + $discount;
		
		$this->db->set('delivery',0);
		$this->db->set('discount',0);
		$this->db->set('delivery_date','');
		$this->db->set('cash_paid',0);
		$this->db->set('due',$ud);
		$this->db->where('id',$id);
	$db=	$this->db->update('services');
		echo $db;
	
		
	}
	public function complete_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$customer_id = my_col('customer_id','id',$id,'complain');
		$no = "88".my_col('contact_no','id',$customer_id,'customers');
		$name = my_col('name','id',$customer_id,'customers');
		
	//	$charge = my_col('charge','id',$id,'complain');
	//	$paid = my_col('paid','id',$id,'complain');
		//$due = my_col('due','id',$id,'complain');
		
		$uname = my_col('name','id',$this->user_id,'users');
		
		$sms = "Dear Customer your work is successflly done. Please Collect your device.\n-- Thank you.\n".$uname;
	    sms_send($no,$sms);
		
		$this->db->set('complete',1);
		$this->db->set('complete_date',date('Y-m-d'));
		$this->db->where('id',$id);
		$this->db->update('complain');
		echo 1;
		
	}
	public function ncomplete_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('complete',0);
		$this->db->set('complete_date','');
		$this->db->where('id',$id);
		$this->db->update('complain');
		echo 1;
		
	}

	public function service_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		$customer_id = my_col('customer_id','id',$id,'services');
		$no = "88".my_col('contact_no','id',$customer_id,'customers');
		$name = my_col('name','id',$customer_id,'customers');
		
		$charge = my_col('charge','id',$id,'services');
		$paid = my_col('paid','id',$id,'services');
		$due = my_col('due','id',$id,'services');
		$branch_id = $this->branch_id;
	  	$pre_due=round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) +  get_sum_prev_by_three('due','complain','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1) + get_sum_prev_by_three('due','services','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1));
		$uname = my_col('name','id',$this->user_id,'users');
		$tdue = $due+$pre_due;

		$sms = "Dear Customer your service is successflly done.Invoice no ".$id.".Bill amount Tk ".$charge."/- paid Tk ".$paid."/-  invoice due Tk ".$due."/- total due Tk ".$tdue."/-\n-- Thank you.\n".$uname;
	    sms_send($no,$sms);
		//echo $id;exit;
		$this->db->set('complete',1);
		$this->db->set('complete_date',date('Y-m-d'));
		$this->db->where('id',$id);
		$this->db->update('services');
		echo 1;
		
	}
	public function nservice_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('complete',0);
		$this->db->set('complete_date','');
		$this->db->where('id',$id);
		$this->db->update('services');
		echo 1;
		
	}
	

	public function receive_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('receive',1);
		$this->db->where('id',$id);
		$up = $this->db->update('purchase_return_invoice');
		if($up){
			$quantity = my_col('quantity','id',$id,'purchase_return_invoice');
			$branch_id = $this->branch_id;
			$product_id = my_col('product_id','id',$id,'purchase_return_invoice');
			$pre_stock = my_col_branch('instock','id',$product_id,'products',$branch_id);
			$in_stock = $pre_stock - $quantity;
			$update = update_stock_product_id($product_id,'products',$in_stock);
			echo 1;exit;
		}else{
			echo 0;exit;
		}
		
		
	}
	public function nreceive_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('receive',0);
		$this->db->where('id',$id);
		$up = $this->db->update('purchase_return_invoice');
		if($up){
			$quantity = my_col('quantity','id',$id,'purchase_return_invoice');
			$branch_id = $this->branch_id;
			$product_id = my_col('product_id','id',$id,'purchase_return_invoice');
			$pre_stock = my_col_branch('instock','id',$product_id,'products',$branch_id);
			$in_stock = $pre_stock + $quantity;
			$update = update_stock_product_id($product_id,'products',$in_stock);
			echo 1;exit;
		}else{
			echo 0;exit;
		}
		
	}

	public function mreceive_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('damage',1);
		$this->db->where('id',$id);
		$up = $this->db->update('purchase_return_invoice');
		if($up){
			$quantity = my_col('quantity','id',$id,'purchase_return_invoice');
			$branch_id = $this->branch_id;
			$product_id = my_col('product_id','id',$id,'purchase_return_invoice');
			$pre_stock = my_col_branch('instock','id',$product_id,'products',$branch_id);
			$pre_damage = my_col_branch('damage','id',$product_id,'products',$branch_id);
			$in_stock = $pre_stock - $quantity;
			$in_damage = $pre_damage + $quantity;
			$this->db->set('instock',$in_stock);
			$this->db->set('damage',$in_damage);
			$this->db->where('id',$product_id);
			$this->db->update('products');
			echo 1;exit;
		}else{
			echo 0;exit;
		}
		
	}
	public function nmreceive_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('damage',0);
		$this->db->where('id',$id);
		$up = $this->db->update('purchase_return_invoice');
		if($up){
			$quantity = my_col('quantity','id',$id,'purchase_return_invoice');
			$branch_id = $this->branch_id;
			$product_id = my_col('product_id','id',$id,'purchase_return_invoice');
			$pre_stock = my_col_branch('instock','id',$product_id,'products',$branch_id);
			$pre_damage = my_col_branch('damage','id',$product_id,'products',$branch_id);
			$in_stock = $pre_stock + $quantity;
			$in_damage = $pre_damage - $quantity;
			$this->db->set('instock',$in_stock);
			$this->db->set('damage',$in_damage);
			$this->db->where('id',$product_id);
			$this->db->update('products');
			echo 1;exit;
		}else{
			echo 0;exit;
		}
		
	}
	public function preceive_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('product',1);
		$this->db->where('id',$id);
		$this->db->update('purchase_return_invoice');
		echo 1;
		
	}
	public function npreceive_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('product',0);
		$this->db->where('id',$id);
		$this->db->update('purchase_return_invoice');
		echo 1;
		
	}
	

	public function send_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('send',1);
		$this->db->where('id',$id);
		$this->db->update('product_sale_return_invoice');
		echo 1;
		
	}
	public function nsend_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('send',0);
		$this->db->where('id',$id);
		$this->db->update('product_sale_return_invoice');
		echo 1;
		
	}
	public function wreceive_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$customer_id = my_col('customer_id','id',$id,'product_sale_return_invoice');
		$no = "88".my_col('contact_no','id',$customer_id,'customers');
		$name = my_col('name','id',$customer_id,'customers');
		
// 		$charge = my_col('charge','id',$id,'product_sale_return_invoice');
// 	//	$paid = my_col('paid','id',$id,'complain');
// 	//	$due = my_col('due','id',$id,'complain');
// 		$paid = $charge - $ud;
		$uname = my_col('name','id',$this->user_id,'users');
		
		$sms = "Dear Customer, your product warranty is successfull.Please Collect from ".$uname." Thank You.";
	    sms_send($no,$sms);
		
		$this->db->set('receive',1);
		$this->db->where('id',$id);
		$this->db->update('product_sale_return_invoice');
		echo 1;
		
	}
	public function nwreceive_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('receive',0);
		$this->db->where('id',$id);
		$this->db->update('product_sale_return_invoice');
		echo 1;
		
	}
	public function wdelivery_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$customer_id = my_col('customer_id','id',$id,'product_sale_return_invoice');
		$no = "88".my_col('contact_no','id',$customer_id,'customers');
		$name = my_col('name','id',$customer_id,'customers');
		
// 		$charge = my_col('charge','id',$id,'product_sale_return_invoice');
// 	//	$paid = my_col('paid','id',$id,'complain');
// 	//	$due = my_col('due','id',$id,'complain');
// 		$paid = $charge - $ud;
		$uname = my_col('name','id',$this->user_id,'users');
		
		$sms = "Dear Customer your product is deliveried successflly.\n-- Thank you.\n".$uname;
	    sms_send($no,$sms);
		
		$this->db->set('delivery',1);
		$this->db->set('delivery_date',date('d-m-Y'));
		$this->db->where('id',$id);
		$this->db->update('product_sale_return_invoice');
		echo 1;
		
	}
	public function nwdelivery_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('delivery',0);
		$this->db->set('delivery_date','');
		$this->db->where('id',$id);
		$this->db->update('product_sale_return_invoice');
		echo 1;
		
	}


	public function taka_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->input->post('id');
		$total_price = $this->input->post('cash');	
		$taka_quantity = $this->input->post('taka_quantity');	
		$this->db->set('taka_receive',1);
		$this->db->set('taka_quantity',$taka_quantity);
		$this->db->set('paid',$total_price);
		$this->db->where('id',$id);
		$this->db->update('vendor_return');
		echo 1;
		return redirect('vendor_return_manage');
		
	}
	public function ntaka_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);		
		
		$this->db->set('taka_receive',0);
		$this->db->set('taka_quantity',0);
		$this->db->set('paid',0);
		$this->db->where('id',$id);
		$this->db->update('vendor_return');
		echo 1;
		
	}
    public function taka_returned()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->input->post('id');
		$total_price = $this->input->post('cash');	
		$this->db->set('taka_return',1);
		$this->db->set('cash_paid',$total_price);
		$this->db->where('id',$id);
		$this->db->update('purchase_return_invoice');
		echo 1;
		return redirect('product_return_manage');
		
	}
	public function ntaka_returned()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);		
		
		$this->db->set('taka_return',0);
		$this->db->set('cash_paid',0);
		$this->db->where('id',$id);
		$this->db->update('purchase_return_invoice');
		echo 1;
		
	}
	public function productrec_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		//$id = $this->uri->segment(2);
		$quantity = $this->input->post('rcv_quantity');
		$id = $this->input->post('id');
		$this->db->set('product_receive',1);
		$this->db->set('rcv_quantity',$quantity);
		$this->db->where('id',$id);
		$up = $this->db->update('vendor_return');
		if($up){
			
			$branch_id = $this->branch_id;
			$product_id = my_col('product_id','id',$id,'vendor_return');
			$pre_stock = my_col_branch('instock','id',$product_id,'products',$branch_id);	
			$in_stock = $pre_stock + $quantity;
			$this->db->set('instock',$in_stock);
			$this->db->where('id',$product_id);
			$this->db->update('products');
			echo 1;
			return redirect('vendor_return_manage');
		}else{
			echo 0;exit;
		}
		
	}
	public function nproductrec_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);		
		
		$this->db->set('product_receive',0);
		$this->db->set('rcv_quantity',0);
		$this->db->where('id',$id);
		$up = $this->db->update('vendor_return');
		if($up){
			$quantity = my_col('quantity','id',$id,'vendor_return');
			$branch_id = $this->branch_id;
			$product_id = my_col('product_id','id',$id,'vendor_return');
			$pre_stock = my_col_branch('instock','id',$product_id,'products',$branch_id);	
			$in_stock = $pre_stock - $quantity;
			$this->db->set('instock',$in_stock);
			$this->db->where('id',$product_id);
			$this->db->update('products');
			echo 1;exit;
		}else{
			echo 0;exit;
		}
		
	}

	public function damage_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);

		$this->db->set('damage',1);
		$this->db->where('id',$id);
		$up = $this->db->update('vendor_return');
		if($up){
			$quantity = my_col('quantity','id',$id,'vendor_return');
			$branch_id = $this->branch_id;
			$product_id = my_col('product_id','id',$id,'vendor_return');
			$pre_damage = my_col_branch('damage','id',$product_id,'products',$branch_id);
			$in_damage = $pre_damage + $quantity;
			$this->db->set('damage',$in_damage);
			$this->db->where('id',$product_id);
			$this->db->update('products');
			echo 1;exit;
		}else{
			echo 0;exit;
		}
		
	}
	public function ndamage_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);		
		
		$this->db->set('damage',0);
		$this->db->where('id',$id);
		$up = $this->db->update('vendor_return');
		if($up){
			$quantity = my_col('quantity','id',$id,'vendor_return');
			$branch_id = $this->branch_id;
			$product_id = my_col('product_id','id',$id,'vendor_return');
			$pre_damage = my_col_branch('damage','id',$product_id,'products',$branch_id);
			$in_damage = $pre_damage - $quantity;
			$this->db->set('damage',$in_damage);
			$this->db->where('id',$product_id);
			$this->db->update('products');
			echo 1;exit;
		}else{
			echo 0;exit;
		}
		
	}
	public function due_sms()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$customer_id = $id = $this->uri->segment(2);
		
		
		$no = "88".my_col('contact_no','id',$customer_id,'customers');

		$uname = my_col('name','id',$this->user_id,'users');
		$branch_id = $this->branch_id;
		$pre_due=round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) +  get_sum_prev_by_three('due','complain','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1) + get_sum_prev_by_three('due','services','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1));

		$sms = "Dear Customer, your due amount TK ".$pre_due."/- Please pay quickly.\n-- Thank you.\n".$uname;
	    sms_send($no,$sms);
		
		
		echo 1;
		
	}

	public function create_payment()
	{
		$pram = ['title' => 'Add Payment'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('payments');
		if($query->num_rows() > 0){
			$id = $query->row()->id;
			if($id){
				$code = $id + 1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('payment/add_payment',compact('pram','code'));
	}
	public function add_payment()
	{
		$post = $this->input->post();
		$supplier_id = $this->input->post('supplier_id');
		$previous_balance = my_col('balance','id',$supplier_id,'suppliers');
		$paid = $this->input->post('paid'); 
		$discount = $this->input->post('discount') ? $this->input->post('discount') : 0; 
		$check_amount = $this->input->post('check_amount'); 
		$paid = $paid ? $paid : 0;
		$check_amount = $check_amount ? $check_amount : 0;
		$balance = $previous_balance - $paid - $check_amount - $discount;	
        $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['balance'] = $balance;
	    $post['approved_st'] = 1;
	    $bank_id = $this->input->post('bank_id');
	    if(!empty($bank_id)){
	    $balb = my_col('final_balance','id',$bank_id,'banks');
	    $balanceb = $balb - $check_amount;
	    $up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balanceb);
		}
		$info = add_all($post,'payments');
		if($info)
			{
				$up = update_one_col_with_id('balance','id',$supplier_id,'suppliers',$balance);
		
				if($up)
					echo 1;
				else
					echo 0;
			}
			else 
				echo 0;
	}
	public function supplier_due()
	{
		$supplier_id = $this->input->post('supplier');
		$bal = my_col('balance','id',$supplier_id,'suppliers');
		$pbal = my_col('prev_bal','id',$supplier_id,'suppliers');
		echo $bal."##".$pbal;
	}
	public function user_info()
	{
		 $user_id = $this->input->post('user_id');
		
		$bal = get_sum_prev_by_two('cash_paid','product_sale_invoice','user_id',$user_id,'branch_id',$this->branch_id) + get_sum_prev_by_two('check_amount','product_sale_invoice','user_id',$user_id,'branch_id',$this->branch_id) + get_sum_prev_by_two('paid','collections','user_id',$user_id,'branch_id',$this->branch_id) + get_sum_prev_by_two('check_amount','collections','user_id',$user_id,'branch_id',$this->branch_id) + get_sum_prev_by_two('advance','complain','user_id',$user_id,'branch_id',$this->branch_id) + get_sum_prev_by_two('cash_paid','complain','user_id',$user_id,'branch_id',$this->branch_id) + get_sum_prev_by_two('paid','services','user_id',$user_id,'branch_id',$this->branch_id) + get_sum_prev_by_two('cash_paid','services','user_id',$user_id,'branch_id',$this->branch_id) + get_sum_prev_by_two('amount','commisons','user_id',$user_id,'branch_id',$this->branch_id) - get_sum_prev_by_two('amount','accounts','user_id',$user_id,'branch_id',$this->branch_id);
		$pbal = $bal-get_sum_prev_by_two('amount','userps','user_id',$user_id,'branch_id',$this->branch_id);
		echo $bal."##".$pbal;
	}
	public function payment_manage()
	{
		$pram  = ['title' => 'Manage Payment'];
		$payments = view_all_with_branch('payments',$this->branch_id);
		 $this->load->view('payment/manage_payment',compact('pram','payments'));
	}
	public function delete_payment()
	{
	    $id=$this->uri->segment(3);
	    $paid = my_col('paid','id',$id,'payments');
	    $discount = my_col('discount','id',$id,'payments');
	    $appr = my_col('approved_st','id',$id,'payments');
	    if($appr == 1){
	    	 $check_amount = my_col('check_amount','id',$id,'payments');
	    }else{
	    	$check_amount = 0;
	    }
	    $supplier_id = my_col('supplier_id','id',$id,'payments');
	    $previous_balance = my_col('balance','id',$supplier_id,'suppliers');
	    $balance = $previous_balance + $paid + $check_amount+$discount;
	    $up = update_one_col_with_id('balance','id',$supplier_id,'suppliers',$balance);
	    $bank_id = my_col('bank_id','id',$id,'payments');
	    if(!empty($bank_id)){
	    $amount = my_col('check_amount','id',$id,'payments');
	    $balb = my_col('final_balance','id',$bank_id,'banks') ? my_col('final_balance','id',$bank_id,'banks') : 0;
		$balanceb = $balb + $amount;
		$up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balanceb);
		}
	    if($up){
	    	$data = delete_by_id($id,'payments');
			if($data)
			 echo 1;
			else 
			 echo 0;	
	    }		
	}
	public function payment_cheque()
	{
		$pram = ['title' => 'Payment Cheque Details'];
		$message = "";
		$id = $this->uri->segment(2);
		$datas = view_all_by_id($id,'payments');
		$this->load->view('payment/cheque_info',compact('pram','datas','message'));
	}
	public function payment_cheque_approved()
	{
		$pram = ['title' => 'Payment Cheque Details'];
		$id = $this->uri->segment(2);
		$datas = view_all_by_id($id,'payments');
	//	$sale_due = my_col('due','id',$sale_inv,'purchase_invoice');
		$prev_due = $datas->previous_balance;
		$check_amount = $datas->check_amount;
		$inv_due = $prev_due - $check_amount;
		$supplier_id = $datas->supplier_id;
		$sup_due = my_col('balance','id',$supplier_id,'suppliers');

		$data = [
				'balance' => $inv_due,
				'approved_st' => 1
				];
		$done = update_all($id,'payments',$data);
		if($done){

			$due = $sup_due - $check_amount;
			$due_up = update_one_col_with_id('balance','id',$supplier_id,'suppliers',$due);

			if($due_up){
				$datas = view_all_by_id($id,'payments');
				$message = "Cheque Approved Successfully!";
				$this->load->view('payment/cheque_info',compact('pram','datas','message'));
			}
			
		}
	}
	public function payment_cheque_return()
	{
		$pram = ['title' => 'Payment Cheque Details'];
		$id = $this->uri->segment(2);
		
		$data = [
				'return_st' => 1
				];
		$done = update_all($id,'payments',$data);
		if($done){
				$datas = view_all_by_id($id,'payments');
				$message = "Cheque Returned Successfully!";
				$this->load->view('payment/cheque_info',compact('pram','datas','message'));
			}
	}

	public function create_paymentn()
	{
		$pram = ['title' => 'Add Payment'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('paymentsn');
		if($query->num_rows() > 0){
			$id = $query->row()->id;
			if($id){
				$code = $id + 1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('paymentn/add_payment',compact('pram','code'));
	}
	public function add_paymentn()
	{
		$post = $this->input->post();
		$supplier_id = $this->input->post('supplier_id');
		$previous_balance = my_col('balance','id',$supplier_id,'suppliersn');
		$paid = $this->input->post('paid'); 
		$check_amount = $this->input->post('check_amount'); 
		$paid = $paid ? $paid : 0;
		$check_amount = $check_amount ? $check_amount : 0;
		$balance = $previous_balance - $paid - $check_amount;		
        $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['balance'] = $balance;
	    $post['approved_st'] = 1;

		$info = add_all($post,'paymentsn');
		if($info)
			{
				$up = update_one_col_with_id('balance','id',$supplier_id,'suppliersn',$balance);

		
				if($up)
					echo 1;
				else
					echo 0;
			}
			else 
				echo 0;
	}
	public function suppliern_due()
	{
		$supplier_id = $this->input->post('supplier');
		$bal = my_col('balance','id',$supplier_id,'suppliersn');
		$pbal = my_col('prev_bal','id',$supplier_id,'suppliersn');
		echo $bal."##".$pbal;
	}
	public function paymentn_manage()
	{
		$pram  = ['title' => 'Manage Payment'];
		$payments = view_all_with_branch('paymentsn',$this->branch_id);
		 $this->load->view('paymentn/manage_payment',compact('pram','payments'));
	}
	public function delete_paymentn()
	{
	    $id=$this->uri->segment(3);
	    $paid = my_col('paid','id',$id,'paymentsn');
	    $appr = my_col('approved_st','id',$id,'paymentsn');
	    if($appr == 1){
	    	 $check_amount = my_col('check_amount','id',$id,'paymentsn');
	    }else{
	    	$check_amount = 0;
	    }
	    $supplier_id = my_col('supplier_id','id',$id,'paymentsn');
	    $previous_balance = my_col('balance','id',$supplier_id,'suppliersn');
	    $balance = $previous_balance + $paid + $check_amount;
	    $up = update_one_col_with_id('balance','id',$supplier_id,'suppliersn',$balance);

	    if($up){
	    	$data = delete_by_id($id,'paymentsn');
			if($data)
			 echo 1;
			else 
			 echo 0;	
	    }		
	}


	public function create_supplier_collection()
	{
		$pram = ['title' => 'Add Supplier Collection'];
		$this->load->view('supplier_collection/add_payment',compact('pram'));
	}
	public function add_supplier_collection()
	{
		$post = $this->input->post();
		$supplier_id = $this->input->post('supplier_id');
		$previous_balance = my_col('balance','id',$supplier_id,'suppliers');
		$paid = $this->input->post('paid'); 
		$paid = $paid ? $paid : 0;
		$balance = $previous_balance + $paid;
        $post['date'] = date("Y-m-d");
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['balance'] = $balance;
	    $post['previous_balance'] = $balance;
			$info = add_all($post,'supplier_collection');
			if($info)
				{

					$up = update_one_col_with_id('balance','id',$supplier_id,'suppliers',$balance);
					if($up)
						echo 1;
					else
						echo 0;
				}
			else 
				echo 0;
	}

	public function supplier_collection_manage()
	{
		$pram  = ['title' => 'Manage Supplier Collection'];
		$payments = view_all_with_branch('supplier_collection',$this->branch_id);
		 $this->load->view('supplier_collection/manage_payment',compact('pram','payments'));
	}
	public function delete_supplier_collection()
	{
	    $id=$this->uri->segment(3);
	    $supplier_id = my_col('supplier_id','id',$id,'supplier_collection');
	    $paid = my_col('paid','id',$id,'supplier_collection');
	    $previous_balance = my_col('balance','id',$supplier_id,'suppliers');
	    $balance = $previous_balance - $paid;
	    $up = update_one_col_with_id('balance','id',$supplier_id,'suppliers',$balance);
	    if($up){
	    	$data = delete_by_id($id,'supplier_collection');
			if($data)
			 echo 1;
			else 
			 echo 0;	
	    }		
	}

	public function create_commison()
	{
		//exit;
		$pram = ['title' => 'Add Commison'];
		$this->load->view('commison/add_commison',compact('pram'));
	}
	public function add_commison()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
		$info = add_all($post,'commisons');
		if($info)
			echo 1;
		else 
			echo 0;
	}
	public function manage_commison()
	{
		$pram  = ['title' => 'Manage Commison'];
		$categories = view_all_with_branch('commisons',$this->branch_id);
		 $this->load->view('commison/manage_commison',compact('pram','categories'));
	}
	
	public function delete_commison()
	{
	    $id=$this->uri->segment(3);

		$data = delete_by_id($id,'commisons');
		if($data)
		 echo 1;
		else 
		 echo 0;
			
	}

	public function create_asset()
	{
		//exit;
		$pram = ['title' => 'Add Asset'];
		$this->load->view('asset/add',compact('pram'));
	}
	public function add_asset()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
		$info = add_all($post,'asset');
			if($info){
				echo 1;
			}
			else 
				echo 0;
	}
	public function manage_asset()
	{
		$pram  = ['title' => 'Manage Asset'];
		$categories = view_all_with_branch('asset',$this->branch_id);
		 $this->load->view('asset/manage',compact('pram','categories'));
	}
	
	public function delete_asset()
	{
	    $id=$this->uri->segment(3);

		$data = delete_by_id($id,'asset');
		if($data)
		 echo 1;
		else 
		 echo 0;
			
	}
	public function create_complain()
	{
		//exit;
		$pram = ['title' => 'Add Asset'];
		$items = view_all_with_branch('products',$this->branch_id);
		$this->load->view('complain/add',compact('pram','items'));
	}
	public function add_complain()
	{
		$post = $this->input->post();
		//print_r($post);exit;				
	  $post['branch_id'] = $this->branch_id;
	  $post['user_id'] = $this->user_id;
	  $post['time'] = $this->time;
	  $post['date'] = $this->input->post('date');
	  
	  $model = $this->input->post('model');
	  $brand = $this->input->post('brand');
	  $charge = $this->input->post('charge');
	  $paid = $advance = $this->input->post('advance')?$this->input->post('advance'):0;
	  $due = $this->input->post('due');
	 
	 $customer_id =  $this->input->post('customer_id');
	 
	 

		$info = add_all_insert_id($post,'complain');
			if($info){
			    

		

		$customer_id = $this->input->post('customer_id');
	    
	    $no = "88".my_col('contact_no','id',$customer_id,'customers');
	   // $model = $this->input->post('model');
	  //	$charge = $this->input->post('charge');
	  	//$paid = $this->input->post('advance')?$this->input->post('advance'):0;
	  //	$due = $charge - $paid;
	    $branch_id = $this->branch_id;
	  	$pre_due=round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) +  get_sum_prev_by_three('due','complain','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1) + get_sum_prev_by_three('due','services','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1));
	    
	  	$tdue = $due+$pre_due;

	  	$uname = my_col('name','id',$this->user_id,'users');
			$sms = "Dear Customer, your booking is successflly done.Invoice no ".$info.".Device Details ".$model.".Work Details is ".$brand.".Bill amount Tk ".$charge."/- advance Tk ".$paid."/-  invoice due Tk ".$due."/- total due Tk ".$tdue."/-\n-- Thank you.\n".$uname;
		
		
	    sms_send($no,$sms);
					echo 1;exit;
			}
			else 
				echo 0;
	}
	public function manage_complain()
	{
		$pram  = ['title' => 'Manage Asset'];

		if(count($this->input->post()) > 0) :
		$status = $this->input->post('status');

    if($status == 0){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('complete',0);
    	$this->db->where('delivery',0);
    	$categories  = $this->db->get('complain')->result();
    }
    if($status == 1){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('complete',1);
    	$this->db->where('delivery',1);
    	$categories  = $this->db->get('complain')->result();
    }
    if($status == 2){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('complete',1);
    	$this->db->where('delivery',0);
    	$categories  = $this->db->get('complain')->result();
    }
    if($status == 3){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('delivery',1);
    	$categories  = $this->db->get('complain')->result();
    }
    
		$this->load->view('complain/manage',compact('pram','categories'));
		else:
			$this->db->where('branch_id',$this->branch_id);
    	
    	$this->db->where('delivery',0);
    	$categories  = $this->db->get('complain')->result();
		 $this->load->view('complain/manage',compact('pram','categories'));
		endif;
	}
	public function manage_complainp()
	{
		$pram  = ['title' => 'Manage Asset'];

  
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('complete',0);
    	$this->db->where('delivery',0);
    	$categories  = $this->db->get('complain')->result();
    
		 $this->load->view('complain/managep',compact('pram','categories'));
	
	}
	public function manage_complaind()
	{
		$pram  = ['title' => 'Manage Asset'];

  
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('complete',1);
    	$this->db->where('delivery',0);
    	$categories  = $this->db->get('complain')->result();
    
		 $this->load->view('complain/managed',compact('pram','categories'));
	
	}
	public function view_complain()
	{
		$pram  = ['title' => 'Manage Asset'];
		$id = $this->uri->segment(2);
		$category =  view_all_by_id($id,'complain');
		$items = view_all_with_branch('products',$this->branch_id);
		 $this->load->view('complain/update',compact('pram','category','items'));
	}
	public function update_complain()
	{
	  $id = $this->input->post('main_id');
	//  $due = my_col('due','id',$id,'complain');				
	  $post['branch_id'] = $this->branch_id;
	  $post['user_id'] = $this->user_id;
	  $post['time'] = $this->time;
	  $post['date'] = $this->input->post('date');
	  $post['total_amount'] = $this->input->post('total_amount');
	 // $post['due'] = $this->input->post('total_amount') + $due;
	  $post['cost_amount'] = $this->input->post('cost_amount');
	  // $post['paid'] = $this->input->post('paid');
	  // $post['due'] = $this->input->post('due');
	  // $post['charge'] = $this->input->post('charge');
	  // $post['model'] = $this->input->post('model');
	  // $post['brand'] = $this->input->post('brand');
	  // $post['problem'] = $this->input->post('problem');
	  // $post['customer_id'] = $this->input->post('customer_id');
	  // $post['paid_new'] = $this->input->post('paid_new');
	  //$post['advance'] = $this->input->post('advance');

		$info = update_all($id,'complain',$post);
			if($info){
				$done = 0;
				$loop = count($this->input->post('quantity'));
				for($i=0; $i < $loop; $i++){
					$data = [
								'product_id' => $this->input->post('product_id')[$i],
								'ime' => $this->input->post('ime')[$i],
								'price' => $this->input->post('price')[$i],
								'cost' => $this->input->post('cost')[$i],
								'total_price' => $this->input->post('total_price')[$i],
								'total_cost' => $this->input->post('total_cost')[$i],
								'quantity' => $this->input->post('quantity')[$i],
								'user_id'		   => $this->user_id,
								'trigger_id'		   => $id,
								'branch_id'		   => $this->branch_id,
								'date'		   => $post['date']
							];
					$info = add_all($data,'complain_items');
						$product_id = $this->input->post('product_id')[$i];
						$ime = $this->input->post('ime')[$i];
						$quantity = $this->input->post('quantity')[$i];
						$instock = my_col('instock','id',$product_id,'products');
						$stock = $instock - $quantity;

						$this->db->set('instock',$stock);
						$this->db->where('id',$product_id);
						$u=$this->db->update('products');
						if($u){
							if(!empty($ime)){
								$this->db->where('ime',$ime);
								$ime_qtydb=$this->db->get("imes")->row()->ime_qty;
								$ime_qty_up = $ime_qtydb - $quantity;

								$this->db->set('ime_qty',$ime_qty_up);
								$this->db->where('ime',$ime);
								$this->db->update('imes');
								}
						$done = 1;
						}
						
				}
				if($done==1)
					echo 1;
				else 
					echo 0;
			}
			else 
				echo 0;
	}
	public function delete_complain()
	{
	  $id=$this->uri->segment(3);
	  $query = get_all_by_match_one($id,'complain_items','trigger_id');
		foreach ($query->result() as $value) {
			$product_id = $value->product_id;
			$quantity = $value->quantity;
			$branch_id = $value->branch_id;
			$instock = my_col('instock','id',$product_id,'products');
			$stock = $instock - $quantity;	
			$this->db->set('instock',$stock);
			$this->db->where('id',$product_id);
			$this->db->update('products');
		}
		
		$data = delete_by_id($id,'complain');
		if($data){
			delete_by_match_col('trigger_id',$id,'complain_items');
		 echo 1;
		}
		else 
		 echo 0;
			
	}
	public function create_asset_head()
	{
		$pram = ['title' => 'Add Head'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('asset_heads');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		
		$this->load->view('head/add_asset_head',compact('pram','code'));
	}
	public function add_asset_head()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;

			$info = add_all($post,'asset_heads');
			if($info)
				echo 1;
			else 
				echo 0;

	}
	public function manage_asset_head()
	{
		$pram  = ['title' => 'Manage Accpunt Head'];
		$heads = view_all_with_branch('asset_heads',$this->branch_id);
		 $this->load->view('head/manage_asset_head',compact('pram','heads'));
	}
	
	public function delete_asset_head()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'asset_heads');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function model_price()
	{
	    $id = $this->input->post('id');
		$this->db->where('id',$id);	
		echo $product_id = $this->db->get('products')->row()->cost_price;
	}
	public function ime_model()
	{
	  $ime = $this->input->post('ime');
		$this->db->where('ime',$ime);	
		$product = $this->db->get('imes')->row();
		echo my_col('name','id',$product->product_id,'products')."##".my_col('name','id',$product->supplier_id,'suppliers')."##".$product->cost_price."##".$product->supplier_id;
	}
    
	public function create_contact()
	{
		$pram = ['title' => 'Product Sale'];	
		$this->load->view('contact/add',compact('pram'));
	}

	public function add_contact()
	{	
	    $post = $this->input->post();
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
		$info = add_all_insert_id($post,'contacts');
		if($info){
            echo 1;exit;
		}else{
				echo 0;exit;
			}
	}

	public function manage_contact(){
		$pram = ['title' => 'Manage Sale'];
		$products  = view_all_with_branch('contacts',$this->branch_id);
		$this->load->view('contact/manage',compact('pram','products'));
	}
	public function delete_contact(){
		$id = $this->uri->segment(3);
		$data = delete_by_id($id,'contacts');
		if($data){
		    echo 1;exit;
		}
		else 
		 echo 0;exit;
			
	}

	public function create_lost()
	{
		$pram = ['title' => 'Product Sale'];	
		$this->load->view('lost/add',compact('pram'));
	}

	public function add_lost()
	{	
	    $post = $this->input->post();
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
		$info = add_all_insert_id($post,'losts');
		if($info){
            echo 1;exit;
		}else{
				echo 0;exit;
			}
	}

	public function manage_lost(){
		$pram = ['title' => 'Manage Sale'];
		$products  = view_all_with_branch('losts',$this->branch_id);
		$this->load->view('lost/manage',compact('pram','products'));
	}
	public function delete_lost(){
		$id = $this->uri->segment(3);
		$data = delete_by_id($id,'losts');
		if($data){
		    echo 1;exit;
		}
		else 
		 echo 0;exit;
			
	}

	public function create_student()
	{
		$pram = ['title' => 'Product Sale'];	
		$this->load->view('student/add',compact('pram'));
	}

	public function add_student()
	{	
	    $post = $this->input->post();
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
	    $post['balance'] = $this->input->post('fee');
		$info = add_all_insert_id($post,'students');
		if($info){
            echo 1;exit;
		}else{
				echo 0;exit;
			}
	}

	public function manage_student(){
		$pram = ['title' => 'Manage Sale'];
		$products  = view_all_with_branch('students',$this->branch_id);
		$this->load->view('student/manage',compact('pram','products'));
	}
	public function delete_student(){
		$id = $this->uri->segment(3);
		$data = delete_by_id($id,'students');
		if($data){
		    echo 1;exit;
		}
		else 
		 echo 0;exit;
			
	}

	public function create_studentp()
	{
		$pram = ['title' => 'Product Sale'];	
		$this->load->view('studentp/add',compact('pram'));
	}

	public function add_studentp()
	{	
	    $post = $this->input->post();
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
	    $balance = $this->input->post('balance');
	    $id = $this->input->post('student_id');
	    
		$info = add_all_insert_id($post,'studentps');
		if($info){
		    $this->db->set('balance',$balance);
		    $this->db->where('id',$id);
		    $this->db->update('students');
            echo 1;exit;
		}else{
				echo 0;exit;
			}
	}

	public function manage_studentp(){
		$pram = ['title' => 'Manage Sale'];
		$products  = view_all_with_branch('studentps',$this->branch_id);
		$this->load->view('studentp/manage',compact('pram','products'));
	}
	public function delete_studentp(){
		$id = $this->uri->segment(3);
		$student_id = my_col('student_id','id',$id,'studentps');
		$balance =  my_col('balance','id',$student_id,'students') + my_col('amount','id',$id,'studentps');
		 
		$data = delete_by_id($id,'studentps');
		if($data){
		    $this->db->set('balance',$balance);
		    $this->db->where('id',$student_id);
		    $this->db->update('students');
		    echo 1;exit;
		}
		else 
		 echo 0;exit;
			
	}
	public function student_balance(){
	    $id = $this->input->post('id');
	  echo  $this->db->where('id',$id)->get('students')->row()->balance;
	}
	public function create_userp()
	{
		$pram = ['title' => 'Product Sale'];	
		$this->load->view('userp/add',compact('pram'));
	}

	public function add_userp()
	{	
	    $post = $this->input->post();
	    $post['branch_id'] = $this->branch_id;
	    $post['suser_id'] = $this->user_id;
	    $user_id = $this->input->post('user_id');
	    $balance = $this->input->post('balancen');
	    $amount = $this->input->post('amount');
	    $prev = $this->input->post('prev');
	    $name = my_col('name','id',$user_id,'users');
	    $no = "88".my_col('contact_no','id',$user_id,'users');
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
		$info = add_all_insert_id($post,'userps');
		if($info){
		    	$uname = my_col('name','id',$this->user_id,'users');
			$sms = "Dear ".$name.", your payment received ".$amount.".available ".$balance."./-\n-- Thank you.\n".$uname;
		sms_send($no,$sms);
            echo 1;exit;
		}else{
				echo 0;exit;
			}
	}

	public function manage_userp(){
		$pram = ['title' => 'Manage Sale'];
		$products  = view_all_with_branch('userps',$this->branch_id);
		$this->load->view('userp/manage',compact('pram','products'));
	}
	public function delete_userp(){
		$id = $this->uri->segment(3);
		$data = delete_by_id($id,'userps');
		if($data){
		    echo 1;exit;
		}
		else 
		 echo 0;exit;
			
	}
	public function create_promotion()
	{
		$pram = ['title' => 'Product Sale'];	
		$this->load->view('promotion/add',compact('pram'));
	}

	public function add_promotion()
	{	
	    $post = $this->input->post();
	    $ime = $this->input->post('ime');
	    $amount = $this->input->post('amount');
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
		$info = add_all_insert_id($post,'promotions');
		if($info){
			$sale_price = my_col('sale_price','ime',$ime,'imes') - $amount;
			$cost_price = my_col('cost_price','ime',$ime,'imes') - $amount;
			$this->db->set('cost_price',$cost_price);
			$this->db->set('sale_price',$sale_price);
			$this->db->where('ime',$ime);
			$this->db->update('imes');
			
			
		
	    
            echo 1;exit;
		}else{
				echo 0;exit;
			}
	}

	public function manage_promotion(){
		$pram = ['title' => 'Manage Sale'];
		$products  = view_all_with_branch('promotions',$this->branch_id);
		$this->load->view('promotion/manage',compact('pram','products'));
	}
	public function delete_promotion(){
		$id = $this->uri->segment(3);
		$ime = my_col('ime','id',$id,'promotions');
    $amount = my_col('amount','id',$id,'promotions');
		$sale_price = my_col('sale_price','ime',$ime,'imes') + $amount;
		$cost_price = my_col('cost_price','ime',$ime,'imes') + $amount;
		$this->db->set('cost_price',$cost_price);
		$this->db->set('sale_price',$sale_price);
		$this->db->where('ime',$ime);
		$this->db->update('imes');
		$data = delete_by_id($id,'promotions');
		if($data){
		    echo 1;exit;
		}
		else 
		 echo 0;exit;
			
	}
	public function promotion_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('status',1);
		$this->db->set('rdate',date('Y-m-d'));
		$this->db->where('id',$id);
		$this->db->update('promotions');

		$supplier_id = my_col('supplier_id','id',$id,'promotions');
		$no = "88".my_col('contact_no','id',$supplier_id,'suppliers');
		//$name = my_col('name','id',$customer_id,'suppliers');
		$uname = my_col('name','id',$this->user_id,'users');
		
		$sms = "Dear Vendor, your price adjustment payment is received.\n-- Thank you.\n".$uname;
	    sms_send($no,$sms);
		echo 1;
		
	}
	public function npromotion_approved()
	{
		$pram = ['title' => 'Collection Cheque Details'];
		$id = $this->uri->segment(2);
		
		$this->db->set('status',0);
		$this->db->set('rdate','');
		$this->db->where('id',$id);
		$this->db->update('promotions');
		echo 1;
		
	}

	public function logout()
	{			 

	 $this->session->unset_userdata('user_id');
	 $this->session->unset_userdata('user_name');
	 $this->session->unset_userdata('branch_id');
	 $this->session->unset_userdata('date');
	 $this->session->unset_userdata('status');
	 $this->session->unset_userdata('name');
	 $this->session->unset_userdata('user_image');
	 $this->session->unset_userdata('logged_in');	 
	 $this->session->set_flashdata('message','Logout Successfully');
	 return redirect('login');
	 	
	}

	public function backup_db()
	{			 
	 	$this->load->dbutil();
	 	$prefs = array(
        'format'        => 'txt',
        'filename'      => 'mybackup.sql'
		);
		$backup = $this->dbutil->backup($prefs);
		$name = 'mybackup_on_'.date("Y-m-d-H-i-s").'.sql';
		//$save = 'C:\Users\Mahabubpc-2\Downloads\db_backup/'.$name;
		//write_file($save , $backup);
		 force_download($name , $backup);
		return redirect('dashboard');	
	}
	
	public function create_prson_head()
	{
		$pram = ['title' => 'Add prson_head'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('prsons');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		
		$this->load->view('prson_head/add_head',compact('pram','code'));
	}
	public function add_prson_head()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;

			$info = add_all($post,'prsons');
			if($info)
				echo 1;
			else 
				echo 0;

	}
	public function manage_prson_head()
	{
		$pram  = ['title' => 'Manage Accpunt prson_head'];
		$prsons = view_all_with_branch('prsons',$this->branch_id);
		 $this->load->view('prson_head/manage_head',compact('pram','prsons'));
	}
	public function update_prson_head()
	{
		  $id = $this->input->post('id');
		  $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['name'] = $this->input->post('name');
		 $done = update_all($id,'prsons',$post);
		 
		 if($done)
		    return redirect('prson_head_manage');
		 else 
			echo 0;
	}
	
	public function delete_prson_head()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'prsons');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}

	//Salary
	public function create_employee()
	{
		$pram = ['title' => 'Add Employee'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('employees');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$cod = explode("-", $code);
				$f = $cod[0];
				$l = $cod[1];
				$codde = $l + 1;
				$code = 'E-0'.$codde;
			}
		}else{
			$code = 'E-'.'01';
		}
		
		$this->load->view('employee/add_employee',compact('pram','code'));
	}
	public function add_employee()

	{
		$config =[
                  'upload_path'		=>'./assets/emp_img/',
                  'allowed_types'	=>'png|jpg|gif|jpeg|PNG|JPG|JPEG',
                  'max_size'        => '5120',
		         ];
	    $file = 'assets/emp_img/'. $_FILES['userfile']['name'];
	    $file_type = pathinfo($file, PATHINFO_EXTENSION);
        $file_size = $_FILES['userfile']['size'];

	    if(file_exists($file))
		{
			echo 2;
		}
	    else
	    {
	    	if($file_type == 'png' || $file_type == 'jpg' || $file_type == 'jpeg' ||$file_type == 'PNG' || $file_type == 'JPG' || $file_type == 'JPEG' || $file_type == 'gif')
	    	{
	    	if($file_size < 5242880)
	    	{
           
	    	$this->load->library('upload',$config);
			
            if ($this->upload->do_upload())
			{
                
				$post  = $this->input->post();
				$data = $this->upload->data();
				$image_path = 'assets/emp_img/'.$data['raw_name'].$data['file_ext'];
				$post['image']=addslashes($image_path);
				$post['date']=date("Y-m-d",strtotime($this->input->post('date')));
				$post['branch_id']=$this->branch_id;
				$post['user_id']=$this->user_id;
				$info = add_all($post,'employees');
                if($info){
      //           	$data = [
						// 	'date' => $this->input->post('date'),
						// 	'month' => date("Y-m",strtotime($this->input->post('date'))),
						// 	'salary' => $this->input->post('salary'),
						// 	'employee_id' => $info,
						// 	'branch_id' => $this->branch_id,
						// ];
						// add_all_insert_id($data,'employee_salary');
				  echo 1;
                }
				else 
				  echo 0;					
			}
			else
			  {	   
                echo 'n_p';
			  }
	    	}
	    	else
	    	{
	    		echo 'f_s';
	    	}
           
	    	}
	    	else
	    	{
	    		echo 'f_t';
	    	}
	       
	    }
	}
	public function manage_employee()
	{
		$pram  = ['title' => 'Manage Employee'];
		$customers = view_all_with_branch('employees',$this->branch_id);
		 $this->load->view('employee/manage_employee',compact('pram','customers'));
	}
	public function view_employee()
	{
		$pram  = ['title' => 'Update Employee'];
		$id = $this->uri->segment(3);
		$customer = view_all_by_id($id,'employees');
		$this->load->view('employee/update_employee',compact('pram','customer'));
	}
	public function update_employee()
	{
		$post = $this->input->post();        
		$id = $this->input->post('id');
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
		$done = update_all($id,'employees',$post);
		 
		 if($done){
		 	// 	$month = date("Y-m",strtotime($this->input->post('date')));
		 	// $salary=$this->input->post('salary');

		 	// $this->db->where('month',$month);
		 	// $this->db->where('employee_id',$id);
		 	// $row = $this->db->get('employee_salary');

		 	// if($row->num_rows() > 0){
		 	// 	$this->db->set('salary',$salary);
			 // 	$this->db->where('month',$month);
			 // 	$this->db->where('employee_id',$id);
			 // 	$this->db->update('employee_salary');
			 // }else{
			 // 	$data = [
				// 			'date' => $this->input->post('date'),
				// 			'month' => date("m-Y",strtotime($this->input->post('date'))),
				// 			'salary' => $this->input->post('salary'),
				// 			'employee_id' => $id,
				// 			'branch_id' => $this->branch_id,
				// 		];
				// 		add_all_insert_id($data,'employee_salary');
			 // }
				echo 1;
		 }
		   
		 else 
			echo 0;
	}
	
	public function delete_employee()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'employees');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function create_salary_head()
	{
		$pram = ['title' => 'Add Head'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('salary_heads');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code + 1;
			}
		}else{
			$code = 1;
		}
		
		$this->load->view('salary_head/add_head',compact('pram','code'));
	}
	public function add_salary_head()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;

			$info = add_all($post,'salary_heads');
			if($info)
				echo 1;
			else 
				echo 0;

	}
	public function manage_salary_head()
	{
		$pram  = ['title' => 'Manage Accpunt Head'];
		$heads = view_all_with_branch('salary_heads',$this->branch_id);
		 $this->load->view('salary_head/manage_head',compact('pram','heads'));
	}
	
	public function delete_salary_head()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'salary_heads');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}	
	
	public function payment_salary_search()
	{
		$pram  = ['title' => 'Manage Commison'];
		$employee_id = $this->input->post('employee_id');
		$from = $this->input->post('from');
		$to= $this->input->post('to');
		$this->db->where('employee_id',$employee_id);
		$this->db->where('date >=',$from);
		$this->db->where('date <=',$to);
		$categories = $this->db->get('salary_payment')->result();
		// view_all_with_branch('salary_payment',$this->branch_id);
		 $this->load->view('commison/manage_commison',compact('pram','categories'));
	}

	
	
    public function create_mns()
	{
		$pram = ['title' => 'Add mns'];
		$heads = view_all_with_branch("salary_heads",$this->branch_id);
		$this->load->view('mns/add_mns',compact('pram','heads'));
	}
	public function add_mns()
	{
		$po = $this->input->post('amount');
		if(isset($po))
		$loop = count($this->input->post('amount'));

		$total_amount = 0;		
        $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
        $post['employee_id'] = $this->input->post('employee_id');
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['total_amount'] = 0;
	    for($i = 0; $i < $loop; $i++){
			$post['total_amount'] += $this->input->post('amount')[$i];
		}
		// echo $total_amount;exit;
	   
	    $insert_id = add_all_insert_id($post,'mnss');	
	    $j = 0;
	    if(isset($po)):
	    for($i = 0; $i < $loop; $i++){
	    	$data['head_id'] = $this->input->post('head_id')[$i];
	    	$data['employee_id'] = $this->input->post('employee_id');
	    	$data['date'] = $this->input->post('date');
	    	$data['amount'] = $this->input->post('amount')[$i];
	    	$data['comment'] = $this->input->post('comment')[$i];
	    	$data['user_id'] = $this->user_id;
	    	$data['branch_id'] = $this->branch_id;
	    	$data['trigger_id'] = $insert_id;
    		$info = add_all($data,'mnss_loop');
    		if($info){	    			
    			$j=1;
    		}else{
    			echo 0;
    			exit;
    		}	    	
	    }
	    if($j==1)
	    	echo 1;
	    else
	    	echo 0;
	endif;
	}
	public function manage_mns()
	{
		$pram  = ['title' => 'Manage mns'];
		$mnss = view_all_with_branch('mnss',$this->branch_id);
		 $this->load->view('mns/manage_mns',compact('pram','mnss'));
	}
	public function view_mns()
	{
		$pram  = ['title' => 'Update mns'];
		$id = $this->uri->segment(3);
		$mns = view_all_by_id($id,'mnss');
		$this->load->view('mns/update_mns',compact('pram','mns'));
	}
	public function update_mns()
	{        
		$id = $this->input->post('id');
		$esid = my_col('esid','id',$id,'mnss');
	   	$post = $this->input->post();
		$post['date'] = date('Y-m-d',strtotime($this->input->post('date')));
		$post['month'] = date('Y-m',strtotime($this->input->post('date')));
		$employee_id = $this->input->post('employee_id');
		$day = $this->input->post('day') ? $this->input->post('day') : 0;
		$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;

		$this->db->where('id',$employee_id);
		$value = $this->db->get('employees')->row();
		$data['employee_id'] = $employee_id;
		$data['salary_main'] = $value->salary;
		$data['salary'] = $value->salary * $day;
		$data['date'] = $post['date'];
		$data['month'] = $post['month'];
		$data['branch_id'] = $this->branch_id;
		//add_all($data,'employee_salary');
		update_all($esid,'employee_salary',$data);
		$post['salary'] = $data['salary'];
		$info =  update_all($id,'mnss',$post);
			if($info){
				
				echo 1;
			}
			else 
				echo 0;
	}	
	public function delete_mns()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'mnss');
		$delete = delete_by_match_col('trigger_id',$id,'mnss_loop');;
		if($delete)
		 echo 1;
		else 
		 echo 0;	
	}
    public function create_pay_salary()
	{
		$pram = ['title' => 'Add Transport'];
		$this->load->view('cut_salary/add_transport',compact('pram'));
	}
	public function add_pay_salary()
	{
		$post = $this->input->post();	
	    $post['branch_id'] = $this->branch_id;
			$info = add_all($post,'salary_payment');
			if($info)
				echo 1;
			else 
				echo 0;
	}
	public function manage_pay_salary()
	{
		$pram  = ['title' => 'Manage Transport'];
		$categories = view_all_with_branch('salary_payment',$this->branch_id);
		 $this->load->view('cut_salary/manage_transport',compact('pram','categories'));
	}
	
	public function delete_pay_salary()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'salary_payment');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
	public function pay_salary_search()
	{
		$pram  = ['title' => 'Manage Commison'];
		$employee_id = $this->input->post('employee_id');
		$from = $this->input->post('from');
		$to= $this->input->post('to');
		$this->db->where('employee_id',$employee_id);
		$this->db->where('date >=',$from);
		$this->db->where('date <=',$to);
		$categories = $this->db->get('salary_payment')->result();
		 $this->load->view('cut_salary/manage_transport',compact('pram','categories'));
	}

	//8.9.22
	public function barcode()
	{
		$pram  = ['title' => 'Generate Barcode SS Automation'];
		
		 $this->load->view('barcode/index',compact('pram'));
	}
	public function generate_barcode()
	{
		$pram  = ['title' => 'Generate Barcode SS Automation'];
		$post = $this->input->post();
	//	print_r($post);exit;
		 $this->load->view('barcode/barcode',compact('pram','post'));
	}

	public function create_service()
	{
		//exit;
		
		$pram = ['title' => 'Add Asset'];
		
		$this->load->view('service/add',compact('pram'));
	}
	public function add_service()
	{
	  $post = $this->input->post();		
	  $branch_id = $post['branch_id'] = $this->branch_id;
	  $post['user_id'] = $this->user_id;
	  $smsd = "added";
	  $post['delivery'] = $this->input->post('delivery');
	  if($post['delivery'] == 1){
	      $post['complete'] = 1;
	      $post['delivery_date'] = $this->input->post('date');
	      $smsd = "deliveried";
	  }else{
	      $post['complete'] = $this->input->post('complete');
	  }	  
	  $info = add_all_insert_id($post,'services');
		if($info){
			$customer_id = $this->input->post('customer_id');
	    
	    $no = "88".my_col('contact_no','id',$customer_id,'customers');
	    $model = $this->input->post('model');
	  	$charge = $this->input->post('charge');
	  	$paid = $this->input->post('paid')?$this->input->post('paid'):0;
	  	$due = $this->input->post('due') ? $this->input->post('due') : 0;
	  	$branch_id = $this->branch_id;
	  	$pre_due = round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) +  get_sum_prev_by_three('due','complain','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1) + get_sum_prev_by_three('due','services','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1));
	  	$tdue = $pre_due;
	  	$uname = my_col('name','id',$this->user_id,'users');
			$sms = "Dear Customer, your service ".$smsd." successflly.Invoice no ".$info.".Service description ".$model.".Bill amount Tk ".$charge."/- paid Tk ".$paid."/-  invoice due Tk ".$due."/- total due Tk ".$tdue."/-\n-- Thank you.\n".$uname;
			sms_send($no,$sms);
			echo 1;exit;
		}
		else 
			echo 0;
	}
	public function manage_service()
	{
		$pram  = ['title' => 'Manage Asset'];

		if(count($this->input->post()) > 0) :
		$status = $this->input->post('status');

    if($status == 0){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('complete',0);
    	$this->db->where('delivery',0);
    	$categories  = $this->db->get('services')->result();
    }
    if($status == 1){
   
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('complete',1);
    	$this->db->where('delivery',1);
    	$categories  = $this->db->get('services')->result();
    }
    if($status == 2){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('complete',1);
    	$this->db->where('delivery',0);
    	$categories  = $this->db->get('services')->result();
    }
    if($status == 3){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('delivery',1);
    	$categories  = $this->db->get('services')->result();
    }
    
		$this->load->view('service/manage',compact('pram','categories'));
		else:
		$this->db->where('branch_id',$this->branch_id);    	
    	$this->db->where('delivery',0);
    	$categories  = $this->db->get('services')->result();
		$this->load->view('service/manage',compact('pram','categories'));
		endif;
	}
	public function view_service()
	{
		$pram  = ['title' => 'Manage Asset'];
		$id = $this->uri->segment(2);
		$category =  view_all_by_id($id,'service');
		$items = view_all_with_branch('products',$this->branch_id);
		 $this->load->view('service/update',compact('pram','category','items'));
	}
	public function update_service()
	{
	  $id = $this->input->post('id');				
	  $post['branch_id'] = $this->branch_id;
	  $post['user_id'] = $this->user_id;
	  $post['time'] = $this->time;
	  $post['date'] = $this->input->post('date');
	  $post['total_amount'] = $this->input->post('total_amount');
	  $post['cost_amount'] = $this->input->post('cost_amount');
	  $post['paid'] = $this->input->post('paid');
	  $post['due'] = $this->input->post('due');
	  $post['charge'] = $this->input->post('charge');
	  $post['model'] = $this->input->post('model');
	  $post['brand'] = $this->input->post('brand');
	  $post['problem'] = $this->input->post('problem');
	  $post['customer_id'] = $this->input->post('customer_id');
	  $post['paid_new'] = $this->input->post('paid_new');
	  //$post['advance'] = $this->input->post('advance');

		$info = update_all($id,'service',$post);
			if($info){
				$done = 0;
				$loop = count($this->input->post('quantity'));
				for($i=0; $i < $loop; $i++){
					$data = [
								'product_id' => $this->input->post('product_id')[$i],
								'ime' => $this->input->post('ime')[$i],
								'price' => $this->input->post('price')[$i],
								'cost' => $this->input->post('cost')[$i],
								'total_price' => $this->input->post('total_price')[$i],
								'total_cost' => $this->input->post('total_cost')[$i],
								'quantity' => $this->input->post('quantity')[$i],
								'user_id'		   => $this->user_id,
								'trigger_id'		   => $id,
								'branch_id'		   => $this->branch_id,
								'date'		   => $post['date']
							];
					$info = add_all($data,'service_items');
						$product_id = $this->input->post('product_id')[$i];
						$ime = $this->input->post('ime')[$i];
						$quantity = $this->input->post('quantity')[$i];
						$instock = my_col('instock','id',$product_id,'products');
						$stock = $instock - $quantity;

						$this->db->set('instock',$stock);
						$this->db->where('id',$product_id);
						$u=$this->db->update('products');
						if($u){
							if(!empty($ime)){
								$this->db->where('ime',$ime);
								$ime_qtydb=$this->db->get("imes")->row()->ime_qty;
								$ime_qty_up = $ime_qtydb - $quantity;

								$this->db->set('ime_qty',$ime_qty_up);
								$this->db->where('ime',$ime);
								$this->db->update('imes');
								}
						$done = 1;
						}
						
				}
				if($done==1)
					echo 1;
				else 
					echo 0;
			}
			else 
				echo 0;
	}
	public function delete_service()
	{
	  $id=$this->uri->segment(3);
	  $data = delete_by_id($id,'services');
		if($data){
			
		 echo 1;
		}
		else 
		 echo 0;
			
	}

	//07.11.22

	public function create_engineer()
	{
		$pram = ['title' => 'Add engineer'];
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('engineers');
		if($query->num_rows() > 0){
			$code = $query->row()->code;
			if($code){
				$code = $code+1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('engineer/add',compact('pram','code'));
	}
	public function add_engineer()
	{
		$post = $this->input->post();				
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
		$info = add_all($post,'engineers');
		if($info)
			echo 1;
		else 
			echo 0;
		
	}
	public function manage_engineer()
	{
		$pram  = ['title' => 'Manage engineer'];
		$categories = view_all_with_branch('engineers',$this->branch_id);
		 $this->load->view('engineer/manage',compact('pram','categories'));
	}
	
	public function delete_engineer()
	{
	    $id=$this->uri->segment(3);
		$data = delete_by_id($id,'engineers');
		if($data)
		 echo 1;
		else 
		 echo 0;	
	}
}
?>