<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Product extends CI_Controller {
public function __construct(){
	parent::__construct();
	$this->branch_id = $this->session->userdata('branch_id');
	$this->user_id   = $this->session->userdata('user_id');
    $timezone = 'Asia/Dhaka';
    date_default_timezone_set($timezone);
    $timestamp = time();
	$da = date('Y-m-d',$timestamp);
	$time = date('h:i:s',$timestamp);
	$this->time = date('g:i a');
	list($month, $day, $year)=explode("-",$da);
	list($hr, $min, $sec)=explode(":",$time);
	$this->invoice_number = $month.$day.$year.$hr.$min.$sec.$this->user_id;
	$this->date = date('Y-m-d',$timestamp);
	$this->time = date('g:i a');
	if(!$this->session->userdata('logged_in')){
	   $this->session->set_flashdata('message','Sorry,You are Not Logged In');
       $this->session->set_flashdata('message_class','alert-danger');
       return redirect('login');
	}
}

public function autocomplete()
{
	$name = $this->input->get('term');
	//$products = name_search('name','products',$name,$this->branch_id);

	$this->db->where('branch_id',$this->branch_id);
	$this->db->like('name',$name);
	$this->db->or_like('barcode',$name);
	$products = $this->db->get('products')->result();

	if($products){
        $result = [];
		foreach ($products as $key => $value) {
		$result[]= $value->name. " {".$value->barcode."} ".$value->id;
		}
		
		echo json_encode($result);
    }	
}
public function autocomplete1()
{
	$name = $this->input->post('query');
	$products = name_search('name','products',$name,$this->branch_id);

$output='<ul class="list-unstyled" style="z-index:50">';

	if($products){
        foreach($products as $res){
        	$output.='<li class="p_name" style="color:#088424;font-weight:bold;font-size:18px;">'.$res->name.'</li>';       
        }
    }
    $output.='</ul>';
    echo $output;
	
}
public function auto1ime()
{
	$name = $this->input->post('query');
	//$products = name_search('name','products',$name,$this->branch_id);
	$this->db->where('branch_id',$this->branch_id);
	$this->db->where('ime_qty >',0);
	$this->db->like('ime',$name);
	$this->db->limit(25);
	$products = $this->db->get('imes')->result();


$output='<ul class="list-unstyled" style="z-index:50">';

	if($products){
        foreach($products as $res){
        	$output.='<li class="p_ime" style="color:#088424;font-weight:bold;font-size:18px;">'.$res->ime.'</li>';       
        }
    }
    $output.='</ul>';
    echo $output;
	
}
public function auto_productbc(){
	$name = $this->input->post('name');

	$result = view_all_with_branch_col('products',$this->branch_id,'name',$name);
	// print_r($result);exit;
	$last_cost = 0;
	$pric = $result->sale_price;
	$cost = $result->cost_price;
	$id = $result->id;
	$name = $result->name;
	$size = $result->size;
	$wsale_price = $result->wsale_price;
	$category_id = $result->category_id;
	$low_stock = $result->low_stock;
	$brand_id = $result->brand_id;
	$note = $result->note;
	$this->db->where('name',$name);
	$this->db->order_by('id','DESC');
	$this->db->limit(1);
    $rq = $this->db->get('product_purchase');
    if($rq->num_rows() > 0)
	$last_cost = $rq->row()->cost_price;
	
	echo stock_calc($id,$name,$this->branch_id).'##'.$pric.'##'.$cost."##".$id.'##'.$size."##".$category_id."##".$low_stock."##".$wsale_price."##".$brand_id."##".$note."##".$last_cost."##".$name."##".$result->barcode;
	}
public function auto_product(){
	$name = $this->input->post('name');

	$result = view_all_with_branch_col('products',$this->branch_id,'id',$name);
	// print_r($result);exit;
	$last_cost = 0;
	$pric = $result->sale_price;
	$cost = $result->cost_price;
	$id = $result->id;
	$name = $result->name;
	$size = $result->size;
	$wsale_price = $result->wsale_price;
	$category_id = $result->category_id;
	$low_stock = $result->low_stock;
	$brand_id = $result->brand_id;
	$note = $result->note;
	$this->db->where('name',$name);
	$this->db->order_by('id','DESC');
	$this->db->limit(1);
    $rq = $this->db->get('product_purchase');
    if($rq->num_rows() > 0)
	$last_cost = $rq->row()->cost_price;
	
	echo stock_calc($id,$name,$this->branch_id).'##'.$pric.'##'.$cost."##".$id.'##'.$size."##".$category_id."##".$low_stock."##".$wsale_price."##".$brand_id."##".$note."##".$last_cost."##".$name."##".$result->barcode;
	}
	public function barcode_data(){
	$name = $this->input->post('name');

	$result = view_all_with_branch_col('products',$this->branch_id,'barcode',$name);
	// print_r($result);exit;
	$last_cost = 0;
	$pric = $result->sale_price;
	$cost = $result->cost_price;
	$id = $result->id;
	$name = $result->name;
	$size = $result->size;
	$wsale_price = $result->wsale_price;
	$category_id = $result->category_id;
	$low_stock = $result->low_stock;
	$brand_id = $result->brand_id;
	$note = $result->note;
	$this->db->where('name',$name);
	$this->db->order_by('id','DESC');
	$this->db->limit(1);
    $rq = $this->db->get('product_purchase');
    if($rq->num_rows() > 0)
	$last_cost = $rq->row()->cost_price;
	
	echo stock_calc($id,$name,$this->branch_id).'##'.$pric.'##'.$cost."##".$id.'##'.$size."##".$category_id."##".$low_stock."##".$wsale_price."##".$brand_id."##".$note."##".$last_cost."##".$name;
	}
	public function auto_product_ime(){
	    $branch_id = $this->branch_id;
		$ime = $name = $this->input->post('name');
		$product_id = my_col('product_id','ime',$name,'imes');
		$warranty = my_col_desc('date','ime',$name,'product_sale');
		$cm = my_col_desc('comment','ime',$name,'product_sale');
		$qty = my_col_desc('quantity','ime',$name,'product_sale');
		if(empty($qty))
			$qty = 0;
		if(empty($warranty))
		$warranty = my_col('warranty','ime',$name,'imes');

		$supplier_id = my_col('supplier_id','ime',$name,'imes');
		$customer_id = my_col_desc('customer_id','ime',$name,'product_sale');
		$chalan_no = my_col('chalan_no','ime',$name,'imes');
		$purchase_date = my_col('purchase_date','ime',$name,'imes');
		$sale_date = my_col_desc('date','ime',$name,'product_sale');
		$result = view_all_with_branch_col('products',$this->branch_id,'id',$product_id);
		$stck = get_sum_prev_by_two('ime_qty','ime_purchase','ime',$ime,'branch_id',$branch_id) - get_sum_prev_by_two('quantity','product_sale','ime',$ime,'branch_id',$branch_id) - get_sum_prev_by_two('quantity','vendor_return','ime',$ime,'branch_id',$branch_id) + get_sum_prev_by_two('rcv_quantity','vendor_return','ime',$ime,'branch_id',$branch_id);
		$id = $result->id;
		$category_id = $result->category_id;
		$low_stock = $result->low_stock;
		$pname = $result->name;
		$cccc = $result->cost_price;
		$pric = my_col('sale_price','ime',$name,'imes');
		$cost = my_col('cost_price','ime',$name,'imes');
		$wsale_price = my_col('wsale_price','ime',$name,'imes');
		echo $stck.'##'.$pric.'##'.$cost."##".$id.'##'.$pname."##".$category_id."##".$low_stock."##".$warranty."##".$sale_date."##".$supplier_id."##".$customer_id."##".$chalan_no."##".$wsale_price."##".$purchase_date."##".$qty."##".$cccc."##".$cm;
	}
	public function float_purchase()
	{
		$post = $this->input->post();			
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
		$name = $this->input->post('name');
		$post['warranty'] = date('Y-m-d',strtotime($this->input->post('warranty')));
		$post['product_name'] = $name;
		$post['ime'] = $this->input->post('ime')[0];
		$post['ime_qty'] = $this->input->post('ime_qty')[0];
		//print_r($post);exit;
		$insert = add_all($post,'float_purchase');
		$loop = count($this->input->post('ime'));
		for($i=0; $i < $loop; $i++){
			$data = [
						'product_name' => $name,
						'ime'		   => $this->input->post('ime')[$i],
						'ime_qty'		   => $this->input->post('ime_qty')[$i],
						'user_id'		   => $this->user_id,
						'branch_id'		   => $this->branch_id,
					];
			$info = add_all($data,'ime_purchase');
		}
		if($info)
			echo 1;
		else 
			echo 0;

	}
	public function create_purchase()
	{
		$pram = ['title' => 'Product Purchase'];
		$brands = view_all_with_branch('brands',$this->branch_id);
		$categories = view_all_with_branch('categories',$this->branch_id);
		$asset_heads = view_all_with_branch('asset_heads',$this->branch_id);
		$suppliers = view_all_with_branch('suppliers',$this->branch_id);
		$banks = view_all_with_branch('banks',$this->branch_id);
		$floats = view_all_with_user('float_purchase',$this->user_id);
		$complete = delete_by_match_col('user_id',$this->user_id,'float_purchase');
		
		$this->db->where('branch_id',$this->branch_id);
		$this->db->where('user_id',$this->user_id);
		$this->db->where('trigger_id',0);
		$this->db->delete('ime_purchase');
						
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('purchase_invoice');
		if($query->num_rows() > 0){
			$code = $query->row()->id;
			if($code){
				$code = $code+1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('purchase/add_purchase',compact('pram','brands','categories','brands','suppliers','banks','floats','code','asset_heads'));
	}
	public function purchase()
	{	
		// $p = $this->input->post();
		// print_r($p);exit;
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['invoice_number'] = $this->input->post('invoice_number');
	    $post['time'] = $this->time;
	    $post['chalan_no'] = $this->input->post('chalan_no');
	    $post['supplier_id'] = $supplier_id = $this->input->post('supplier_id');
	    $post['bank_id'] = $this->input->post('bank_id');
	    $post['payment_method'] = $this->input->post('payment_method');
	    $post['discount'] = $this->input->post('discount');
	    $post['cash_paid'] = $this->input->post('cash_paid');
	    $post['check_num'] = $this->input->post('check_num');
	    $post['check_amount'] = $this->input->post('check_amount');
	    $post['check_appr_date'] = $this->input->post('check_appr_date');
	    $post['transport'] = $this->input->post('transport');
	    $post['total_amount'] = $this->input->post('total_amount');
	    $post['fixed_amount'] = $this->input->post('fixed_amount');
	    $post['warranty_amount'] = $this->input->post('warranty_amount');
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
		$post['approved_st'] = 1;
		$ch = $post['check_amount'] ? $post['check_amount'] : 0;
		$post['due'] = $this->input->post('due');
		$bank_id = $this->input->post('bank_id');
		if(!empty($bank_id)){
			$amount = $this->input->post('check_amount');
		    $balb = my_col('final_balance','id',$bank_id,'banks');
		    $balanceb = $balb - $ch;
		}
		
		$info = add_all_insert_id($post,'purchase_invoice');
		if($info){
            
			$pre_due = my_col('balance','id',$post['supplier_id'],'suppliers');
			$due = $pre_due + $post['due'];
			 update_one_col_with_id('balance','id',$post['supplier_id'],'suppliers',$due);
			 if(!empty($bank_id))
			 $up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balanceb); 
			$i = 0;
			 $loop = count($this->input->post('quantity'));
			for($i=0;$i<$loop;$i++){
			    $qty = $this->input->post('quantity')[$i];
			$data = [
					'name'=> strtoupper($this->input->post('name')[$i]),
					'commision' => $this->input->post('commision')[$i],
					'product_id' => $this->input->post('product_id')[$i],
					'wsale_price' => $this->input->post('wsale_price')[$i],
					'poribahan' => $this->input->post('poribahan')[$i],
					'quantity' => $this->input->post('quantity')[$i],
					'category_id' => $this->input->post('category_id')[$i],
					'brand_id' => $this->input->post('brand_id')[$i],
					'size' => "PICS",
					'cost_price' => $this->input->post('cost_price')[$i],
					'sale_price' => $this->input->post('sale_price')[$i],
					'instock' => $this->input->post('instock')[$i],
					'total_price' => $this->input->post('total_price')[$i],
					'fixed_head' => $this->input->post('fixed_head')[$i],
					'fixed_cost' => $this->input->post('fixed_cost')[$i],
					'warranty_qty' => $this->input->post('warranty_qty')[$i],
					'warranty_price' => $this->input->post('warranty_price')[$i],
					'warranty_ref' => $this->input->post('warranty_ref')[$i],
					'comment' => $this->input->post('comment')[$i],

					'low_stock' => $this->input->post('low_stock')[$i],
					'note' => $this->input->post('note')[$i],
					'supplier_id' => $post['supplier_id'],
					'branch_id' => $this->branch_id,
	    			'user_id' => $this->user_id,
	    			'date' => date("Y-m-d",strtotime($this->input->post('date'))),
	    			'hidden_instock' => $this->input->post('hidden_instock')[$i],
	    			'warranty' => $this->input->post('warranty')[$i],
	    			'trigger_id' => $info,
					];
					$data1 = [
								'branch_id'=>$this->branch_id,
								'user_id'=>$this->user_id,
								'purchase_trigger_id' => $info,
								'head_id' => $this->input->post('fixed_head')[$i],
								'comment' => $this->input->post('comment')[$i],
								'amounta' => $this->input->post('fixed_cost')[$i],
								'date' => date("Y-m-d",strtotime($this->input->post('date'))),
							 ];

				$warranty_ref = $this->input->post('warranty_ref')[$i] ? $this->input->post('warranty_ref')[$i] : 0;
				if($warranty_ref != 0){
					$warranty_price = $this->input->post('warranty_price')[$i] ? $this->input->post('warranty_price')[$i] : 0;	
				$warranty_qty = $this->input->post('warranty_qty')[$i] ? $this->input->post('warranty_qty')[$i] : 0;	
				if($warranty_price != 0):
					$this->db->set('taka_receive',1);
					$this->db->set('taka_quantity',$warranty_qty);
					$this->db->set('cash_paid',$warranty_price);
				else:
					$this->db->set('product_receive',1);
					$this->db->set('rcv_quantity',$warranty_qty);
				endif;
				$this->db->set('purchase_trigger_id',$info);
				$this->db->where('id',$warranty_ref);
				$this->db->update('vendor_return');
				}

				$purchase = add_all($data,'product_purchase');
				if(!empty($data1['head_id']))
				$purchase1 = add_all($data1,'asset');
				if($purchase){
					$product_id=$this->input->post('product_id')[$i];
					$name=$this->input->post('name')[$i];
					$warranty=$this->input->post('warranty')[$i];
					$qnt = $this->input->post('quantity')[$i];
					$poribahan = $this->input->post('poribahan')[$i] ? $this->input->post('poribahan')[$i] : 0;
					$pbhn = $poribahan;
					$new_cost_price = $this->input->post('cost_price')[$i] + $pbhn;
					$sale_price = $this->input->post('sale_price')[$i];
					$wsale_price = $this->input->post('wsale_price')[$i];
					$low_stock = $this->input->post('low_stock')[$i];
					$res = view_all_with_branch_col('products',$this->branch_id,'id',$product_id);					
					if(isset($res)){
					    $id = $product_id;
					    $branch_id = $this->branch_id;
						 $stock = get_sum_prev_by_two('quantity','product_purchase','product_id',$id,'branch_id',$branch_id)-$qty+$res->quantity - get_sum_prev_by_two('quantity','product_sale','product_id',$id,'branch_id',$branch_id) - get_sum_prev_by_two('quantity','complain_items','product_id',$id,'branch_id',$branch_id) - get_sum_prev_by_two('quantity','vendor_return','product_id',$id,'branch_id',$branch_id) + get_sum_prev_by_three('rcv_quantity','vendor_return','product_id',$id,'branch_id',$branch_id,'product_receive',1) + get_sum_prev_by_two('quantity','product_sale_return_invoice','product_id',$id,'branch_id',$branch_id)+get_sum_prev_by_three('quantity','product_sale_return_invoice','product_id',$id,'branch_id',$branch_id,'receive',1)-get_sum_prev_by_three('quantity','product_sale_return_invoice','product_id',$id,'branch_id',$branch_id,'send',1)-get_sum_prev_by_three('quantity','product_sale_return_invoice','product_id',$id,'branch_id',$branch_id,'delivery',1)+get_sum_prev_by_two('quantity','purchase_return_invoice','product_id',$id,'branch_id',$branch_id) - get_sum_prev_by_three('quantity','purchase_return_invoice','product_id',$id,'branch_id',$branch_id,'receive',1) - get_sum_prev_by_three('quantity','purchase_return_invoice','product_id',$id,'branch_id',$branch_id,'damage',1) - get_sum_prev_by_two('quantity','losts','product_id',$id,'branch_id',$branch_id);
						$old_cost_price = $res->cost_price;
						$total_old = $old_cost_price * $stock;
						
						$nq = $this->input->post('quantity')[$i];
						
						$total_new = $new_cost_price * $nq;
                        $stckn = ($stock + $nq) ? ($stock + $nq) : 1;
						$cost_price = ($total_new + $total_old) / ($stckn);
						$update = [
									'category_id' => $this->input->post('category_id')[$i],
									'poribahan' => $this->input->post('poribahan')[$i],
									'brand_id' => $this->input->post('brand_id')[$i],
									'size' => "PICS",
									'commision' =>$this->input->post('commision')[$i],
									'wsale_price' =>$this->input->post('wsale_price')[$i],
									'cost_price' => $cost_price,
									'sale_price' => $this->input->post('sale_price')[$i],
									'note' => $this->input->post('note')[$i],
									'instock' => $qnt+$stock,
									'low_stock' => $this->input->post('low_stock')[$i],
									'name'=> strtoupper($this->input->post('name')[$i])
								  ];
						$done = update_all($product_id,'products',$update);
							$pid = $product_id;
						$query = get_all_by_match_branch_four('ime_purchase','product_name',$name,'user_id',$this->user_id,'branch_id',$this->branch_id,'trigger_id',0);
						foreach ($query->result() as $key => $value) {

							$ime = $value->ime;
							$ime_qty = $value->ime_qty;
							$chkime= $this->db->where('ime',$ime)->get("imes");
							
							if($chkime->num_rows() >0){

							    $this->db->where('ime',$ime);
        						$ime_qtydb=$this->db->get("imes")->row()->ime_qty;
        						 $up_ime_qty = $ime_qtydb+$ime_qty;

        						$ime_up = ['product_id'=>$pid,'branch_id'=>$this->branch_id,'supplier_id'=>$supplier_id,'warranty'=>$warranty,'sale_price'=>$sale_price,'cost_price'=>$new_cost_price,'chalan_no'=>$post['chalan_no'],'ime_qty'=>$up_ime_qty,'purchase_date'=>$post['date'],'wsale_price'=>$wsale_price];

        						$this->db->where('ime',$ime);
        						$this->db->update('imes',$ime_up);

							}else{
								$ime_add = ['ime'=>$ime,'product_id'=>$pid,'branch_id'=>$this->branch_id,'supplier_id'=>$supplier_id,'warranty'=>$warranty,'sale_price'=>$sale_price,'cost_price'=>$new_cost_price,'chalan_no'=>$post['chalan_no'],'ime_qty'=>$ime_qty,'purchase_date'=>$post['date'],'wsale_price'=>$wsale_price];
								$addi = add_all($ime_add,'imes');
							}
							
						}

					}
				}
			}
			if($done)
				{
					$complete = delete_by_match_col('user_id',$this->user_id,'float_purchase');
					if($complete){
						$this->db->set('trigger_id',$info);
						$this->db->where('branch_id',$this->branch_id);
						$this->db->where('user_id',$this->user_id);
						$this->db->where('trigger_id',0);
						$this->db->update('ime_purchase');
						echo 1;
					}
					else
						echo 0;
				}
			else
				echo 0;
		}
		else{
			echo 0;
		}
	}
	public function manage_purchase(){
		$pram = ['title' => 'Manage Purchase'];
		$products  = view_all_with_branch('purchase_invoice',$this->branch_id);
		$this->load->view('purchase/manage_purchase',compact('pram','products'));
	}
	public function delete_purchase(){
		$id = $this->uri->segment(3);
		$invoice =  view_all_by_id($id,'purchase_invoice');
	    $supplier_id = $invoice->supplier_id;
		$pre_due = my_col('balance','id',$supplier_id,'suppliers');
		$in_due = $invoice->due;
		$due = $pre_due - $in_due;
		$query = get_all_by_match_one($id,'product_purchase','trigger_id');
		foreach ($query->result() as $value) {
			$name = $value->name;
			$quantity = $value->quantity;
			$branch_id = $value->branch_id;
			$pre_all = view_all_with_branch_col('products',$this->branch_id,'name',$name);
			$pre_stock = $pre_all->instock; 
			$in_stock = $pre_stock - $quantity;
			$this->db->set('instock',$in_stock);
			$this->db->where('name',$name);
			$this->db->where('branch_id',$branch_id);
		    $this->db->update('products');
		}
		$bank_id = my_col('bank_id','id',$id,'purchase_invoice');
	    $amount = my_col('check_amount','id',$id,'purchase_invoice');
	    $bal = my_col('final_balance','id',$bank_id,'banks');
		$balance = $bal + $amount;
		if(!empty($bank_id))
		$up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balance);
		$update = update_one_col_with_id('balance','id',$supplier_id,'suppliers',$due);
		if($update){
			$delete = delete_by_match_col('trigger_id',$id,'product_purchase');
			$delete = delete_by_match_col('trigger_id',$id,'ime_purchase');
			$delete = delete_by_match_col('purchase_trigger_id',$id,'asset');
			if($delete){
				$data = delete_by_id($id,'purchase_invoice');
				if($data){
				    echo 1;
				}
				else 
				 echo 0;
			}
		}
	}
	public function view_purchase()
	{
		$pram = ['title' => 'Update Purchase'];
		$id = $this->uri->segment(3);
		$brands = view_all_with_branch('brands',$this->branch_id);
		$categories = view_all_with_branch('categories',$this->branch_id);
		$suppliers = view_all_with_branch('suppliers',$this->branch_id);
		$banks = view_all_with_branch('banks',$this->branch_id);
		$floats = get_all_by_match_one($id,'product_purchase','trigger_id');
		$invoice = view_all_by_id($id,'purchase_invoice');
		$this->load->view('purchase/update_purchase',compact('pram','brands','categories','suppliers','banks','floats','invoice'));
	}
	public function update_purchase()
	{	
		$id = $this->input->post('id');
		$invoice = view_all_by_id($id,'purchase_invoice');
		$supplier_id = $invoice->supplier_id;
		$due_amount =  $invoice->due;
		$pre_due = my_col('balance','id',$supplier_id,'suppliers');
		 $due =  $pre_due - $due_amount;
		 $update = update_one_col_with_id('balance','id',$supplier_id,'suppliers',$due);

	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['invoice_number'] = $this->invoice_number;
	    $post['chalan_no'] = $this->input->post('chalan_no');
	    $post['supplier_id'] = $this->input->post('supplier_id');
	    $post['bank_id'] = $this->input->post('bank_id');
	    $post['due'] = $this->input->post('due');
	    if($post['due'] > 0 && $this->input->post('payment_method') == "Cash")
	    	$post['payment_method'] = "Due";
	    else
	    $post['payment_method'] = $this->input->post('payment_method');
	    $post['discount'] = $this->input->post('discount');
	    $post['cash_paid'] = $this->input->post('cash_paid');
	    $post['check_num'] = $this->input->post('check_num');
	    $post['check_amount'] = $this->input->post('check_amount');
	    $post['check_appr_date'] = $this->input->post('check_appr_date');
	    $post['total_amount'] = $this->input->post('total_amount');
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date_update')));

		$info = update_all($id,'purchase_invoice',$post);
		if($info){
			 $pre_due = my_col('balance','id',$post['supplier_id'],'suppliers');
			 $due = $pre_due + $post['total_amount'] - $post['cash_paid'] - $post['discount'];
			$sup = update_one_col_with_id('balance','id',$post['supplier_id'],'suppliers',$due);
		$query = get_all_by_match_one($id,'product_purchase','trigger_id');
		foreach ($query->result() as $value) {
			$pre_stock = 0;
			$name = $value->name;
			$quantity = $value->quantity;
			$branch_id = $value->branch_id;
			$pre_all = view_all_with_branch_col('products',$this->branch_id,'name',$name);
			if($pre_all)
			$pre_stock = $pre_all->instock; 
			
			$in_stock = $pre_stock - $quantity;
			// if($in_stock < 0)
			// 	$in_stock = 0;
			$this->db->set('instock',$in_stock);
			$this->db->where('name',$name);
			$this->db->where('branch_id',$branch_id);
		    $this->db->update('products');
		}
			$del = delete_by_match_col('trigger_id',$id,'product_purchase');
			$i = 0;
			 $loop = count($this->input->post('quantity'));
			for($i=0;$i<$loop;$i++){
			$data = [
					'name'=> strtoupper($this->input->post('name')[$i]),
					'quantity' => $this->input->post('quantity')[$i],
					'category_id' => $this->input->post('category_id')[$i],
					'size' => strtoupper($this->input->post('size')[$i]),
					'cost_price' => $this->input->post('cost_price')[$i],
					'sale_price' => $this->input->post('sale_price')[$i],
					'instock' => $this->input->post('instock')[$i],
					'total_price' => $this->input->post('total_price')[$i],
					'branch_id' => $this->branch_id,
	    			'user_id' => $this->user_id,
	    			'date' => date("Y-m-d",strtotime($this->input->post('date')[$i])),
	    			'hidden_instock' => $this->input->post('hidden_instock')[$i],
	    			'trigger_id' => $invoice->id,
					];
				$purchase = add_all($data,'product_purchase');
				if($purchase){
					$name=$this->input->post('name')[$i];
					$res = view_all_with_branch_col('products',$this->branch_id,'name',$data['name']);
					
					if(isset($res)){
						$stock = $res->instock ;
						$old_cost_price = $res->cost_price;
						$total_old = $old_cost_price * $stock;
						$new_cost_price = $this->input->post('cost_price')[$i];
						$nq = $this->input->post('quantity')[$i];
						$total_new = $new_cost_price * $nq;
						$div = $stock + $nq ? $stock + $nq : 1;
						$cost_price = ($total_new + $total_old) / $div;
						$in_stock = $stock + $this->input->post('quantity')[$i];
						$update = [
									'category_id' => $this->input->post('category_id')[$i],
									'size' => strtoupper($this->input->post('size')[$i]),
									'cost_price' => $this->input->post('cost_price')[$i],
									'sale_price' => $this->input->post('sale_price')[$i],
									'instock' => $in_stock,
									'name'=> strtoupper($this->input->post('name')[$i])
								  ];
						$done = update_all_branch_name($update['name'],'products',$update,$this->branch_id);

					}else{
						$save = [
									'category_id' => $this->input->post('category_id')[$i],
									'size' => strtoupper($this->input->post('size')[$i]),
									'cost_price' => $this->input->post('cost_price')[$i],
									'sale_price' => $this->input->post('sale_price')[$i],
									'instock' => $this->input->post('quantity')[$i],
									'name'=> strtoupper($this->input->post('name')[$i]),
									'branch_id' => $this->branch_id,
								  ];
						$done = add_all($save,'products');
					}
				}
			}
			if($done)
				echo 1;
			else
				echo 0;
		}
		else{
			echo 0;
		}
	}



	public function purchase_cheque()
	{
		$pram = ['title' => 'Purchase Cheque Details'];
		$message = "";
		$id = $this->uri->segment(2);
		$datas = view_all_by_id($id,'purchase_invoice');
		$this->load->view('purchase/cheque_info',compact('pram','datas','message'));
	}
	public function purchase_cheque_approved()
	{
		$pram = ['title' => 'Purchase Cheque Details'];
		$id = $this->uri->segment(2);
		$datas = view_all_by_id($id,'purchase_invoice');
		$prev_due = $datas->due;
		$check_amount = $datas->check_amount;
		$inv_due = $prev_due - $check_amount;
		$prev_cash = $datas->cash_paid;
		$cash_paid = $prev_cash;
		$supplier_id = $datas->supplier_id;
		$sup_due = my_col('balance','id',$supplier_id,'suppliers');
		$data = [
				'due' => $inv_due,
				'cash_paid' => $cash_paid,
				'approved_st' => 1
				];
		$done = update_all($id,'purchase_invoice',$data);
		if($done){
			$due = $sup_due - $check_amount;
			$due_up = update_one_col_with_id('balance','id',$supplier_id,'suppliers',$due);
			if($due_up){
				$datas = view_all_by_id($id,'purchase_invoice');
				$message = "Cheque Approved Successfully!";
				$this->load->view('purchase/cheque_info',compact('pram','datas','message'));
			}
			
		}
	}
	public function purchase_cheque_return()
	{
		$pram = ['title' => 'Purchase Cheque Details'];
		$id = $this->uri->segment(2);
		
		$data = [
				'return_st' => 1
				];
		$done = update_all($id,'purchase_invoice',$data);
		if($done){
				$datas = view_all_by_id($id,'purchase_invoice');
				$message = "Cheque Returned Successfully!";
				$this->load->view('purchase/cheque_info',compact('pram','datas','message'));
			}
	}
	public function sale_cheque()
	{
		$pram = ['title' => 'Sale Cheque Details'];
		$message = "";
		$id = $this->uri->segment(2);
		$datas = view_all_by_id($id,'product_sale_invoice');
		$this->load->view('sale/cheque_info',compact('pram','datas','message'));
	}
	public function sale_cheque_approved()
	{
		$pram = ['title' => 'Sale Cheque Details'];
		$id = $this->uri->segment(2);
		$datas = view_all_by_id($id,'product_sale_invoice');
		$prev_due = $datas->due;
		$check_amount = $datas->check_amount;
		$inv_due = $prev_due - $check_amount;
		$prev_cash = $datas->cash_paid;
		$cash_paid = $prev_cash;
		$customer_id = $datas->customer_id;
		$cus_due = my_col('balance','id',$customer_id,'customers');
		$data = [
				'due' => $inv_due,
				'cash_paid' => $cash_paid,
				'approved_st' => 1
				];
		$done = update_all($id,'product_sale_invoice',$data);
		if($done){
			$due = $cus_due - $check_amount;
			$due_up = update_one_col_with_id('balance','id',$customer_id,'customers',$due);
			if($due_up){
				$datas = view_all_by_id($id,'product_sale_invoice');
				$message = "Cheque Approved Successfully!";
				$this->load->view('sale/cheque_info',compact('pram','datas','message'));
			}
			
		}
	}
	public function sale_cheque_return()
	{
		$pram = ['title' => 'Sale Cheque Details'];
		$id = $this->uri->segment(2);
		
		$data = [
				'return_st' => 1
				];
		$done = update_all($id,'product_sale_invoice',$data);
		if($done){
				$datas = view_all_by_id($id,'product_sale_invoice');
				$message = "Cheque Returned Successfully!";
				$this->load->view('sale/cheque_info',compact('pram','datas','message'));
			}
	}
	public function create_product_return()
	{
		$pram = ['title' => 'Product Return'];
		$suppliers = view_all_with_branch('suppliers',$this->branch_id);
		$this->load->view('purchase/add_product_return',compact('pram','suppliers'));
	}
	public function product_return()
	{	
		$done=0;
		$loop = count($this->input->post('quantity'));
		for($i=0;$i<$loop;$i++){

		$post['customer_id'] = $this->input->post('customer_id');
		$post['date'] = $this->input->post('date');
		
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['time'] = $this->time;
	    $post['invoice_number'] = $this->invoice_number;
	    $post['product_id']=$this->input->post('id')[$i];
	    $post['price']=$this->input->post('price')[$i];
	    $post['total_price']=$this->input->post('total_price')[$i];
	    $post['quantity']=$this->input->post('quantity')[$i];
	    $post['invoice']=$this->input->post('invoice')[$i];
		$info = add_all_insert_id($post,'purchase_return_invoice');
		if($info){
			$id=$this->input->post('id')[$i];
			$quantity=$this->input->post('quantity')[$i];
			$stock = my_col_branch('instock','id',$id,'products',$this->branch_id);
			$in_stock = $stock + $quantity;					
			if(isset($stock)){
				$done = update_stock_product_id($id,'products',$in_stock);
			}
			$done=1;
			}
			else{
				$done=0;
			}
		}

		if($done == 1){
			echo 1;exit;
		}
		else{
			echo 0;exit;
		}
	}
	
	public function manage_product_return(){
		$pram = ['title' => 'Manage Purchase'];
		
		
		$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('receive',0);
    	$this->db->where('damage',0);
    	$products  = $this->db->get('purchase_return_invoice')->result();

		$this->load->view('purchase/manage_product_return',compact('pram','products'));
	}
	public function delete_product_return(){
		$id = $this->uri->segment(3);
		
		
		$receive = my_col('receive','id',$id,'purchase_return_invoice');
		$damage = my_col('damage','id',$id,'purchase_return_invoice');
		$quantity = my_col('quantity','id',$id,'purchase_return_invoice');
		$branch_id = $this->branch_id;
		$product_id = my_col('product_id','id',$id,'purchase_return_invoice');
		$update = 1;
		if($receive == 0):
		
		$pre_stock = my_col_branch('instock','id',$product_id,'products',$branch_id);
		$in_stock = $pre_stock - $quantity;
		$update = update_stock_product_id($product_id,'products',$in_stock);
		endif;

		if($damage==1):
		$pre_stock = my_col_branch('instock','id',$product_id,'products',$branch_id);
		$pre_damage = my_col_branch('damage','id',$product_id,'products',$branch_id);
		$in_stock = $pre_stock + $quantity;
		$in_damage = $pre_damage - $quantity;
		$this->db->set('instock',$in_stock);
		$this->db->set('damage',$in_damage);
		$this->db->where('id',$product_id);
		$this->db->update('products');
		$update = update_stock_product_id($product_id,'products',$in_stock);
		endif;
		if($update){
		$data = delete_by_id($id,'purchase_return_invoice');
				if($data){
				    echo 1;exit;
				}
				else 
				 echo 0;exit;
		}
	}
	public function create_sale()
	{
		$pram = ['title' => 'Product Sale'];	
		$customers = view_all_with_branch('customers',$this->branch_id);
		$floats = view_all_with_user('float_sale',$this->user_id);
		$query = $this->db->order_by('id', 'DESC');
		$query = $this->db->limit(1);
		$query = $this->db->get('product_sale_invoice');
		if($query->num_rows() > 0){
			$code = $query->row()->id;
			if($code){
				$code = $code+1;
			}
		}else{
			$code = 1;
		}
		$this->load->view('sale/add_sale',compact('pram','floats','code','customers'));
	}
	public function float_sale()
	{
		$loop = count($this->input->post('ime'));
		for($i=0; $i < $loop; $i++){
		$data = [
					'product_id' => $this->input->post('product_id'),
					'ime'		   => $this->input->post('ime')[$i],
					'ime_qty'		   => $this->input->post('quantity'),
					'user_id'		   => $this->user_id,
					'branch_id'		   => $this->branch_id,
				];
		$info = add_all($data,'ime_sale');
		}
		if($info)
			echo 1;
		else 
			echo 0;
	}
	public function sale()
	{	

	    $branch_id=$post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['invoice_number'] = $this->invoice_number;
	    $post['time'] = $this->time;
	    $post['customer_id'] = $this->input->post('customer_id');
	    $customer_id = $this->input->post('customer_id');
	    $pre_due=round( my_col('previous_balance','id',$customer_id,'customers') + get_sum_prev_by_two('due','product_sale_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('due','product_sale_return_invoice','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('paid','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('check_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('bank_amount','collections','customer_id',$customer_id,'branch_id',$branch_id) - get_sum_prev_by_two('discount','collections','customer_id',$customer_id,'branch_id',$branch_id) +  get_sum_prev_by_three('due','complain','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1) + get_sum_prev_by_three('due','services','customer_id',$customer_id,'branch_id',$branch_id,'delivery',1));
		$name = my_col('name','id',$customer_id,'customers');
		$previous_balance = my_col('balance','id',$customer_id,'customers');
		$number = "88".my_col('contact_no','id',$customer_id,'customers');
	    
	    $post['prev_due'] = $pre_due;
	    $post['bank_id'] = $this->input->post('bank_id');
	    $post['charge_amount'] = $this->input->post('charge_amount') ? $this->input->post('charge_amount') : 0;
	    $post['due'] = $this->input->post('due');
	    if($post['due'] > 0 && $this->input->post('payment_method') == "Cash")
	    $post['payment_method'] = "Due";
	    else
	    $post['payment_method'] = $this->input->post('payment_method');
	    $post['commision'] = $this->input->post('commision') ? $this->input->post('commision') : 0;
	    $post['discount'] = $this->input->post('discount') ? $this->input->post('discount') : 0;
	    $post['type'] = $this->input->post('type');
	    $post['mdiscount'] = $this->input->post('mdiscount') ? $this->input->post('mdiscount') : 0;
	    $post['mdiscountt'] = $this->input->post('mdiscountt');
	    $post['cash_paid'] = $this->input->post('cash_paid') ? $this->input->post('cash_paid') : 0;
	    $post['check_num'] = $this->input->post('check_num');
	    $post['ins_type'] = $this->input->post('ins_type');
	    $post['check_amount'] = $this->input->post('check_amount');
	    $post['check_appr_date'] = $this->input->post('check_appr_date');
	    $post['total_amount'] = $this->input->post('total_amount_hide');
	    $post['cost_amount'] = $this->input->post('cost_amount');
	    $post['vat'] = $this->input->post('vat');
	    $post['charge'] = $this->input->post('charge') ? $this->input->post('charge') : 0;
	    $post['chargee'] = $this->input->post('chargee');
	    $post['transport_id'] = $this->input->post('transport_id');
	    $post['lab_trans'] = $this->input->post('lab_trans');
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
	    $ch = $post['check_amount'] ? $post['check_amount'] : 0;
	  
	    $post['approved_st'] = 1;
	    $post['total_install'] = $this->input->post('total_install');
	    $post['install_amount'] = $this->input->post('install_amount');
	    $post['install_date'] = $this->input->post('install_date');
	    $post['last_ins'] = date('Y-m-d', strtotime("+".$post['total_install']." months", strtotime($post['date'])));
       // $df = $pre_due + $post['due'];
	    $bank_id = $this->input->post('bank_id');
	    if(!empty($bank_id)){
	    $balb = my_col('final_balance','id',$bank_id,'banks');
	    $balanceb = $balb + $ch;
		}
		$info = add_all_insert_id($post,'product_sale_invoice');
		if($info){
			// $this->db->set('trigger_id',$info);
			// $this->db->where('branch_id',$this->branch_id);
			// $this->db->where('user_id',$this->user_id);
			// $this->db->where('trigger_id',0);
			// $this->db->update('ime_sale');
			
			//$pre_due = my_col('balance','id',$post['customer_id'],'customers');
			//$due = $pre_due + $post['due'];
			// update_one_col_with_id('balance','id',$post['customer_id'],'customers',$due);
			 if(!empty($bank_id))
			 $up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balanceb); 

			 
			$i = 0;
			$nma = array();
			 $loop = count($this->input->post('quantity'));
			for($i=0;$i<$loop;$i++){

			$data = [
					'product_id'=> $this->input->post('id')[$i],
					'quantity' => $this->input->post('quantity')[$i],
					'comment' => $this->input->post('comment')[$i],
					'ime' => $this->input->post('ime')[$i],
					'sale_price' => $this->input->post('sale_price')[$i],
					'category_id' => $this->input->post('category_id')[$i],
					'cost_price' => $this->input->post('cost_price')[$i],
					'instock' => $this->input->post('instock')[$i],
					'total_price' => $this->input->post('total_price')[$i],
					'warranty_date' => $this->input->post('warranty_date')[$i],
					'total_cost' => $this->input->post('total_cost')[$i],
					'branch_id' => $this->branch_id,
	    			'user_id' => $this->user_id,
	    			'date' => $post['date'],
	    			'hidden_instock' => $this->input->post('hidden_instock')[$i],
	    			'model' => $this->input->post('model')[$i],
	    			'charge' => $this->input->post('chargeing')[$i],
	    			'trigger_id' => $info,
	    			'customer_id' => $post['customer_id'],
	    			'type' => $post['type'],
					];
					$data1 = [
								'branch_id'=>$this->branch_id,
								'user_id'=>$this->user_id,
								'sale_trigger_id' => $info,
								'model' => $this->input->post('model')[$i],
								'customer_id' => $post['customer_id'],
								'charge' => $this->input->post('chargeing')[$i],
								'sale_paid' => $this->input->post('chargeing')[$i],
								'delivery' => 1,
								'complete' => 1,
								'date' => date("Y-m-d",strtotime($this->input->post('date'))),
								'delivery_date' => date("Y-m-d",strtotime($this->input->post('date'))),
							 ];

				$sale = add_all($data,'product_sale');
				if(!empty($data1['model']))
				$sale1 = add_all($data1,'services');
				if($sale){
					$id=$this->input->post('id')[$i];
					$ime=$this->input->post('ime')[$i];
					$quantity=$this->input->post('quantity')[$i];
					$stock = my_col_branch('instock','id',$id,'products',$this->branch_id);
					$in_stock = $stock - $quantity;
					
					if(isset($stock)){
						$done = update_stock_product_id($id,'products',$in_stock);

						if(!empty($ime)){
						$this->db->where('ime',$ime);
						$ime_qtydb=$this->db->get("imes")->row()->ime_qty;
						$ime_qty_up = $ime_qtydb - $quantity;

						$this->db->set('ime_qty',$ime_qty_up);
						$this->db->where('ime',$ime);
						$this->db->update('imes');
						}
						
					}
						
				}
				
			}
			if($done)
				
				{
		$no = "88".my_col('contact_no','id',$customer_id,'customers');
		$name = my_col('name','id',$customer_id,'customers');
		

		$uname = my_col('name','id',$this->user_id,'users');
		$total = $post['total_amount'] + $post['charge_amount'];
		$paid = $post['cash_paid'];
		$tdue = $post['due']+$pre_due;
		$discount = $post['discount']+$post['mdiscount'];
		$vat = $post['charge'];

		$sms = "Dear Customer, Your invoice no ".$info.".Bill amount Tk ".$total."/- discount Tk ".$discount."/- vat Tk ".$vat."/- paid Tk ".$paid."/-  invoice due Tk ".$post['due']."/- total due Tk ".$tdue."/-\n-- Thank you.\n".$uname;
	    sms_send($no,$sms);
	    
					$complete = delete_by_match_col('user_id',$this->user_id,'float_sale');
					if($complete){
					

						echo $info;
					}
					else
						echo 0;
				}
				
			else
				echo 0;
		}
		else{
			echo 0;
		}
	}
	public function sale_manage(){
		$pram = ['title' => 'Manage Sale'];
		$products  = view_all_with_branch('product_sale_invoice',$this->branch_id);
		$this->load->view('sale/manage_sale',compact('pram','products'));
	}
	public function delete_sale(){
		$id = $this->uri->segment(3);
		$invoice =  view_all_by_id($id,'product_sale_invoice');
	    $customer_id = $invoice->customer_id;
		$pre_due = my_col('balance','id',$customer_id,'customers');
		$in_due = $invoice->due;
		$due = $pre_due - $in_due;
		$query = get_all_by_match_one($id,'product_sale','trigger_id');
		foreach ($query->result() as $value) {
			$product_id = $value->product_id;
			$quantity = $value->quantity;
			$ime = $value->ime;
			$branch_id = $value->branch_id;
			$pre_stock = my_col_branch('instock','id',$product_id,'products',$branch_id);
			$in_stock = $pre_stock + $quantity;
			$done = update_stock_product_id($product_id,'products',$in_stock);
			if(!empty($ime)){
				$this->db->where('ime',$ime);
			$ime_qtydb=$this->db->get("imes")->row()->ime_qty;
			$ime_qty_up = $ime_qtydb + $quantity;

			$this->db->set('ime_qty',$ime_qty_up);
			$this->db->where('ime',$ime);
			$this->db->update('imes');
			}
			
		}
		$querys = get_all_by_match_one($id,'ime_sale','trigger_id');
		foreach ($querys->result() as $value) {
			$ime = $value->ime;
			$this->db->set('status',1);
			$this->db->where('ime',$ime);
			$this->db->update('imes');
		}
		$bank_id = my_col('bank_id','id',$id,'product_sale_invoice');
	    $amount = my_col('check_amount','id',$id,'product_sale_invoice');
	    $bal = my_col('final_balance','id',$bank_id,'banks');
		$balance = $bal - $amount;
		if(!empty($bank_id))
		$up = update_one_col_with_id('final_balance','id',$bank_id,'banks',$balance);
		
		$update = update_one_col_with_id('balance','id',$customer_id,'customers',$due);
		if($update){
			$delete = delete_by_match_col('trigger_id',$id,'product_sale');
			$delete1 = delete_by_match_col('sale_trigger_id',$id,'services');
			if($delete){
				$data = delete_by_id($id,'product_sale_invoice');
				if($data){
				    echo 1;
				}
				else 
				 echo 0;
			}
		}
	}
	public function show_sale(){
		$pram = ['title' => 'Update sale'];
		$id = $this->uri->segment(3);
		$floats = get_all_by_match_one($id,'product_sale','trigger_id');
		$invoice = view_all_by_id($id,'product_sale_invoice');
		$customers = view_all_with_branch('customers',$this->branch_id);
		$this->load->view('sale/update_sale',compact('pram','invoice','floats','customers'));
	}
	public function update_sale()
	{	
		$id = $this->input->post('invoice_id');
		$inv_id = $this->input->post('invoice_id');
		$invoice = view_all_by_id($id,'product_sale_invoice');
		$customer_id = $invoice->customer_id;
		$due_amount =  $invoice->due;
		$pre_due = my_col('balance','id',$customer_id,'customers');
		 $due =  $pre_due - $due_amount;
		 $update = update_one_col_with_id('balance','id',$customer_id,'customers',$due);

	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['invoice_number'] = $this->invoice_number;
	    $post['prev_due'] = $due;
	    $post['customer_id'] = $this->input->post('customer_id');
	    $post['bank_id'] = $this->input->post('bank_id');
	    $post['transport_id'] = $this->input->post('transport_id');
	    $post['due'] = $this->input->post('due');
	    if($post['due'] > 0 && $this->input->post('payment_method') == "Cash")
	    	$post['payment_method'] = "Due";
	    else
	    $post['payment_method'] = $this->input->post('payment_method');
	    $post['discount'] = $this->input->post('discount');
	    $post['cash_paid'] = $this->input->post('cash_paid');
	    $post['check_num'] = $this->input->post('check_num');
	    $post['check_amount'] = $this->input->post('check_amount');
	    $post['check_appr_date'] = $this->input->post('check_appr_date');
	    $post['total_amount'] = $this->input->post('total_amount');
	    $post['cost_amount'] = $this->input->post('cost_amount');
	    $post['vat'] = $this->input->post('vat');
	    $post['lab_trans'] = $this->input->post('lab_trans');
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')[0]));

		$info = update_all($id,'product_sale_invoice',$post);
		if($info){
			 $pre_due = my_col('balance','id',$post['customer_id'],'customers');
			 $due = $pre_due + $post['total_amount'] - $post['cash_paid'] - $post['discount'];
			$sup = update_one_col_with_id('balance','id',$post['customer_id'],'customers',$due);
		$query = get_all_by_match_one($id,'product_sale','trigger_id');
		foreach ($query->result() as $value) {
			$product_id = $value->product_id;
			$quantity = $value->quantity;
			$branch_id = $value->branch_id;
			$pre_stock = my_col_branch('instock','id',$product_id,'products',$branch_id);
			$in_stock = $pre_stock + $quantity;
			// if($in_stock < 0)
			// 	$in_stock = 0;
			$done = update_stock_product_id($product_id,'products',$in_stock);
		}
			$del = delete_by_match_col('trigger_id',$id,'product_sale');
			$i = 0;
			 $loop = count($this->input->post('quantity'));
			for($i=0;$i<$loop;$i++){
			$data = [
					'product_id'=> $this->input->post('id')[$i],
					'quantity' => $this->input->post('quantity')[$i],
					'sale_price' => $this->input->post('sale_price')[$i],
					'cost_price' => $this->input->post('cost_price')[$i],
					'instock' => $this->input->post('instock')[$i],
					'total_price' => $this->input->post('total_price')[$i],
					'total_cost' => $this->input->post('total_cost')[$i],
					'branch_id' => $this->branch_id,
	    			'user_id' => $this->user_id,
	    			'date' => date("Y-m-d",strtotime($this->input->post('date')[$i])),
	    			'hidden_instock' => $this->input->post('hidden_instock')[$i],
	    			'trigger_id' => $invoice->id,
	    			'customer_id' => $post['customer_id'],
					];

				$sale = add_all($data,'product_sale');
				if($sale){
					$id=$this->input->post('id')[$i];
					$quantity=$this->input->post('quantity')[$i];
					$stock = my_col_branch('instock','id',$id,'products',$this->branch_id);
					$in_stock = $stock - $quantity;
					if(isset($stock)){
						$done = update_stock_product_id($id,'products',$in_stock);
					}
				}
			}
			if($done)
				echo $inv_id;
			else
				echo 0;
		}
		else{
			echo 0;
		}
	}
	public function create_sale_return(){
		$pram = ['title' => 'Product Sale return'];		
		$this->load->view('sale_return/add_sale_return',compact('pram'));
	}
	public function sale_return()
	{	

	    
	    $post = $this->input->post();
	    $post['time'] = $this->time;
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['invoice_number'] = $this->invoice_number;

		$info = add_all_insert_id($post,'product_sale_return_invoice');
		if($info){
			$customer_id = $this->input->post('customer_id');
		$no = "88".my_col('contact_no','id',$customer_id,'customers');
		

		$uname = my_col('name','id',$this->user_id,'users');
		
		$sms = "Dear Customer, your product warranty is successflly received.\n-- Thank you.\n".$uname;
	    sms_send($no,$sms);
			echo 1;exit;
		}
		else{
			echo 0;exit;
		}
	}
	public function sale_return_manage(){
		$pram = ['title' => 'Manage Sale Return'];
		
	    $this->db->where('branch_id',$this->branch_id);
    	$this->db->where('send',0);
    	$this->db->where('receive',0);
    	$this->db->where('delivery',0);
    	$products  = $this->db->get('product_sale_return_invoice')->result();
//	endif;

		$this->load->view('sale_return/manage_sale_return',compact('pram','products'));
	}
	public function delete_sale_return(){
	 $id = $this->uri->segment(3);

	
	if($id){		
		$data = delete_by_id($id,'product_sale_return_invoice');
		if($data){
		    echo 1;exit;
		}
		else 
		 echo 0;exit;
	}
}
public function update_name(){
	$pram = ['title' => 'Update Name'];
	$this->load->view('update_name',compact('pram'));
}
public function name_update(){
  $pram = ['title' => 'Update Name'];
  $nnm = $this->input->post('name');
  $onm = $this->input->post('hiddenname');
  $id = $this->input->post('id');
  
  $post = $this->input->post();

    $update = update_all($id,'products',$post);
      
    if($update){
        $this->db->set('name',$nnm);
        $this->db->where('name',$onm);
        $up = $this->db->update('product_purchase');            
      //  echo 1;
        return redirect('product_list');
        
    }else{
        echo 0;
    }

}

public function create_voucher()
	{
		$pram = ['title' => 'Product Sale'];	
		$customers = view_all_with_branch('customers',$this->branch_id);
		$this->load->view('voucher/add_sale',compact('pram','customers'));
	}

	public function add_voucher()
	{	
	    $post = $this->input->post();
	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));
		$info = add_all_insert_id($post,'voucher_sale');
		if($info){
            echo 1;exit;
		}else{
				echo 0;exit;
			}
	}

	public function manage_voucher(){
		$pram = ['title' => 'Manage Sale'];
		$products  = view_all_with_branch('voucher_sale',$this->branch_id);
		$this->load->view('voucher/manage_sale',compact('pram','products'));
	}
	public function delete_voucher(){
		$id = $this->uri->segment(3);
		$data = delete_by_id($id,'voucher_sale');
		if($data){
		    echo 1;exit;
		}
		else 
		 echo 0;exit;
			
	}


	//vendor return//
	public function create_vendor_return(){
		$pram = ['title' => 'Product Sale return'];		
		$this->load->view('vendor_return/add',compact('pram'));
	}
	public function vendor_return()
	{	

	    $post['branch_id'] = $this->branch_id;
	    $post['user_id'] = $this->user_id;
	    $post['invoice_number'] = $this->invoice_number;
	    $post['supplier_id'] = $this->input->post('supplier_id');
	    $post['time'] = $this->time;
	    $post['date'] = date("Y-m-d",strtotime($this->input->post('date')));

		$info = add_all_insert_id($post,'vendor_return_invoice');
		if($info){
			
			$i = 0;
			 $loop = count($this->input->post('quantity'));
			for($i=0;$i<$loop;$i++){
			    $ime = $this->input->post('ime')[$i];
			$data = [
					'product_id'=> $this->input->post('id')[$i],
					'ime'=> $ime,
					'quantity' => $this->input->post('quantity')[$i],
					'instock' => $this->input->post('instock')[$i],
					'warranty_date' => $this->input->post('warranty_date')[$i],
					'chalan_no' => $this->input->post('chalan_no')[$i],
					'comment' => $this->input->post('comment')[$i],
					'price' => $this->input->post('price')[$i],
					'total_price' => $this->input->post('total_price')[$i],
					'branch_id' => $this->branch_id,
	    			'user_id' => $this->user_id,
	    			'date' => $post['date'],
	    			'supplier_id' => $post['supplier_id'],
	    			'time' => $post['time'],
	    			'hidden_instock' => $this->input->post('hidden_instock')[$i],
	    			'trigger_id' => $info,
					];

				$sale = add_all($data,'vendor_return');
				if($sale){
					$id=$this->input->post('id')[$i];
					$quantity=$this->input->post('quantity')[$i];
					$stock = my_col_branch('instock','id',$id,'products',$this->branch_id);
					$in_stock = $stock - $quantity;
					if(isset($stock)){
						$done = update_stock_product_id($id,'products',$in_stock);
						$this->db->set('status',0);
						$this->db->where('ime',$ime);
						$this->db->update('imes');
					}
				}
			}
			if($done)
				echo 1;	
			else
				echo 0;
		}
		else{
			echo 0;
		}
	}
public function vendor_return_manage(){
	$pram = ['title' => 'Manage Sale Return'];

	    $this->db->where('taka_receive',0);
    	$this->db->where('product_receive',0);
    	$this->db->where('damage',0);
    	$this->db->where('branch_id',$this->branch_id);
    	$products  = $this->db->get('vendor_return')->result();

	$this->load->view('vendor_return/manage',compact('pram','products'));
}
	public function delete_vendor_return(){
	 $id = $this->uri->segment(3);
	$invoice =  view_all_by_id($id,'vendor_return_invoice');
    
	$query = get_all_by_match_one($id,'vendor_return','trigger_id');
	foreach ($query->result() as $value) {
		$ime = $value->ime;
		$this->db->set('status',0);
		$this->db->where('ime',$ime);
		$this->db->update('imes');
	}
	if($invoice){
		$delete = delete_by_match_col('trigger_id',$id,'vendor_return');
		if($delete){
			$data = delete_by_id($id,'vendor_return_invoice');
			if($data){
			    echo 1;
			}
			else 
			 echo 0;
		}
	}
}
public function invoice_wise_customer(){
	$invoice = $this->input->post('invoice');
	$result = [];
	$q = $this->db->where('id',$invoice)->get('product_sale_invoice');
	$data = $q->result();
	foreach ($data as $key => $value) {
		$result[$value->customer_id] = my_col('name','id',$value->customer_id,'customers');
	}
	echo json_encode($result);
}
public function invoice_wise_product(){
	$invoice = $this->input->post('invoice');
	$result = [];
	$q = $this->db->where('trigger_id',$invoice)->get('product_sale');
	$data = $q->result();
	foreach ($data as $key => $value) {
		$result[$value->product_id] = my_col('name','id',$value->product_id,'products');
	}
	echo json_encode($result);
}
public function invoice_wise_product_qty(){
	$invoice = $this->input->post('invoice');
	$id = $this->input->post('id');
	$result = [];
	$q = $this->db->where('trigger_id',$invoice)->where('product_id',$id)->limit(1)->get('product_sale')->row();
	
	echo $q->quantity."##".$q->sale_price."##".$q->quantity*$q->sale_price."##".$q->date."##".$q->comment;
}
//8.9.22

public function add_product(){
  
  
  $post = $this->input->post();
  $barcode = $this->input->post('barcode');
  $post['opn_purchase'] = $this->input->post('cost_price');
  $post['branch_id'] = $this->branch_id;
	$this->db->where('barcode',$barcode);
	$rrr = $this->db->get("products");
	if($rrr->num_rows() != 0){
	   $post['barcode'] = ''; 
	}
    $update = add_all($post,'products');
      
    if($update){
        
            return redirect('product_list');
       
    }else{
        echo 0;exit;
    }

}
public function delete_product(){
  
  
  $id = $this->uri->segment(3);
  $d = delete_by_id($id,'products');
  if($d){
  	echo 1;exit;
  }else
  echo 0;

}

}	