<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Report extends CI_Controller {
public function __construct(){
	parent::__construct();
	$this->branch_id = $this->session->userdata('branch_id');
	$this->user_id   = $this->session->userdata('user_id');
    $timezone = 'Asia/Dhaka';
    date_default_timezone_set($timezone);
    $timestamp = time();
	$da = date('Y-m-d',$timestamp);
	$time = date('h:i:s',$timestamp);
	list($month, $day, $year)=explode("-",$da);
	list($hr, $min, $sec)=explode(":",$time);
	$this->invoice_number = $month.$day.$year.$hr.$min.$sec.$this->user_id;
	$this->date = date('Y-m-d',$timestamp);
	$this->pc = my_col('cash','id',$this->branch_id,'opening_cash');
	if(!$this->session->userdata('logged_in')){
	   $this->session->set_flashdata('message','Sorry,You are Not Logged In');
       $this->session->set_flashdata('message_class','alert-danger');
       return redirect('login');
	}
}
public function stock_report_print_ime(){
	$pram = ['title' => 'IME Stock Report'];
	$product_id = $this->uri->segment(3);
	$products = get_all_by_match_one($product_id,'imes','product_id');
	$this->load->view('report_popup/stock_report_ime',compact('pram','products'));
}
public function purchase_report(){
	$pram = ['title' => 'Purchase Report'];
	$products  = view_all_with_branch_report_date('purchase_invoice',$this->branch_id,$this->date);
	$this->load->view('report/purchase_report',compact('pram','products'));
}
public function purchase_report_print(){
	$pram = ['title' => 'Purchase Report'];
	$products  = view_all_with_branch_report_date('purchase_invoice',$this->branch_id,$this->date);
	$this->load->view('report_popup/purchase_report',compact('pram','products'));
}
public function purchase_report_popup(){
	$pram = ['title' => 'Purchase Report'];
	 $id = $this->uri->segment(2);
	$invoice  = view_all_by_id($id,'purchase_invoice');
	$query = get_all_by_match_one($id,'product_purchase','trigger_id');
	$products = $query->result();
	 $this->load->view('report_popup/purchase_report_single',compact('pram','products','invoice'));
}
public function complain_report_popup(){
	$pram = ['title' => 'Purchase Report'];
	 $id = $this->uri->segment(2);
	$category = view_all_by_id($id,'complain');

	 $this->load->view('report_popup/complain',compact('pram','category'));
}
public function purchase_report_search_date(){
	$pram = ['title' => 'Purchase Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$products  = view_all_with_branch_report_date_search('purchase_invoice',$this->branch_id,$from,$to);
	$this->load->view('report/purchase_report',compact('pram','products'));
}


public function purchase_reportn(){
	$pram = ['title' => 'Purchase Report'];
	$products  = view_all_with_branch_report_date('purchase_invoicen',$this->branch_id,$this->date);
	$this->load->view('report/purchase_reportn',compact('pram','products'));
}
public function purchase_reportn_print(){
	$pram = ['title' => 'Purchase Report'];
	$products  = view_all_with_branch_report_date('purchase_invoicen',$this->branch_id,$this->date);
	$this->load->view('report_popup/purchase_reportn',compact('pram','products'));
}
public function purchase_reportn_popup(){
	$pram = ['title' => 'Purchase Report'];
	 $id = $this->uri->segment(2);
	$invoice  = view_all_by_id($id,'purchase_invoicen');
	$query = get_all_by_match_one($id,'product_purchasen','trigger_id');
	$products = $query->result();
	 $this->load->view('report_popup/purchase_reportn_single',compact('pram','products','invoice'));
}
public function purchase_reportn_search_date(){
	$pram = ['title' => 'Purchase Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$products  = view_all_with_branch_report_date_search('purchase_invoicen',$this->branch_id,$from,$to);
	$this->load->view('report/purchase_reportn',compact('pram','products'));
}
public function purchase_reportn_print_date(){
	$pram = ['title' => 'Purchase Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$products  = view_all_with_branch_report_date_search('purchase_invoicen',$this->branch_id,$from,$to);
	$this->load->view('report_popup/purchase_reportn',compact('pram','products'));
}

public function expense_report_search_head(){
	$pram = ['title' => 'Account Report'];
    $head_id = $this->input->post('head_id');
    $this->db->where("head_id",$head_id);
    $q = $this->db->get('accounts');
	$accounts  = $q->result();
	$this->load->view('report/account_report',compact('pram','accounts'));
}
public function expense_report_print_head(){
	$pram = ['title' => 'Account Report'];
	$head_id = $this->uri->segment(3);
    $this->db->where("head_id",$head_id);
    $q = $this->db->get('accounts');
	$accounts  = $q->result();
	$this->load->view('report_popup/account_report',compact('pram','accounts'));
}
public function purchase_report_search_inv(){
	$pram = ['title' => 'Purchase Report'];
	$inv = $this->input->post('inv');
	$q = $this->db->where('invoice_number',$inv);
	$q = $this->db->get('purchase_invoice');
	$products  = $q->result();
	$this->load->view('report/purchase_report',compact('pram','products'));
}
public function purchase_report_print_date(){
	$pram = ['title' => 'Purchase Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$products  = view_all_with_branch_report_date_search('purchase_invoice',$this->branch_id,$from,$to);
	$this->load->view('report_popup/purchase_report',compact('pram','products'));
}
public function purchase_return_report(){
	$pram = ['title' => 'Purchase Return Report'];
	if(count($this->input->post()) > 0) :
		$date = $this->input->post('date');
		$supplier_id = $this->input->post('supplier_id');
		$this->db->where('branch_id',$this->branch_id);
		$this->db->where('date',$date);
		$this->db->where('supplier_id',$supplier_id);
		$products  = $this->db->get('purchase_return_invoice')->result();
	else:
	$products  = view_all_with_branch_report_date('purchase_return_invoice',$this->branch_id,$this->date);
	endif;
	$this->load->view('report/purchase_return_report',compact('pram','products'));
}
public function purchase_return_report_print(){
	$pram = ['title' => 'Purchase Return Report'];
	$products  = view_all_with_branch_report_date('purchase_return_invoice',$this->branch_id,$this->date);
	$this->load->view('report_popup/purchase_return_report',compact('pram','products'));
}
public function purchase_return_report_popup(){
	$pram = ['title' => 'Purchase Return Report'];
	 $id = $this->uri->segment(2);
	$invoice  = view_all_by_id($id,'purchase_return_invoice');
	$query = get_all_by_match_one($id,'product_return','trigger_id');
	$products = $query->result();
	 $this->load->view('report_popup/purchase_return_report_single',compact('pram','products','invoice'));
}
public function purchase_return_report_search_date(){
	$pram = ['title' => 'Purchase Return Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$products  = view_all_with_branch_report_date_search('purchase_return_invoice',$this->branch_id,$from,$to);
	$this->load->view('report/purchase_return_report',compact('pram','products'));
}
public function purchase_return_report_print_date(){
	$pram = ['title' => 'Purchase Return Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$products  = view_all_with_branch_report_date_search('purchase_return_invoice',$this->branch_id,$from,$to);
	$this->load->view('report_popup/purchase_return_report',compact('pram','products'));
}
public function sale_report(){
	$pram = ['title' => 'Sale Report'];
	$products  = view_all_with_branch_report_date('product_sale_invoice',$this->branch_id,$this->date);
	$this->load->view('report/sale_report',compact('pram','products'));
}
public function sale_report_print(){
	$pram = ['title' => 'Sale Report'];
	$products  = view_all_with_branch_report_date('product_sale_invoice',$this->branch_id,$this->date);
	$this->load->view('report_popup/sale_report',compact('pram','products'));
}
public function sale_report_popup(){
	$pram = ['title' => 'Sale Report'];
	 $id = $this->uri->segment(2);
	$invoice  = view_all_by_id($id,'product_sale_invoice');
	$query = get_all_by_match_one($id,'product_sale','trigger_id');
	$products = $query->result();
	 $this->load->view('report_popup/sale_report_single',compact('pram','products','invoice'));
}
public function complain_report_popup_m(){
	$pram = ['title' => 'Sale Report'];
	 $id = $this->uri->segment(2);
	$invoice  = view_all_by_id($id,'complain');
	$query = get_all_by_match_one($id,'complain_items','trigger_id');
	$products = $query->result();
	 $this->load->view('report_popup/complain_report_single',compact('pram','products','invoice'));
}
public function complain_report_popup_view(){
	$pram = ['title' => 'Sale Report'];
	 $id = $this->uri->segment(2);
	$category  = view_all_by_id($id,'complain');
	$this->load->view('report_popup/complain_report_view',compact('pram','category'));
}
public function sale_report_search_date(){
	$pram = ['title' => 'Sale Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
    $type = $this->input->post('type');
    $this->db->where('branch_id',$this->branch_id);
    $this->db->where('date >=',$from);
    $this->db->where('date <=',$to);
    $this->db->where('type',$type);
    $products  = $this->db->get('product_sale_invoice')->result();
	$this->load->view('report/sale_report',compact('pram','products'));
}
public function sale_report_search_date_user(){
 
	$pram = ['title' => 'Sale Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
    $user_id = $this->input->post('user_id');
    $this->db->where('branch_id',$this->branch_id);
    $this->db->where('date >=',$from);
    $this->db->where('date <=',$to);
    $this->db->where('user_id',$user_id);
    $products  = $this->db->get('product_sale_invoice')->result();
	$this->load->view('report/sale_report',compact('pram','products'));
}
public function sale_report_search_inv(){
	$pram = ['title' => 'Sale Report'];
	$inv = $this->input->post('inv');
	$q = $this->db->where('id',$inv);
	$q = $this->db->get('product_sale_invoice');
	$products  = $q->result();
	$this->load->view('report/sale_report',compact('pram','products'));
}
public function sale_report_print_date(){
	$pram = ['title' => 'Sale Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$products  = view_all_with_branch_report_date_search('product_sale_invoice',$this->branch_id,$from,$to);
	$this->load->view('report_popup/sale_report',compact('pram','products'));
}
public function sale_return_report(){
	$pram = ['title' => 'Sale Return Report'];
	if(count($this->input->post()) > 0) :
		$date = $this->input->post('date');
		$supplier_id = $this->input->post('supplier_id');
		$this->db->where('branch_id',$this->branch_id);
		$this->db->where('date',$date);
		$this->db->where('supplier_id',$supplier_id);
		$products  = $this->db->get('product_sale_return_invoice')->result();
	else:
	$products  = view_all_with_branch_report_date('product_sale_return_invoice',$this->branch_id,$this->date);
	endif;
	$this->load->view('report/sale_return_report',compact('pram','products'));
}
public function sale_return_report_print(){
	$pram = ['title' => 'Sale Return Report'];
	$products  = view_all_with_branch_report_date('product_sale_return_invoice',$this->branch_id,$this->date);
	$this->load->view('report_popup/sale_return_report',compact('pram','products'));
}
public function sale_return_report_popup(){
	$pram = ['title' => 'Sale Report'];
	 $id = $this->uri->segment(2);
	$invoice  = view_all_by_id($id,'product_sale_return_invoice');
	$query = get_all_by_match_one($id,'product_sale_return','trigger_id');
	$products = $query->result();
	 $this->load->view('report_popup/sale_return_report_single',compact('pram','products','invoice'));
}
public function sale_return_report_search_date(){
	$pram = ['title' => 'Sale Return Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$products  = view_all_with_branch_report_date_search('product_sale_return_invoice',$this->branch_id,$from,$to);
	$this->load->view('report/sale_return_report',compact('pram','products'));
}
public function sale_return_report_print_date(){
	$pram = ['title' => 'Sale Return Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$products  = view_all_with_branch_report_date_search('product_sale_return_invoice',$this->branch_id,$from,$to);
	$this->load->view('report_popup/sale_return_report',compact('pram','products'));
}
public function stock_report(){
	$pram = ['title' => 'Stock Report'];
	$categories = view_all_with_branch('categories',$this->branch_id);
	$products = view_all_with_branch('products',$this->branch_id);
	$this->load->view('report/stock_report',compact('pram','products','categories'));
}
public function stock_report_print(){
	$pram = ['title' => 'Stock Report'];
	$categories = view_all_with_branch('categories',$this->branch_id);
	$products = view_all_with_branch('products',$this->branch_id);
	$this->load->view('report_popup/stock_report',compact('pram','products','categories'));
}
public function stock_report_brand(){
	$pram = ['title' => 'Stock Report'];
	$category_id = $this->input->post('category_id');
	$product = get_all_by_match_one($category_id,'products','category_id');
	$products = $product->result();
	$this->load->view('report/stock_report',compact('pram','products'));
}
public function stock_report_print_brand(){
	$pram = ['title' => 'Stock Report'];
	$category_id = $this->uri->segment(3);
	$product = get_all_by_match_one($category_id,'products','category_id');
	$products = $product->result();
	$this->load->view('report_popup/stock_report',compact('pram','products'));
}
public function stock_report_category(){
	$pram = ['title' => 'Stock Report'];
	$brand_id = $this->input->post('brand_id');
	$product = get_all_by_match_one($brand_id,'products','brand_id');
	$products = $product->result();
	$this->load->view('report/stock_report',compact('pram','products'));
}
public function stock_report_print_category(){
	$pram = ['title' => 'Stock Report'];
	$brand_id = $this->uri->segment(3);
	$product = get_all_by_match_one($brand_id,'products','brand_id');
	$products = $product->result();
	$this->load->view('report_popup/stock_report',compact('pram','products'));
}
public function low_stock_report(){
	$pram = ['title' => 'Low Stock Report'];
	$this->db->where('branch_id',$this->branch_id);
	
	$product = $this->db->get('products');
	$products = $product->result();
	$this->load->view('report/low_stock_report',compact('pram','products'));
}
public function low_stock_report_print(){
	$pram = ['title' => 'Low Stock Report'];
	$this->db->where('branch_id',$this->branch_id);

	$product = $this->db->get('products');
	$products = $product->result();
	$this->load->view('report_popup/low_stock_report',compact('pram','products'));
}
public function damage_stock_report(){
	$pram = ['title' => 'damage Stock Report'];
	$this->db->where('branch_id',$this->branch_id);
	
	$product = $this->db->get('products');
	$products = $product->result();
	$this->load->view('report/damage_stock_report',compact('pram','products'));
}
public function damage_stock_report_print(){
	$pram = ['title' => 'damage Stock Report'];
	$this->db->where('branch_id',$this->branch_id);
	$this->db->where('damage !=',0);
	$product = $this->db->get('products');
	$products = $product->result();
	$this->load->view('report_popup/damage_stock_report',compact('pram','products'));
}
public function collection_sheet(){
	$pram = ['title' => 'Collection Report'];
	$this->db->where('branch_id',$this->branch_id);
	$this->db->where('balance > ',0);
	$customers = $this->db->get('customers')->result();
	$this->load->view('report/collection_sheet',compact('pram','customers'));
}
public function complain_print(){
	$pram = ['title' => 'Collection Report'];
	$this->db->where('branch_id',$this->branch_id);
	$complains = $this->db->get('complain')->result();
	$this->load->view('report_popup/complain',compact('pram','complains'));
}
public function collection_sheet_print(){
	$pram = ['title' => 'Collection Report'];
	$this->db->where('branch_id',$this->branch_id);
	$this->db->where('balance > ',0);
	$customers = $this->db->get('customers')->result();
	$this->load->view('report_popup/collection_sheet',compact('pram','customers'));
}
public function collection_report(){
	$pram = ['title' => 'Collection Report'];
	$collections  = view_all_with_branch_report_date('collections',$this->branch_id,$this->date);
	$this->load->view('report/collection_report',compact('pram','collections'));
}
public function collection_report_print(){
	$pram = ['title' => 'Collection Report'];
	$collections  = view_all_with_branch_report_date('collections',$this->branch_id,$this->date);
	$this->load->view('report_popup/collection_report',compact('pram','collections'));
}
public function collection_report_popup(){
	$pram = ['title' => 'Collection Report'];
	$id = $this->uri->segment(2);
	$collection  = view_all_by_id($id,'collections');
	 $this->load->view('report_popup/collection_report_single',compact('pram','collection'));
}
public function collection_report_search_date(){

	$pram = ['title' => 'Collection Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$collections  = view_all_with_branch_report_date_search('collections',$this->branch_id,$from,$to);
	$this->load->view('report/collection_report',compact('pram','collections'));
}
public function collection_report_type(){
	$pram = ['title' => 'Receivableble Ledger Report'];
	//$customers  = view_all_with_branch('customers',$this->branch_id);
	$type = $this->input->post('type');
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$this->db->where('branch_id',$this->branch_id);
	$this->db->where('date >=',$from);
	$this->db->where('date <=',$to);
	$this->db->where('type',$type);
	$collections = $this->db->get('collections')->result();
	$this->load->view('report/collection_report',compact('pram','collections'));
}
public function collection_report_print_date(){
	$pram = ['title' => 'Collection Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$collections  = view_all_with_branch_report_date_search('collections',$this->branch_id,$from,$to);
	$this->load->view('report_popup/collection_report',compact('pram','collections'));
}
public function payment_report(){
	$pram = ['title' => 'Payment Report'];
	$payments  = view_all_with_branch_report_date('payments',$this->branch_id,$this->date);
	$this->load->view('report/payment_report',compact('pram','payments'));
}
public function payment_report_print(){
	$pram = ['title' => 'Payment Report'];
	$payments  = view_all_with_branch_report_date('payments',$this->branch_id,$this->date);
	$this->load->view('report_popup/payment_report',compact('pram','payments'));
}
public function payment_report_popup(){
	$pram = ['title' => 'Payment Report'];
	$id = $this->uri->segment(2);
	$payment  = view_all_by_id($id,'payments');
	 $this->load->view('report_popup/payment_report_single',compact('pram','payment'));
}
public function payment_report_search_date(){

	$pram = ['title' => 'Payment Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$payments  = view_all_with_branch_report_date_search('payments',$this->branch_id,$from,$to);
	$this->load->view('report/payment_report',compact('pram','payments'));
}
public function payment_report_supplier(){

	$pram = ['title' => 'Payment Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
    $supplier_id = $this->input->post('supplier_id');
    $this->db->where('branch_id',$this->branch_id);
	$this->db->where('date >=',$from);
	$this->db->where('date <=',$to);
	$this->db->where('supplier_id',$supplier_id);
	$payments  = $this->db->get('payments')->result();
	$this->load->view('report/payment_report',compact('pram','payments'));
}
public function payment_report_print_date(){
	$pram = ['title' => 'Payment Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$payments  = view_all_with_branch_report_date_search('payments',$this->branch_id,$from,$to);
	$this->load->view('report_popup/payment_report',compact('pram','payments'));
}
public function payble_report(){
	$pram = ['title' => 'Payble Ledger Report'];
	$suppliers  = view_all_with_branch('suppliers',$this->branch_id);
	$this->load->view('report/payble_ledger_report',compact('pram','suppliers'));
}
public function payble_report_print(){
	$pram = ['title' => 'Payble Ledger Report'];
	$suppliers  = view_all_with_branch('suppliers',$this->branch_id);
	$this->load->view('report_popup/payble_ledger_report',compact('pram','suppliers'));
}


public function payment_reportn(){
	$pram = ['title' => 'Payment Report'];
	$payments  = view_all_with_branch_report_date('paymentsn',$this->branch_id,$this->date);
	$this->load->view('report/payment_reportn',compact('pram','payments'));
}
public function payment_reportn_print(){
	$pram = ['title' => 'Payment Report'];
	$payments  = view_all_with_branch_report_date('paymentsn',$this->branch_id,$this->date);
	$this->load->view('report_popup/payment_reportn',compact('pram','payments'));
}
public function payment_reportn_popup(){
	$pram = ['title' => 'Payment Report'];
	$id = $this->uri->segment(2);
	$payment  = view_all_by_id($id,'paymentsn');
	 $this->load->view('report_popup/payment_reportn_single',compact('pram','payment'));
}
public function payment_reportn_search_date(){

	$pram = ['title' => 'Payment Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$payments  = view_all_with_branch_report_date_search('paymentsn',$this->branch_id,$from,$to);
	$this->load->view('report/payment_reportn',compact('pram','payments'));
}
public function payment_reportn_print_date(){
	$pram = ['title' => 'Payment Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$payments  = view_all_with_branch_report_date_search('paymentsn',$this->branch_id,$from,$to);
	$this->load->view('report_popup/payment_reportn',compact('pram','payments'));
}
public function payble_reportn(){
	$pram = ['title' => 'Payble Ledger Report'];
	$suppliers  = view_all_with_branch('suppliersn',$this->branch_id);
	$this->load->view('report/payble_ledger_reportn',compact('pram','suppliers'));
}
public function payble_reportn_print(){
	$pram = ['title' => 'Payble Ledger Report'];
	$suppliers  = view_all_with_branch('suppliersn',$this->branch_id);
	$this->load->view('report_popup/payble_ledger_reportn',compact('pram','suppliers'));
}


public function receivable_report(){
	$pram = ['title' => 'Receivableble Ledger Report'];
	$customers  = view_all_with_branch('customers',$this->branch_id);
	$this->load->view('report/receivable_ledger_report',compact('pram','customers'));
}
public function receivable_report_type(){
	$pram = ['title' => 'Receivableble Ledger Report'];
	//$customers  = view_all_with_branch('customers',$this->branch_id);
	$type = $this->input->post('type');
	$this->db->where('branch_id',$this->branch_id);
	$this->db->where('type',$type);
	$customers = $this->db->get('customers')->result();
	$this->load->view('report/receivable_ledger_report',compact('pram','customers'));
}

public function receivable_report_print(){
	$pram = ['title' => 'Receivableble Ledger Report'];
	$customers  = view_all_with_branch('customers',$this->branch_id);
	$this->load->view('report_popup/receivable_ledger_report',compact('pram','customers'));
}
public function bank_report(){
	$pram = ['title' => 'bank Ledger Report'];
	$customers  = view_all_with_branch('banks',$this->branch_id);
	$this->load->view('report/bank_ledger_report',compact('pram','customers'));
}
public function bank_report_print(){
	$pram = ['title' => 'bank Ledger Report'];
	$customers  = view_all_with_branch('banks',$this->branch_id);
	$this->load->view('report_popup/bank_ledger_report',compact('pram','customers'));
}
public function twenty5_report(){
	$pram = ['title' => 'Receivableble Ledger Report'];
	$customers  = view_all_with_branch('customers',$this->branch_id);
	$this->load->view('report/twenty5_report',compact('pram','customers'));
}
public function twenty5_report_print(){
	$pram = ['title' => 'Receivableble Ledger Report'];
	$customers  = view_all_with_branch('customers',$this->branch_id);
	$this->load->view('report_popup/twenty5_report',compact('pram','customers'));
}
public function lv2_report(){
	$pram = ['title' => 'Receivableble Ledger Report'];
	$customers  = view_all_with_branch('customers',$this->branch_id);
	$this->load->view('report/lv2_report',compact('pram','customers'));
}
public function lv2_report_print(){
	$pram = ['title' => 'Receivableble Ledger Report'];
	$customers  = view_all_with_branch('customers',$this->branch_id);
	$this->load->view('report_popup/lv2_report',compact('pram','customers'));
}
public function expense_report(){
	$pram = ['title' => 'Account Report'];
	$accounts  = view_all_with_branch_report_date('accounts',$this->branch_id,$this->date);
	$this->load->view('report/account_report',compact('pram','accounts'));
}
public function expense_report_print(){
	$pram = ['title' => 'Account Report'];
	$accounts  = view_all_with_branch_report_date('accounts',$this->branch_id,$this->date);
	$this->load->view('report_popup/account_report',compact('pram','accounts'));
}
public function expense_report_popup(){
	$pram = ['title' => 'Account Report'];
	$id = $this->uri->segment(2);
	$account  = view_all_by_id($id,'accounts');
	$this->load->view('report_popup/account_report_single',compact('pram','account'));
}
public function expense_report_search_date(){
	$pram = ['title' => 'Account Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$accounts  = view_all_with_branch_report_date_search('accounts',$this->branch_id,$from,$to);
	$this->load->view('report/account_report',compact('pram','accounts'));
}
public function expense_report_print_date(){
	$pram = ['title' => 'Account Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$accounts  = view_all_with_branch_report_date_search('accounts',$this->branch_id,$from,$to);
	$this->load->view('report_popup/account_report',compact('pram','accounts'));
}
public function sale_item_report(){
	$pram = ['title' => 'Sale Report'];
	$products  = view_all_with_branch_report_date('product_sale',$this->branch_id,$this->date);
	$this->load->view('report/sale_item_report',compact('pram','products'));
}
public function sale_item_report_print(){
	$pram = ['title' => 'Sale Report'];
	$products  = view_all_with_branch_report_date('product_sale',$this->branch_id,$this->date);
	$this->load->view('report_popup/sale_item_report',compact('pram','products'));
}

public function sale_item_category(){
	$pram = ['title' => 'Sale Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
    $category_id = $this->input->post('category_id');
	$this->db->where('date >=',$from);
	$this->db->where('date <=',$to);
	$this->db->where('category_id',$category_id);
	$this->db->where('branch_id',$this->branch_id);
	$products = $this->db->get('product_sale')->result();
	$this->load->view('report/sale_item_report',compact('pram','products'));
}
public function sale_item_report_search_date(){
	$pram = ['title' => 'Sale Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$products  = view_all_with_branch_report_date_search('product_sale',$this->branch_id,$from,$to);
	$this->load->view('report/sale_item_report',compact('pram','products'));
}
public function sale_item_report_print_date(){
	$pram = ['title' => 'Sale Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$products  = view_all_with_branch_report_date_search('product_sale',$this->branch_id,$from,$to);
	$this->load->view('report_popup/sale_item_report',compact('pram','products'));
}
public function purchase_item_report(){
	$pram = ['title' => 'Purchase Report'];
	$products  = view_all_with_branch_report_date('product_purchase',$this->branch_id,$this->date);
	$this->load->view('report/purchase_item_report',compact('pram','products'));
}
public function purchase_item_report_print(){
	$pram = ['title' => 'Purchase Report'];
	$products  = view_all_with_branch_report_date('product_purchase',$this->branch_id,$this->date);
	$this->load->view('report_popup/purchase_item_report',compact('pram','products'));
}

public function purchase_item_report_search_date(){
	$pram = ['title' => 'Purchase Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$products  = view_all_with_branch_report_date_search('product_purchase',$this->branch_id,$from,$to);
	$this->load->view('report/purchase_item_report',compact('pram','products'));
}
public function purchase_item_report_print_date(){
	$pram = ['title' => 'Purchase Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$products  = view_all_with_branch_report_date_search('product_purchase',$this->branch_id,$from,$to);
	$this->load->view('report_popup/purchase_item_report',compact('pram','products'));
}
public function purchase_item_report_search_date_sup(){
	$pram = ['title' => 'Purchase Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
    $supplier_id = $this->input->post('supplier_id');
    $this->db->where('date >=',$from);
    $this->db->where('date <=',$to);
    $this->db->where('supplier_id',$supplier_id);
   	$products  = $this->db->get('product_purchase')->result();
	$this->load->view('report/purchase_item_report',compact('pram','products'));
}
public function purchase_item_report_print_date_sup(){
	$pram = ['title' => 'Purchase Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
    $supplier_id = $this->uri->segment(5);
	$this->db->where('date >=',$from);
    $this->db->where('date <=',$to);
    $this->db->where('supplier_id',$supplier_id);
   	$products  = $this->db->get('product_purchase')->result();
	$this->load->view('report_popup/purchase_item_report',compact('pram','products'));
}
public function income(){
	$pram = ['title' => 'Income Report'];
	$amount = 0;
	$cost = 0;
	$vat = 0;
	$lab = 0;
	$discount = 0;
	$r_amount = 0;
	$r_cost = 0;
	$r_discount = 0;
	$expense = 0;
	$ex_amount = 0;
	$cd= 0;
	$sale  = view_all_with_branch_report_date('product_sale_invoice',$this->branch_id,$this->date);
	foreach ($sale as $value) {
		$amount += $value->total_amount;
		$cost += $value->cost_amount;
		$vat += $value->vat;
		$lab += $value->lab_trans;
		$discount += $value->mdiscount + $value->discount;
	}
	
	$sale_return  = view_all_with_branch_report_date('product_sale_return_invoice',$this->branch_id,$this->date);
	foreach ($sale_return as $value) {
		$r_amount += $value->total_amount;
		$r_cost += $value->cost_amount;
		$r_discount += $value->discount;
	}
	$expenses  = view_all_with_branch_report_date('accounts',$this->branch_id,$this->date);
	foreach ($expenses as $value) {
		$ex_amount += $value->amount;
	}
	$cd = 0;
	$collections  = view_all_with_branch_report_date('collections',$this->branch_id,$this->date);
	foreach ($collections as $value) {
		$cd += $value->discount;
	}
	
	$ei = 0;
	$extras  = view_all_with_branch_report_date('commisons',$this->branch_id,$this->date);
	foreach ($extras as $value) {
		$ei += $value->amount;
	}
	$sp = 0;
	$studentps  = view_all_with_branch_report_date('studentps',$this->branch_id,$this->date);
	foreach ($studentps as $value) {
		$sp += $value->amount;
	}
	$comp = 0;
	$compc = 0;
	$eng_charge = 0;
	$complains  = view_all_with_branch_report_col('complain',$this->branch_id,'delivery_date',$this->date);
	foreach ($complains as $value) {
		$comp +=  $value->charge - $value->cost_amount - $value->eng_charge - $value->discount;
		$compc += $value->cost_amount;
		$eng_charge += $value->eng_charge;

	}
	$compp = 0;

	$services  = view_all_with_branch_report_col('services',$this->branch_id,'delivery_date',$this->date);
	foreach ($services as $value) {
		$compp +=  $value->charge - $value->discount;

	}
	$salea = $amount + $lab + $vat;
	$return = $r_amount - $r_discount;
	$net_sales = $salea - $discount - $return;
	$total_discount = $discount;
	$total_cost = $cost - $r_cost;
	$gross = $net_sales - $total_cost;
	$net_profit = $gross + $comp + $compp + $ei + $sp - $ex_amount -  $cd;
	$incomes = [
				'sale' => $salea,
				'discount'	 => $total_discount,
				'return' => $return,
				'net_sale' => $net_sales,
				'cost_amount' => $total_cost,
				'gross_profit' => $gross,
				'expense'	=> $ex_amount,
				'cd'	=> $cd,
				'ei'	=> $ei,
				'comp'	=> $comp+$compp,
				'comps'	=> $compc+$eng_charge,
				'sp'	=> $sp,
				'net_profit' => $net_profit
			   ];
	$this->load->view('report/income_report',compact('pram','incomes'));
}
public function income_print(){
	$pram = ['title' => 'Income Report'];
	$amount = 0;
	$cost = 0;
	$vat = 0;
	$lab = 0;
	$discount = 0;
	$r_amount = 0;
	$r_cost = 0;
	$r_discount = 0;
	$expense = 0;
	$ex_amount = 0;
	$sale  = view_all_with_branch_report_date('product_sale_invoice',$this->branch_id,$this->date);
	foreach ($sale as $value) {
		$amount += $value->total_amount;
		$cost += $value->cost_amount;
		$vat += $value->vat;
		$lab += $value->lab_trans;
		$discount += $value->mdiscount + $value->discount;
	}
	
	$sale_return  = view_all_with_branch_report_date('product_sale_return_invoice',$this->branch_id,$this->date);
	foreach ($sale_return as $value) {
		$r_amount += $value->total_amount;
		$r_cost += $value->cost_amount;
		$r_discount += $value->discount;
	}
	$expenses  = view_all_with_branch_report_date('accounts',$this->branch_id,$this->date);
	foreach ($expenses as $value) {
		$ex_amount += $value->amount;
	}
	$cd = 0;
	$collections  = view_all_with_branch_report_date('collections',$this->branch_id,$this->date);
	foreach ($collections as $value) {
		$cd += $value->discount;
	}
	
	$ei = 0;
	$extras  = view_all_with_branch_report_date('commisons',$this->branch_id,$this->date);
	foreach ($extras as $value) {
		$ei += $value->amount;
	}
	$sp = 0;
	$studentps  = view_all_with_branch_report_date('studentps',$this->branch_id,$this->date);
	foreach ($studentps as $value) {
		$sp += $value->amount;
	}
	$comp = 0;
	$compc = 0;
	$eng_charge = 0;
	$complains  = view_all_with_branch_report_col('complain',$this->branch_id,'delivery_date',$this->date);
	foreach ($complains as $value) {
		$comp +=  $value->charge - $value->cost_amount - $value->eng_charge - $value->discount;
		$compc += $value->cost_amount;
		$eng_charge += $value->eng_charge;

	}
	$compp = 0;

	$services  = view_all_with_branch_report_col('services',$this->branch_id,'delivery_date',$this->date);
	foreach ($services as $value) {
		$compp +=  $value->charge - $value->discount;

	}
	$salea = $amount + $lab + $vat;
	$return = $r_amount - $r_discount;
	$net_sales = $salea - $discount - $return;
	$total_discount = $discount;
	$total_cost = $cost - $r_cost;
	$gross = $net_sales - $total_cost;
	$net_profit = $gross + $comp + $compp + $ei + $sp - $ex_amount -  $cd;
	$incomes = [
				'sale' => $salea,
				'discount'	 => $total_discount,
				'return' => $return,
				'net_sale' => $net_sales,
				'cost_amount' => $total_cost,
				'gross_profit' => $gross,
				'expense'	=> $ex_amount,
				'cd'	=> $cd,
				'ei'	=> $ei,
				'comp'	=> $comp+$compp,
				'comps'	=> $compc+$eng_charge,
				'sp'	=> $sp,
				'net_profit' => $net_profit
			   ];
	$this->load->view('report_popup/income_report',compact('pram','incomes'));
}

public function income_search_date(){
	$pram = ['title' => 'Income Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$amount = 0;
	$cost = 0;
	$discount = 0;
	$r_amount = 0;
	$r_cost = 0;
	$vat = 0;
	$lab = 0;
	$r_discount = 0;
	$expense = 0;
	$ex_amount = 0;
	$sale  = view_all_with_branch_report_date_search('product_sale_invoice',$this->branch_id,$from,$to);

	foreach ($sale as $value) {
		$amount += $value->total_amount;
		$cost += $value->cost_amount;
		$discount += $value->mdiscount + $value->discount;
		$vat += $value->vat;
		$lab += $value->lab_trans;
	}

	$sale_return  = view_all_with_branch_report_date_search('product_sale_return_invoice',$this->branch_id,$from,$to);
	foreach ($sale_return as $value) {
		$r_amount += $value->total_amount;
		$r_cost += $value->cost_amount;
		$r_discount += $value->discount;
	}
	$expenses  = view_all_with_branch_report_date_search('accounts',$this->branch_id,$from,$to);
	foreach ($expenses as $value) {
		$ex_amount += $value->amount;
	}
	$cd = 0;
	$collections  = view_all_with_branch_report_date_search('collections',$this->branch_id,$from,$to);
	foreach ($collections as $value) {
		$cd += $value->discount;
	}
	
	$ei = 0;
	$extras  = view_all_with_branch_report_date_search('commisons',$this->branch_id,$from,$to);
	foreach ($extras as $value) {
		$ei += $value->amount;
	}
	$sp = 0;
	$studentps  = view_all_with_branch_report_date_search('studentps',$this->branch_id,$from,$to);
	foreach ($studentps as $value) {
		$sp += $value->amount;
	}
	$comp = 0;
	$compc = 0;
	$eng_charge = 0;
	$complains  = view_all_with_branch_report_date_search_col('complain',$this->branch_id,'delivery_date >=','delivery_date <=',$from,$to);
	foreach ($complains as $value) {
		$comp +=  $value->charge - $value->cost_amount - $value->eng_charge - $value->discount - $value->discount;
		$compc += $value->cost_amount;
		$eng_charge += $value->eng_charge;

	}
	
	$compp = 0;

	$services  = view_all_with_branch_report_date_search_col('services',$this->branch_id,'delivery_date >=','delivery_date <=',$from,$to);
	foreach ($services as $value) {
		$compp +=  $value->charge - $value->discount - $value->discount;

	}
	$salea = $amount + $lab + $vat;
	$return = $r_amount - $r_discount;
	$net_sales = $salea - $discount - $return;
	$total_discount = $discount;
	$total_cost = $cost - $r_cost;
	$gross = $net_sales - $total_cost;
	$net_profit = $gross + $comp + $compp + $ei + $sp - $ex_amount -  $cd;
	$incomes = [
				'sale' => $salea,
				'discount'	 => $total_discount,
				'return' => $return,
				'net_sale' => $net_sales,
				'cost_amount' => $total_cost,
				'gross_profit' => $gross,
				'expense'	=> $ex_amount,
				'cd'	=> $cd,
				'ei'	=> $ei,
				'comp'	=> $comp+$compp,
				'comps'	=> $compc+$eng_charge,
				'sp'	=> $sp,
				'net_profit' => $net_profit
			   ];
	$this->load->view('report/income_report',compact('pram','incomes'));
}
public function income_print_date(){
	$pram = ['title' => 'Income Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$amount = 0;
	$cost = 0;
	$discount = 0;
	$r_amount = 0;
	$r_cost = 0;
	$r_discount = 0;
	$expense = 0;
	$ex_amount = 0;
	$vat = 0;
	$lab = 0;
	$sale  = view_all_with_branch_report_date_search('product_sale_invoice',$this->branch_id,$from,$to);

	foreach ($sale as $value) {
		$amount += $value->total_amount;
		$cost += $value->cost_amount;
		$discount += $value->mdiscount + $value->discount;
		$vat += $value->vat;
		$lab += $value->lab_trans;
	}

	$sale_return  = view_all_with_branch_report_date_search('product_sale_return_invoice',$this->branch_id,$from,$to);
	foreach ($sale_return as $value) {
		$r_amount += $value->total_amount;
		$r_cost += $value->cost_amount;
		$r_discount += $value->discount;
	}
	$expenses  = view_all_with_branch_report_date_search('accounts',$this->branch_id,$from,$to);
	foreach ($expenses as $value) {
		$ex_amount += $value->amount;
	}
	$cd = 0;
	$collections  = view_all_with_branch_report_date_search('collections',$this->branch_id,$from,$to);
	foreach ($collections as $value) {
		$cd += $value->discount;
	}
	
	$ei = 0;
	$extras  = view_all_with_branch_report_date_search('commisons',$this->branch_id,$from,$to);
	foreach ($extras as $value) {
		$ei += $value->amount;
	}
	$sp = 0;
	$studentps  = view_all_with_branch_report_date_search('studentps',$this->branch_id,$from,$to);
	foreach ($studentps as $value) {
		$sp += $value->amount;
	}
	$comp = 0;
	$compc = 0;
	$eng_charge = 0;
	$complains  = view_all_with_branch_report_date_search_col('complain',$this->branch_id,'delivery_date >=','delivery_date <=',$from,$to);
	foreach ($complains as $value) {
		$comp +=  $value->charge - $value->cost_amount - $value->eng_charge - $value->discount;
		$compc += $value->cost_amount;
		$eng_charge += $value->eng_charge;

	}
	$compp = 0;

	$services  = view_all_with_branch_report_date_search_col('services',$this->branch_id,'delivery_date >=','delivery_date <=',$from,$to);
	foreach ($services as $value) {
		$compp +=  $value->charge - $value->discount;

	}
	$salea = $amount + $lab + $vat;
	$return = $r_amount - $r_discount;
	$net_sales = $salea - $discount - $return;
	$total_discount = $discount;
	$total_cost = $cost - $r_cost;
	$gross = $net_sales - $total_cost;
	$net_profit = $gross + $comp + $compp + $ei + $sp - $ex_amount -  $cd;
	$incomes = [
				'sale' => $salea,
				'discount'	 => $total_discount,
				'return' => $return,
				'net_sale' => $net_sales,
				'cost_amount' => $total_cost,
				'gross_profit' => $gross,
				'expense'	=> $ex_amount,
				'cd'	=> $cd,
				'ei'	=> $ei,
				'comp'	=> $comp+$compp,
				'comps'	=> $compc+$eng_charge,
				'sp'	=> $sp,
				'net_profit' => $net_profit
			   ];
	$this->load->view('report_popup/income_report',compact('pram','incomes'));
}
public function hist_cus(){
	$previous_balance = 0;
	$pram = ['title' => 'Customer History'];
	if(count($this->input->post()) > 0) :
	if(empty($this->input->post('from'))):
	$customer_id = $this->input->post('customer_id');
	$sale  = get_all_by_match_one($customer_id,'product_sale_invoice','customer_id');
	$sales = $sale->result();
	$sale_return  = get_all_by_match_one($customer_id,'product_sale_return_invoice','customer_id');
	$sale_returns = $sale_return->result();
	$collection  = get_all_by_match_one($customer_id,'collections','customer_id');
	$collections = $collection->result();
	$ex  = get_all_by_match_one($customer_id,'complain','customer_id');
	$exs = $ex->result();
	$sers  = get_all_by_match_one($customer_id,'services','customer_id')->result();
	$this->load->view('report/customer_history',compact('pram','sales','sale_returns','collections','previous_balance','exs','sers'));
	else:
	$customer_id = $this->input->post('customer_id');
	$from = date("Y-m-d",strtotime($this->input->post('from')));
	$to =   date("Y-m-d",strtotime($this->input->post('to')));

	$prev_due = 0;
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get('product_sale_invoice');
    $res = $query->result();

    foreach ($res as $key => $value) {
    	
    		$prev_due += $value->due;
    }


    $this->db->select_sum('paid');
    $this->db->from('collections');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_p = $query->row()->paid;

    $this->db->select_sum('bank_amount');
    $this->db->from('collections');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_b = $query->row()->bank_amount;
    
    $this->db->select_sum('discount');
    $this->db->from('collections');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_discount = $query->row()->discount;

    $this->db->select_sum('check_amount');
    $this->db->from('collections');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('approved_st',1);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_c = $query->row()->check_amount;

    $pre_coll = $pre_coll_c + $pre_coll_p + $pre_coll_b + $pre_coll_discount;

    $this->db->select_sum('due');
    $this->db->from('product_sale_return_invoice');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_due_ret = $query->row()->due;

	$this->db->select_sum('due');
    $this->db->from('complain');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('delivery',1);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $expn = $query->row()->due;

    $this->db->select_sum('due');
    $this->db->from('services');
    $this->db->where('delivery',1);
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $expns = $query->row()->due;

    $previous_balance = $prev_due - $pre_due_ret - $pre_coll + $expn + $expns;

    if(empty($previous_balance))
    	$previous_balance = 0;
    //now
	$sale  = get_all_by_match_one_two_date($customer_id,'product_sale_invoice','customer_id',$from,$to);
	$sales = $sale->result();
	$sale_return  = get_all_by_match_one_two_date($customer_id,'product_sale_return_invoice','customer_id',$from,$to);
	$sale_returns = $sale_return->result();
	$collection  = get_all_by_match_one_two_date($customer_id,'collections','customer_id',$from,$to);
	$collections = $collection->result();
	$exs  = get_all_by_match_one_two_date($customer_id,'complain','customer_id',$from,$to)->result();
	$sers  = get_all_by_match_one_two_date($customer_id,'services','customer_id',$from,$to)->result();
	
	$this->load->view('report/customer_history',compact('pram','sales','sale_returns','collections','previous_balance','exs','sers'));
	endif;
	else :
		
	$this->load->view('report/customer_history',compact('pram'));
	endif;
	
}
public function customer_history_print_date(){
	$pram = ['title' => 'Customer History'];
	$previous_balance = 0;
	if($this->uri->segment(4) == 'null'):
	$customer_id = $this->uri->segment(3);
	$sale  = get_all_by_match_one($customer_id,'product_sale_invoice','customer_id');
	$sales = $sale->result();
	$sale_return  = get_all_by_match_one($customer_id,'product_sale_return_invoice','customer_id');
	$sale_returns = $sale_return->result();
	$collection  = get_all_by_match_one($customer_id,'collections','customer_id');
	$collections = $collection->result();
	$exs  = get_all_by_match_one($customer_id,'complain','customer_id')->result();
	$sers  = get_all_by_match_one($customer_id,'services','customer_id')->result();
	$this->load->view('report_popup/customer_history',compact('pram','sales','sale_returns','collections','previous_balance','exs','customer_id','sers'));
	else:
	$customer_id = $this->uri->segment(3);
	$from = date('Y-m-d',strtotime($this->uri->segment(4)));
	$to =   date('Y-m-d',strtotime($this->uri->segment(5)));

	$prev_due = 0;
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get('product_sale_invoice');
    $res = $query->result();

    foreach ($res as $key => $value) {
    	$prev_due += $value->due;
    }

    $this->db->select_sum('paid');
    $this->db->from('collections');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_p = $query->row()->paid;

    $this->db->select_sum('check_amount');
    $this->db->from('collections');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('approved_st',1);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_c = $query->row()->check_amount;

    $this->db->select_sum('bank_amount');
    $this->db->from('collections');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_b = $query->row()->bank_amount;

     $this->db->select_sum('discount');
    $this->db->from('collections');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_discount = $query->row()->discount;


    $pre_coll = $pre_coll_c + $pre_coll_p + $pre_coll_b + $pre_coll_discount;

    $this->db->select_sum('due');
    $this->db->from('product_sale_return_invoice');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_due_ret = $query->row()->due;

    $this->db->select_sum('due');
    $this->db->from('complain');
    $this->db->where('customer_id',$customer_id);
    $this->db->where('delivery',1);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $expn = $query->row()->due;

    $this->db->select_sum('due');
    $this->db->from('services');
    $this->db->where('delivery',1);
    $this->db->where('customer_id',$customer_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $expns = $query->row()->due;

    $previous_balance = $prev_due - $pre_due_ret - $pre_coll + $expn + $expns;
    
    if(empty($previous_balance))
    	$previous_balance = 0;
	$sale  = get_all_by_match_one_two_date($customer_id,'product_sale_invoice','customer_id',$from,$to);
	$sales = $sale->result();
	$sale_return  = get_all_by_match_one_two_date($customer_id,'product_sale_return_invoice','customer_id',$from,$to);
	$sale_returns = $sale_return->result();
	$collection  = get_all_by_match_one_two_date($customer_id,'collections','customer_id',$from,$to);
	$collections = $collection->result();
	$exs  = get_all_by_match_one_two_date($customer_id,'complain','customer_id',$from,$to)->result();
	$sers  = get_all_by_match_one_two_date($customer_id,'services','customer_id',$from,$to)->result();

	$this->load->view('report_popup/customer_history',compact('pram','sales','sale_returns','collections','previous_balance','exs','customer_id','sers'));
	endif;	
}
public function hist_sup(){
	$previous_balance = 0;
	$pram = ['title' => 'Supplier History'];
	if(count($this->input->post()) > 0) :
	if(empty($this->input->post('from'))):
	$supplier_id = $this->input->post('supplier_id');
	$sale  = get_all_by_match_one($supplier_id,'purchase_invoice','supplier_id');
	$sales = $sale->result();
	$sale_return  = get_all_by_match_one($supplier_id,'purchase_return_invoice','supplier_id');
	$sale_returns = $sale_return->result();
	$payment  = get_all_by_match_one($supplier_id,'payments','supplier_id');
	$collections = $payment->result();
	$ex  = get_all_by_match_one($supplier_id,'other_accounts','supplier_id');
	$exs = $ex->result();
	$comss  = get_all_by_match_one($supplier_id,'commisons','supplier_id');
	$coms = $comss->result();
	$supp_col  = get_all_by_match_one($supplier_id,'supplier_collection','supplier_id');
	$supps = $supp_col->result();
	$this->load->view('report/supplier_history',compact('pram','sales','sale_returns','collections','previous_balance','exs','supps','coms'));
	else:
	$supplier_id = $this->input->post('supplier_id');
	$from = date("Y-m-d",strtotime($this->input->post('from')));
	$to =   date("Y-m-d",strtotime($this->input->post('to')));

    $prev_due = 0;
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get('purchase_invoice');
    $res = $query->result();

    foreach ($res as $key => $value) {
    	if($value->approved_st == 1){
    		$prev_due += $value->total_amount - $value->cash_paid - $value->check_amount - $value->discount;
    	}else{
    		$prev_due += $value->total_amount - $value->cash_paid- $value->discount;
    	}
    }

    $this->db->select_sum('paid');
    $this->db->from('payments');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_p = $query->row()->paid;

    $this->db->select_sum('discount');
    $this->db->from('payments');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $discount = $query->row()->discount;

    $this->db->select_sum('check_amount');
    $this->db->from('payments');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('approved_st',1);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_c = $query->row()->check_amount;

    $pre_coll = $pre_coll_c + $pre_coll_p +  $discount;

    $this->db->select_sum('due');
    $this->db->from('purchase_return_invoice');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_due_ret = $query->row()->due;


    $this->db->select_sum('amount');
    $this->db->from('commisons');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $expn = $query->row()->amount;

    $this->db->select_sum('paid');
    $this->db->from('supplier_collection');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $supp_cols = $query->row()->paid;

    $previous_balance = $prev_due - $pre_due_ret - $pre_coll - $expn + $supp_cols;

    if(empty($previous_balance))
    	$previous_balance = 0;
    //now
	$sale  = get_all_by_match_one_two_date($supplier_id,'purchase_invoice','supplier_id',$from,$to);
	$sales = $sale->result();
	$sale_return  = get_all_by_match_one_two_date($supplier_id,'purchase_return_invoice','supplier_id',$from,$to);
	$sale_returns = $sale_return->result();
	$payment  = get_all_by_match_one_two_date($supplier_id,'payments','supplier_id',$from,$to);
	$collections = $payment->result();
	$ex  = get_all_by_match_one_two_date($supplier_id,'other_accounts','supplier_id',$from,$to);
	$exs = $ex->result();
	$supp_col  = get_all_by_match_one_two_date($supplier_id,'supplier_collection','supplier_id',$from,$to);
	$supps = $supp_col->result();
	$comss  = get_all_by_match_one($supplier_id,'commisons','supplier_id');
	$coms = $comss->result();
	$supp_col  = get_all_by_match_one_two_date($supplier_id,'supplier_collection','supplier_id',$from,$to);
	$this->load->view('report/supplier_history',compact('pram','sales','sale_returns','collections','previous_balance','exs','supps','coms'));
	endif;
	else :
		
	$this->load->view('report/supplier_history',compact('pram'));
	endif;
	
}
public function supplier_history_print_date(){
	$pram = ['title' => 'Supplier History'];
	$previous_balance = 0;
	if($this->uri->segment(4) == 'null'):
	$supplier_id = $this->uri->segment(3);
	$sale  = get_all_by_match_one($supplier_id,'purchase_invoice','supplier_id');
	$sales = $sale->result();
	$sale_return  = get_all_by_match_one($supplier_id,'purchase_return_invoice','supplier_id');
	$sale_returns = $sale_return->result();
	$payment  = get_all_by_match_one($supplier_id,'payments','supplier_id');
	$collections = $payment->result();
	$ex  = get_all_by_match_one($supplier_id,'other_accounts','supplier_id');
	$exs = $ex->result();

	$supp_col  = get_all_by_match_one($supplier_id,'supplier_collection','supplier_id');
	$supps = $supp_col->result();
	$comss  = get_all_by_match_one($supplier_id,'commisons','supplier_id');
	$coms = $comss->result();
	$this->load->view('report_popup/supplier_history',compact('pram','sales','sale_returns','collections','previous_balance','exs','supps','coms'));
	else:
	$supplier_id = $this->uri->segment(3);
	$from = date('Y-m-d',strtotime($this->uri->segment(4)));
	$to =   date('Y-m-d',strtotime($this->uri->segment(5)));

	$prev_due = 0;
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get('purchase_invoice');
    $res = $query->result();

    foreach ($res as $key => $value) {
    	if($value->approved_st == 1){
    		$prev_due += $value->total_amount - $value->cash_paid - $value->check_amount - $value->discount;
    	}else{
    		$prev_due += $value->total_amount - $value->cash_paid- $value->discount;
    	}
    }

    $this->db->select_sum('paid');
    $this->db->from('payments');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_p = $query->row()->paid;

    $this->db->select_sum('discount');
    $this->db->from('payments');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $discount = $query->row()->discount;

    $this->db->select_sum('check_amount');
    $this->db->from('payments');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('approved_st',1);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_c = $query->row()->check_amount;

    $pre_coll = $pre_coll_c + $pre_coll_p +  $discount;

    $this->db->select_sum('due');
    $this->db->from('purchase_return_invoice');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_due_ret = $query->row()->due;

    $this->db->select_sum('amount');
    $this->db->from('commisons');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $expn = $query->row()->amount;

    $this->db->select_sum('paid');
    $this->db->from('supplier_collection');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $supp_cols = $query->row()->paid;

    $previous_balance = $prev_due - $pre_due_ret - $pre_coll - $expn + $supp_cols;

    if(empty($previous_balance))
    	$previous_balance = 0;
    //now
	$sale  = get_all_by_match_one_two_date($supplier_id,'purchase_invoice','supplier_id',$from,$to);
	$sales = $sale->result();
	$sale_return  = get_all_by_match_one_two_date($supplier_id,'purchase_return_invoice','supplier_id',$from,$to);
	$sale_returns = $sale_return->result();
	$payment  = get_all_by_match_one_two_date($supplier_id,'payments','supplier_id',$from,$to);
	$collections = $payment->result();
	$ex  = get_all_by_match_one_two_date($supplier_id,'other_accounts','supplier_id',$from,$to);
	$exs = $ex->result();
	$supp_col  = get_all_by_match_one_two_date($supplier_id,'supplier_collection','supplier_id',$from,$to);
	$supps = $supp_col->result();
	$comss  = get_all_by_match_one_two_date($supplier_id,'commisons','supplier_id',$from,$to);
	$coms = $comss->result();

	$this->load->view('report_popup/supplier_history',compact('pram','sales','sale_returns','collections','previous_balance','exs','supps','coms'));
	endif;	
}


public function hist_supn(){
	$previous_balance = 0;
	$pram = ['title' => 'Supplier History'];
	if(count($this->input->post()) > 0) :
	if(empty($this->input->post('from'))):
	$supplier_id = $this->input->post('supplier_id');
	$sale  = get_all_by_match_one($supplier_id,'purchase_invoicen','supplier_id');
	$sales = $sale->result();

	$payment  = get_all_by_match_one($supplier_id,'paymentsn','supplier_id');
	$collections = $payment->result();

	$this->load->view('report/supplier_historyn',compact('pram','sales','collections','previous_balance'));
	else:
	$supplier_id = $this->input->post('supplier_id');
	$from = date("Y-m-d",strtotime($this->input->post('from')));
	$to =   date("Y-m-d",strtotime($this->input->post('to')));

    $prev_due = 0;
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get('purchase_invoicen');
    $res = $query->result();

    foreach ($res as $key => $value) {
    	if($value->approved_st == 1){
    		$prev_due += $value->total_amount - $value->cash_paid - $value->check_amount - $value->discount;
    	}else{
    		$prev_due += $value->total_amount - $value->cash_paid- $value->discount;
    	}
    }

    $this->db->select_sum('paid');
    $this->db->from('paymentsn');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_p = $query->row()->paid;

    $this->db->select_sum('check_amount');
    $this->db->from('paymentsn');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('approved_st',1);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_c = $query->row()->check_amount;

    $pre_coll = $pre_coll_c + $pre_coll_p;



    $previous_balance = $prev_due  - $pre_coll;

    if(empty($previous_balance))
    	$previous_balance = 0;
    //now
	$sale  = get_all_by_match_one_two_date($supplier_id,'purchase_invoicen','supplier_id',$from,$to);
	$sales = $sale->result();
	$sale_return  = get_all_by_match_one_two_date($supplier_id,'purchase_return_invoice','supplier_id',$from,$to);
	$sale_returns = $sale_return->result();
	$payment  = get_all_by_match_one_two_date($supplier_id,'paymentsn','supplier_id',$from,$to);
	$collections = $payment->result();

	$supp_col  = get_all_by_match_one_two_date($supplier_id,'supplier_collection','supplier_id',$from,$to);
	$this->load->view('report/supplier_history',compact('pram','sales','collections','previous_balance'));
	endif;
	else :
		
	$this->load->view('report/supplier_historyn',compact('pram'));
	endif;
	
}
public function suppliern_history_print_date(){
	$pram = ['title' => 'Supplier History'];
	$previous_balance = 0;
	if($this->uri->segment(4) == 'null'):
	$supplier_id = $this->uri->segment(3);
	$sale  = get_all_by_match_one($supplier_id,'purchase_invoicen','supplier_id');
	$sales = $sale->result();

	$payment  = get_all_by_match_one($supplier_id,'paymentsn','supplier_id');
	$collections = $payment->result();

	$this->load->view('report_popup/supplier_historyn',compact('pram','sales','collections','previous_balance'));
	else:
	$supplier_id = $this->uri->segment(3);
	$from = date('Y-m-d',strtotime($this->uri->segment(4)));
	$to =   date('Y-m-d',strtotime($this->uri->segment(5)));

	$prev_due = 0;
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get('purchase_invoicen');
    $res = $query->result();

    foreach ($res as $key => $value) {
    	if($value->approved_st == 1){
    		$prev_due += $value->total_amount - $value->cash_paid - $value->check_amount - $value->discount;
    	}else{
    		$prev_due += $value->total_amount - $value->cash_paid- $value->discount;
    	}
    }

    $this->db->select_sum('paid');
    $this->db->from('payments');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_p = $query->row()->paid;

    $this->db->select_sum('check_amount');
    $this->db->from('payments');
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('approved_st',1);
    $this->db->where('date <',$from);
    $query = $this->db->get();
    $pre_coll_c = $query->row()->check_amount;

    $pre_coll = $pre_coll_c + $pre_coll_p;

    

    $previous_balance = $prev_due - $pre_coll;

    if(empty($previous_balance))
    	$previous_balance = 0;
    //now
	$sale  = get_all_by_match_one_two_date($supplier_id,'purchase_invoicen','supplier_id',$from,$to);
	$sales = $sale->result();

	$payment  = get_all_by_match_one_two_date($supplier_id,'paymentsn','supplier_id',$from,$to);
	$collections = $payment->result();


	$this->load->view('report_popup/supplier_historyn',compact('pram','sales','collections','previous_balance'));
	endif;	
}


public function cash_satement(){
	$previous_balance = 0;
	$pram = ['title' => 'Cash Statement'];

	$date = date("Y-m-d");
	// ++
	$prev_sale = get_sum_prev_by_two('cash_paid','product_sale_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_col = get_sum_prev_by_two('paid','collections','branch_id',$this->branch_id,'date <',$date);
	$prev_pret = get_sum_prev_by_two('cash_paid','purchase_return_invoice','branch_id',$this->branch_id,'date <',$date);
	$with = get_sum_prev_by_three('amount','bank_withdraw','branch_id',$this->branch_id,'date <',$date,'check_num',0);
	$supp_col = get_sum_prev_by_two('paid','supplier_collection','branch_id',$this->branch_id,'date <',$date);
	$loan_col_prev = get_sum_prev_by_two('amount','take_loan','branch_id',$this->branch_id,'date <',$date);
	$prev_ser = get_sum_prev_by_two('paid','services','branch_id',$this->branch_id,'date <',$date)+get_sum_prev_by_two('cash_paid','services','branch_id',$this->branch_id,'delivery_date <',$date);
	$ei = get_sum_prev_by_two('amount','commisons','branch_id',$this->branch_id,'date <',$date) - get_sum_prev_by_two('amount','asset','branch_id',$this->branch_id,'date <',$date) + get_sum_prev_by_two('paid','vendor_return','branch_id',$this->branch_id,'date <',$date) +get_sum_prev_by_two('paid','complain','branch_id',$this->branch_id,'date <',$date)-get_sum_prev_by_two('eng_charge','complain','branch_id',$this->branch_id,'working_date <',$date)+get_sum_prev_by_two('advance','complain','branch_id',$this->branch_id,'date <',$date) +get_sum_prev_by_two('cash_paid','complain','branch_id',$this->branch_id,'delivery_date <',$date)+get_sum_prev_by_two('amount','studentps','branch_id',$this->branch_id,'date <',$date)+get_sum_prev_by_three('amount','promotions','branch_id',$this->branch_id,'rdate <',$date,'status',1);
	// --
	$prev_pur = get_sum_prev_by_two('cash_paid','purchase_invoice','branch_id',$this->branch_id,'date <',$date)+get_sum_prev_by_two('transport','purchase_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_payments = get_sum_prev_by_two('paid','payments','branch_id',$this->branch_id,'date <',$date);
	$prev_sret = get_sum_prev_by_two('cash_paid','product_sale_return_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_ex = get_sum_prev_by_two('amount','accounts','branch_id',$this->branch_id,'date <',$date);

	$prev_oex = get_sum_prev_by_two('amount','other_accounts','branch_id',$this->branch_id,'date <',$date);
	$loan_give_prev = get_sum_prev_by_two('amount','loan','branch_id',$this->branch_id,'date <',$date)+get_sum_prev_by_two('amount','salary_payment','branch_id',$this->branch_id,'date <',$date);

	$pc = $this->pc;
	$prev_cash = $prev_sale + $prev_ser + $with + $supp_col + $prev_col - $prev_pret + $ei - $prev_pur - $prev_sret - $prev_payments - $prev_ex - $prev_oex + $pc + $loan_col_prev - $loan_give_prev ; 
	//end prev

	// plus data
	$sale  = get_all_by_match_branch_two($date,'product_sale_invoice','date',$this->branch_id);
	$sales = $sale->result();
	$col  = get_all_by_match_branch_two($date,'collections','date',$this->branch_id);
	$collections = $col->result();
	$pret  = get_all_by_match_branch_two($date,'purchase_return_invoice','date',$this->branch_id);

	$prets = $pret->result();

	$withh  = get_all_by_match_branch_two($date,'bank_withdraw','date',$this->branch_id);

	$withs = $withh->result();

	$suppp  = get_all_by_match_branch_two($date,'supplier_collection','date',$this->branch_id);

	$suppp_col = $suppp->result();

	$loan_col  = get_all_by_match_branch_two($date,'take_loan','date',$this->branch_id);

	$loan_cols = $loan_col->result();
	
	$services  = get_all_by_match_branch_two($date,'services','date',$this->branch_id)->result();
	$servicesd  = get_all_by_match_branch_two($date,'services','delivery_date',$this->branch_id)->result();

	
	// plus data

	// minus data

	$pur  = get_all_by_match_branch_two($date,'purchase_invoice','date',$this->branch_id);
	$purs = $pur->result();
	$pay  = get_all_by_match_branch_two($date,'payments','date',$this->branch_id);
	$pays = $pay->result();
	$sret  = get_all_by_match_branch_two($date,'product_sale_return_invoice','date',$this->branch_id);
	$srets = $sret->result();
	$ex  = get_all_by_match_branch_two($date,'accounts','date',$this->branch_id);
	$exs = $ex->result();

	$oex  = get_all_by_match_branch_two($date,'other_accounts','date',$this->branch_id);
	$oexs = $oex->result();

	$loan_give  = get_all_by_match_branch_two($date,'loan','date',$this->branch_id);

	$loan_gives = $loan_give->result();

	$exi  = get_all_by_match_branch_two($date,'commisons','date',$this->branch_id);
	$exis = $exi->result();

	$asset  = get_all_by_match_branch_two($date,'asset','date',$this->branch_id);
	$assets = $asset->result();
	$salarys  = get_all_by_match_branch_two($date,'salary_payment','date',$this->branch_id)->result();
	$vrs  = get_all_by_match_branch_two($date,'vendor_return','date',$this->branch_id)->result();
	$complains  = get_all_by_match_branch_two($date,'complain','date',$this->branch_id)->result();
	$complainex  = get_all_by_match_branch_two($date,'complain','working_date',$this->branch_id)->result();
	$complainde  = get_all_by_match_branch_two($date,'complain','delivery_date',$this->branch_id)->result();
	$promotions  = get_all_by_match_branch_two($date,'promotions','rdate',$this->branch_id)->result();
	$studentps  = get_all_by_match_branch_two($date,'studentps','date',$this->branch_id)->result();
	// minus data

	$this->load->view('report/cash',compact('pram','sales','services','collections','prets','purs','pays','srets','exs','prev_cash','oexs','withs','suppp_col','loan_cols','loan_gives','exis','assets','salarys','vrs','complains','studentps','complainex','complainde','promotions','servicesd'));

	
}

public function cash_satement_search(){
	$previous_balance = 0;
	$pram = ['title' => 'Cash Statement'];
	$branch_id = $this->branch_id;
	$from = date("Y-m-d",strtotime($this->input->post('from')));
	$to = date("Y-m-d",strtotime($this->input->post('to')));
	// ++
	$prev_sale = get_sum_prev_by_two('cash_paid','product_sale_invoice','branch_id',$this->branch_id,'date <',$from);
	$prev_col = get_sum_prev_by_two('paid','collections','branch_id',$this->branch_id,'date <',$from);
	$prev_pret = get_sum_prev_by_two('cash_paid','purchase_return_invoice','branch_id',$this->branch_id,'date <',$from);
	$with = get_sum_prev_by_three('amount','bank_withdraw','branch_id',$this->branch_id,'date <',$from,'check_num',0);
	$supp_col = get_sum_prev_by_two('paid','supplier_collection','branch_id',$this->branch_id,'date <',$from);
	$loan_col_prev = get_sum_prev_by_two('amount','take_loan','branch_id',$this->branch_id,'date <',$from);
	
	$prev_ser = get_sum_prev_by_two('paid','services','branch_id',$this->branch_id,'date <',$from)+get_sum_prev_by_two('cash_paid','services','branch_id',$this->branch_id,'delivery_date <',$from);
	$ei = get_sum_prev_by_two('amount','commisons','branch_id',$this->branch_id,'date <',$from) - get_sum_prev_by_two('amount','asset','branch_id',$this->branch_id,'date <',$from) + get_sum_prev_by_two('paid','vendor_return','branch_id',$this->branch_id,'date <',$from) +get_sum_prev_by_two('paid','complain','branch_id',$this->branch_id,'date <',$from)-get_sum_prev_by_two('eng_charge','complain','branch_id',$this->branch_id,'working_date <',$from)+get_sum_prev_by_two('advance','complain','branch_id',$this->branch_id,'date <',$from)+get_sum_prev_by_two('cash_paid','complain','branch_id',$this->branch_id,'delivery_date <',$from)+get_sum_prev_by_two('amount','studentps','branch_id',$this->branch_id,'date <',$from)+get_sum_prev_by_three('amount','promotions','branch_id',$this->branch_id,'rdate <',$from,'status',1);
	// --
	$prev_pur = get_sum_prev_by_two('cash_paid','purchase_invoice','branch_id',$this->branch_id,'date <',$from)+get_sum_prev_by_two('transport','purchase_invoice','branch_id',$this->branch_id,'date <',$from);
	$prev_payments = get_sum_prev_by_two('paid','payments','branch_id',$this->branch_id,'date <',$from);
	$prev_sret = get_sum_prev_by_two('cash_paid','product_sale_return_invoice','branch_id',$this->branch_id,'date <',$from);
	$prev_ex = get_sum_prev_by_two('amount','accounts','branch_id',$this->branch_id,'date <',$from);
	$prev_oex = get_sum_prev_by_two('amount','other_accounts','branch_id',$this->branch_id,'date <',$from);
	$loan_give_prev = get_sum_prev_by_two('amount','loan','branch_id',$this->branch_id,'date <',$from)+get_sum_prev_by_two('amount','salary_payment','branch_id',$this->branch_id,'date <',$from);
	$pc = $this->pc;
	
	$prev_cash = $prev_sale + $prev_ser + $with + $supp_col + $prev_col - $prev_pret - $prev_pur - $prev_sret - $prev_payments - $prev_ex - $prev_oex + $pc + $loan_col_prev - $loan_give_prev + $ei; 



	//end prev

	// plus data
	$sale  = get_all_by_match_one_two_date($branch_id,'product_sale_invoice','branch_id',$from,$to);
	$sales = $sale->result();
	$col  = get_all_by_match_one_two_date($branch_id,'collections','branch_id',$from,$to);
	$collections = $col->result();
	$pret  = get_all_by_match_one_two_date($branch_id,'purchase_return_invoice','branch_id',$from,$to);
	$prets = $pret->result();

	$withh  = get_all_by_match_one_two_date($branch_id,'bank_withdraw','branch_id',$from,$to);
	$withs = $withh->result();

	$suppp  = get_all_by_match_one_two_date($branch_id,'supplier_collection','branch_id',$from,$to);
	$suppp_col = $suppp->result();

	$loan  = get_all_by_match_one_two_date($branch_id,'take_loan','branch_id',$from,$to);
	$loan_cols = $loan->result();
	
	$services  = get_all_by_match_one_two_date($branch_id,'services','branch_id',$from,$to)->result();

	// plus data

	// minus data

	$pur  = get_all_by_match_one_two_date($branch_id,'purchase_invoice','branch_id',$from,$to);
	$purs = $pur->result();
	$pay  = get_all_by_match_one_two_date($branch_id,'payments','branch_id',$from,$to);
	$pays = $pay->result();
	$sret  = get_all_by_match_one_two_date($branch_id,'product_sale_return_invoice','branch_id',$from,$to);
	$srets = $sret->result();
	$ex  = get_all_by_match_one_two_date($branch_id,'accounts','branch_id',$from,$to);
	$exs = $ex->result();
	$oex  = get_all_by_match_one_two_date($branch_id,'other_accounts','branch_id',$from,$to);
	$oexs = $oex->result();

	$loang  = get_all_by_match_one_two_date($branch_id,'loan','branch_id',$from,$to);
	$loan_gives = $loang->result();

	$exi  = get_all_by_match_one_two_date($branch_id,'commisons','branch_id',$from,$to);
	$exis = $exi->result();
	$asset  = get_all_by_match_one_two_date($branch_id,'asset','branch_id',$from,$to);
	$assets = $asset->result();
	$salarys  = get_all_by_match_one_two_date($branch_id,'salary_payment','branch_id',$from,$to)->result();
	$vrs  = get_all_by_match_one_two_date($branch_id,'vendor_return','branch_id',$from,$to)->result();
	$complains  = get_all_by_match_one_two_date($branch_id,'complain','branch_id',$from,$to)->result();
	$complainex  = get_all_by_match_one_two_datecol($branch_id,'complain','branch_id',$from,$to,'working_date >=','working_date <=')->result();
	$complainde  = get_all_by_match_one_two_datecol($branch_id,'complain','branch_id',$from,$to,'delivery_date >=','delivery_date <=')->result();
	$studentps  = get_all_by_match_one_two_date($branch_id,'studentps','branch_id',$from,$to)->result();
	$promotions  = get_all_by_match_one_two_datecol($branch_id,'promotions','branch_id',$from,$to,'rdate >=','rdate <=')->result();
	$servicesd  = get_all_by_match_one_two_datecol($branch_id,'services','branch_id',$from,$to,'delivery_date >=','delivery_date <=')->result();

	// minus data

	$this->load->view('report/cash',compact('pram','sales','services','collections','prets','purs','pays','srets','exs','prev_cash','oexs','withs','suppp_col','loan_cols','loan_gives','exis','assets','salarys','vrs','complains','studentps','complainex','complainde','promotions','servicesd'));

    
}
public function cash_satement_print(){
	$previous_balance = 0;
	$pram = ['title' => 'Cash Statement'];
	if($this->uri->segment(3) == 'null'){
	$date = date("Y-m-d");
	// ++
	$prev_sale = get_sum_prev_by_two('cash_paid','product_sale_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_col = get_sum_prev_by_two('paid','collections','branch_id',$this->branch_id,'date <',$date);
	$prev_pret = get_sum_prev_by_two('cash_paid','purchase_return_invoice','branch_id',$this->branch_id,'date <',$date);
	$with = get_sum_prev_by_three('amount','bank_withdraw','branch_id',$this->branch_id,'date <',$date,'check_num',0);
	$supp_col = get_sum_prev_by_two('paid','supplier_collection','branch_id',$this->branch_id,'date <',$date);
	$loan_col_prev = get_sum_prev_by_two('amount','take_loan','branch_id',$this->branch_id,'date <',$date);
	$prev_ser = get_sum_prev_by_two('paid','services','branch_id',$this->branch_id,'date <',$date)+get_sum_prev_by_two('cash_paid','services','branch_id',$this->branch_id,'delivery_date <',$date);
	$ei = get_sum_prev_by_two('amount','commisons','branch_id',$this->branch_id,'date <',$date) - get_sum_prev_by_two('amount','asset','branch_id',$this->branch_id,'date <',$date) + get_sum_prev_by_two('paid','vendor_return','branch_id',$this->branch_id,'date <',$date) +get_sum_prev_by_two('paid','complain','branch_id',$this->branch_id,'date <',$date)-get_sum_prev_by_two('eng_charge','complain','branch_id',$this->branch_id,'working_date <',$date)+get_sum_prev_by_two('advance','complain','branch_id',$this->branch_id,'date <',$date)+get_sum_prev_by_two('cash_paid','complain','branch_id',$this->branch_id,'delivery_date <',$date)+get_sum_prev_by_two('amount','studentps','branch_id',$this->branch_id,'date <',$date)+get_sum_prev_by_three('amount','promotions','branch_id',$this->branch_id,'rdate <',$date,'status',1);
	// --
	$prev_pur = get_sum_prev_by_two('cash_paid','purchase_invoice','branch_id',$this->branch_id,'date <',$date)+get_sum_prev_by_two('transport','purchase_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_payments = get_sum_prev_by_two('paid','payments','branch_id',$this->branch_id,'date <',$date);
	$prev_sret = get_sum_prev_by_two('cash_paid','product_sale_return_invoice','branch_id',$this->branch_id,'date <',$date);
	$prev_ex = get_sum_prev_by_two('amount','accounts','branch_id',$this->branch_id,'date <',$date);

	$prev_oex = get_sum_prev_by_two('amount','other_accounts','branch_id',$this->branch_id,'date <',$date);
	$loan_give_prev = get_sum_prev_by_two('amount','loan','branch_id',$this->branch_id,'date <',$date)+get_sum_prev_by_two('amount','salary_payment','branch_id',$this->branch_id,'date <',$date);

	$pc = $this->pc;
	$prev_cash = $prev_sale + $prev_ser + $with + $supp_col + $prev_col - $prev_pret + $ei - $prev_pur - $prev_sret - $prev_payments - $prev_ex - $prev_oex + $pc + $loan_col_prev - $loan_give_prev ; 
	//end prev

	// plus data
	$sale  = get_all_by_match_branch_two($date,'product_sale_invoice','date',$this->branch_id);
	$sales = $sale->result();
	$col  = get_all_by_match_branch_two($date,'collections','date',$this->branch_id);
	$collections = $col->result();
	$pret  = get_all_by_match_branch_two($date,'purchase_return_invoice','date',$this->branch_id);

	$prets = $pret->result();

	$withh  = get_all_by_match_branch_two($date,'bank_withdraw','date',$this->branch_id);

	$withs = $withh->result();

	$suppp  = get_all_by_match_branch_two($date,'supplier_collection','date',$this->branch_id);

	$suppp_col = $suppp->result();

	$loan_col  = get_all_by_match_branch_two($date,'take_loan','date',$this->branch_id);

	$loan_cols = $loan_col->result();
	
	$services  = get_all_by_match_branch_two($date,'services','date',$this->branch_id)->result();
	$servicesd  = get_all_by_match_branch_two($date,'services','delivery_date',$this->branch_id)->result();

	
	// plus data

	// minus data

	$pur  = get_all_by_match_branch_two($date,'purchase_invoice','date',$this->branch_id);
	$purs = $pur->result();
	$pay  = get_all_by_match_branch_two($date,'payments','date',$this->branch_id);
	$pays = $pay->result();
	$sret  = get_all_by_match_branch_two($date,'product_sale_return_invoice','date',$this->branch_id);
	$srets = $sret->result();
	$ex  = get_all_by_match_branch_two($date,'accounts','date',$this->branch_id);
	$exs = $ex->result();

	$oex  = get_all_by_match_branch_two($date,'other_accounts','date',$this->branch_id);
	$oexs = $oex->result();

	$loan_give  = get_all_by_match_branch_two($date,'loan','date',$this->branch_id);

	$loan_gives = $loan_give->result();

	$exi  = get_all_by_match_branch_two($date,'commisons','date',$this->branch_id);
	$exis = $exi->result();

	$asset  = get_all_by_match_branch_two($date,'asset','date',$this->branch_id);
	$assets = $asset->result();
	$salarys  = get_all_by_match_branch_two($date,'salary_payment','date',$this->branch_id)->result();
	$vrs  = get_all_by_match_branch_two($date,'vendor_return','date',$this->branch_id)->result();
	$complains  = get_all_by_match_branch_two($date,'complain','date',$this->branch_id)->result();
	$complainex  = get_all_by_match_branch_two($date,'complain','working_date',$this->branch_id)->result();
	$complainde  = get_all_by_match_branch_two($date,'complain','delivery_date',$this->branch_id)->result();
	$studentps  = get_all_by_match_branch_two($date,'studentps','date',$this->branch_id)->result();
	$promotions  = get_all_by_match_branch_two($date,'promotions','rdate',$this->branch_id)->result();
	// minus data

	$this->load->view('report_popup/cash',compact('pram','sales','services','collections','prets','purs','pays','srets','exs','prev_cash','oexs','withs','suppp_col','loan_cols','loan_gives','exis','assets','salarys','vrs','complains','studentps','complainex','complainde','promotions','servicesd'));

	}else{
		$branch_id = $this->branch_id;
		$from = date("Y-m-d",strtotime($this->uri->segment(3)));
		$to = date("Y-m-d",strtotime($this->uri->segment(4)));
		// ++
	$prev_sale = get_sum_prev_by_two('cash_paid','product_sale_invoice','branch_id',$this->branch_id,'date <',$from);
	$prev_col = get_sum_prev_by_two('paid','collections','branch_id',$this->branch_id,'date <',$from);
	$prev_pret = get_sum_prev_by_two('cash_paid','purchase_return_invoice','branch_id',$this->branch_id,'date <',$from);
	$with = get_sum_prev_by_three('amount','bank_withdraw','branch_id',$this->branch_id,'date <',$from,'check_num',0);
	$supp_col = get_sum_prev_by_two('paid','supplier_collection','branch_id',$this->branch_id,'date <',$from);
	$loan_col_prev = get_sum_prev_by_two('amount','take_loan','branch_id',$this->branch_id,'date <',$from);
	$prev_ser = get_sum_prev_by_two('paid','services','branch_id',$this->branch_id,'date <',$from)+get_sum_prev_by_two('cash_paid','services','branch_id',$this->branch_id,'delivery_date <',$from);
	$ei = get_sum_prev_by_two('amount','commisons','branch_id',$this->branch_id,'date <',$from) - get_sum_prev_by_two('amount','asset','branch_id',$this->branch_id,'date <',$from) + get_sum_prev_by_two('paid','vendor_return','branch_id',$this->branch_id,'date <',$from) +get_sum_prev_by_two('paid','complain','branch_id',$this->branch_id,'date <',$from)-get_sum_prev_by_two('eng_charge','complain','branch_id',$this->branch_id,'working_date <',$from)+get_sum_prev_by_two('advance','complain','branch_id',$this->branch_id,'date <',$from)+get_sum_prev_by_two('cash_paid','complain','branch_id',$this->branch_id,'delivery_date <',$from)+get_sum_prev_by_two('amount','studentps','branch_id',$this->branch_id,'date <',$from)+get_sum_prev_by_three('amount','promotions','branch_id',$this->branch_id,'rdate <',$from,'status',1);
	// --
	$prev_pur = get_sum_prev_by_two('cash_paid','purchase_invoice','branch_id',$this->branch_id,'date <',$from)+get_sum_prev_by_two('transport','purchase_invoice','branch_id',$this->branch_id,'date <',$from);
	$prev_payments = get_sum_prev_by_two('paid','payments','branch_id',$this->branch_id,'date <',$from);
	$prev_sret = get_sum_prev_by_two('cash_paid','product_sale_return_invoice','branch_id',$this->branch_id,'date <',$from);
	$prev_ex = get_sum_prev_by_two('amount','accounts','branch_id',$this->branch_id,'date <',$from);
	$prev_oex = get_sum_prev_by_two('amount','other_accounts','branch_id',$this->branch_id,'date <',$from);
	$loan_give_prev = get_sum_prev_by_two('amount','loan','branch_id',$this->branch_id,'date <',$from)+get_sum_prev_by_two('amount','salary_payment','branch_id',$this->branch_id,'date <',$from);
	$pc = $this->pc;
	$prev_cash = $prev_sale + $prev_ser + $with + $supp_col + $prev_col - $prev_pret - $prev_pur - $prev_sret - $prev_payments - $prev_ex - $prev_oex + $pc + $loan_col_prev - $loan_give_prev + $ei; 
	//end prev

	// plus data
	$sale  = get_all_by_match_one_two_date($branch_id,'product_sale_invoice','branch_id',$from,$to);
	$sales = $sale->result();
	$col  = get_all_by_match_one_two_date($branch_id,'collections','branch_id',$from,$to);
	$collections = $col->result();
	$pret  = get_all_by_match_one_two_date($branch_id,'purchase_return_invoice','branch_id',$from,$to);
	$prets = $pret->result();

	$withh  = get_all_by_match_one_two_date($branch_id,'bank_withdraw','branch_id',$from,$to);
	$withs = $withh->result();

	$suppp  = get_all_by_match_one_two_date($branch_id,'supplier_collection','branch_id',$from,$to);
	$suppp_col = $suppp->result();

	$loan  = get_all_by_match_one_two_date($branch_id,'take_loan','branch_id',$from,$to);
	$loan_cols = $loan->result();
	
	$services  = get_all_by_match_one_two_date($branch_id,'services','branch_id',$from,$to)->result();

	// plus data

	// minus data

	$pur  = get_all_by_match_one_two_date($branch_id,'purchase_invoice','branch_id',$from,$to);
	$purs = $pur->result();
	$pay  = get_all_by_match_one_two_date($branch_id,'payments','branch_id',$from,$to);
	$pays = $pay->result();
	$sret  = get_all_by_match_one_two_date($branch_id,'product_sale_return_invoice','branch_id',$from,$to);
	$srets = $sret->result();
	$ex  = get_all_by_match_one_two_date($branch_id,'accounts','branch_id',$from,$to);
	$exs = $ex->result();
	$oex  = get_all_by_match_one_two_date($branch_id,'other_accounts','branch_id',$from,$to);
	$oexs = $oex->result();

	$loang  = get_all_by_match_one_two_date($branch_id,'loan','branch_id',$from,$to);
	$loan_gives = $loang->result();

	$exi  = get_all_by_match_one_two_date($branch_id,'commisons','branch_id',$from,$to);
	$exis = $exi->result();
	$asset  = get_all_by_match_one_two_date($branch_id,'asset','branch_id',$from,$to);
	$assets = $asset->result();
	$salarys  = get_all_by_match_one_two_date($branch_id,'salary_payment','branch_id',$from,$to)->result();
	$vrs  = get_all_by_match_one_two_date($branch_id,'vendor_return','branch_id',$from,$to)->result();
	$complains  = get_all_by_match_one_two_date($branch_id,'complain','branch_id',$from,$to)->result();
	$complainex  = get_all_by_match_one_two_datecol($branch_id,'complain','branch_id',$from,$to,'working_date >=','working_date <=')->result();
	$complainde  = get_all_by_match_one_two_datecol($branch_id,'complain','branch_id',$from,$to,'delivery_date >=','delivery_date <=')->result();
	$studentps  = get_all_by_match_one_two_date($branch_id,'studentps','branch_id',$from,$to)->result();
	$promotions  = get_all_by_match_one_two_datecol($branch_id,'promotions','branch_id',$from,$to,'rdate >=','rdate <=')->result();

	$servicesd  = get_all_by_match_one_two_datecol($branch_id,'services','branch_id',$from,$to,'delivery_date >=','delivery_date <=')->result();

	// minus data

	$this->load->view('report_popup/cash',compact('pram','sales','services','collections','prets','purs','pays','srets','exs','prev_cash','oexs','withs','suppp_col','loan_cols','loan_gives','exis','assets','salarys','vrs','complains','studentps','complainex','complainde','promotions','servicesd'));

	}	
}
public function bank_satement(){
	$previous_balance = 0;
	$pram = ['title' => 'Bank Statement'];
		if(count($this->input->post()) > 0) {

			$bank_id = $this->input->post('bank_id');
			$bank = view_all_by_id($bank_id,'banks');
			$previous_balance = $bank->balance;
			//--
			$pur  = get_all_by_match_branch_three('purchase_invoice','approved_st',1,'bank_id',$bank_id,$this->branch_id);
			$purs = $pur->result();
			$pay  = get_all_by_match_branch_three('payments','approved_st',1,'bank_id',$bank_id,$this->branch_id);
			$pays = $pay->result();

			$this->db->where('bank_id',$bank_id);
			$this->db->where('branch_id',$this->branch_id);
			$q = $this->db->get('bank_withdraw');
			$withdraws = $q->result();
			//++
			$sal  = get_all_by_match_branch_three('product_sale_invoice','approved_st',1,'bank_id',$bank_id,$this->branch_id);
			$sales = $sal->result();
			$col  = get_all_by_match_branch_three('collections','approved_st',1,'bank_id',$bank_id,$this->branch_id);
			$collections = $col->result();
			$colb  = get_all_by_match_branch_two($bank_id,'collections','bank_id',$this->branch_id);
			$bcollections = $colb->result();

			$this->db->where('bank_id',$bank_id);
			$this->db->where('branch_id',$this->branch_id);
			$this->db->where('type_id',3);
			$qr = $this->db->get('other_accounts');
			$oexs = $qr->result();

			$this->load->view('report/bank',compact('pram','sales','collections','purs','pays','oexs','previous_balance','withdraws','bcollections'));
		}else{
			$date = date("Y-m-d");
			//--
			$pur  = get_all_by_match_branch_three('purchase_invoice','approved_st',1,'date',$date,$this->branch_id);
			$purs = $pur->result();
			$pay  = get_all_by_match_branch_three('payments','approved_st',1,'date',$date,$this->branch_id);
			$pays = $pay->result();

			$this->db->where('date',$date);
			$this->db->where('branch_id',$this->branch_id);
			$q = $this->db->get('bank_withdraw');
			$withdraws = $q->result();
			//++
			$sal  = get_all_by_match_branch_three('product_sale_invoice','approved_st',1,'date',$date,$this->branch_id);
			$sales = $sal->result();
			$col  = get_all_by_match_branch_three('collections','approved_st',1,'date',$date,$this->branch_id);
			$collections = $col->result();
			$colb  = get_all_by_match_branch_two($date,'collections','date',$this->branch_id);
			$bcollections = $colb->result();

			$this->db->where('date',$date);
			$this->db->where('branch_id',$this->branch_id);
			$this->db->where('type_id',3);
			$qr = $this->db->get('other_accounts');
			$oexs = $qr->result();

			$this->load->view('report/bank',compact('pram','sales','collections','purs','pays','oexs','previous_balance','withdraws','bcollections'));
			//end prev
		}
	
}

public function bank_satement_print(){
	$previous_balance = 0;
	$pram = ['title' => 'Bank Statement'];
		
	$bank_id = $this->uri->segment(3);
	$bank = view_all_by_id($bank_id,'banks');
	$previous_balance = $bank->balance;
	//--
	$pur  = get_all_by_match_branch_three('purchase_invoice','approved_st',1,'bank_id',$bank_id,$this->branch_id);
	$purs = $pur->result();
	$pay  = get_all_by_match_branch_three('payments','approved_st',1,'bank_id',$bank_id,$this->branch_id);
	$pays = $pay->result();

	$this->db->where('bank_id',$bank_id);
	$this->db->where('branch_id',$this->branch_id);
	$q = $this->db->get('bank_withdraw');
	$withdraws = $q->result();
	//++
	$sal  = get_all_by_match_branch_three('product_sale_invoice','approved_st',1,'bank_id',$bank_id,$this->branch_id);
	$sales = $sal->result();
	$col  = get_all_by_match_branch_three('collections','approved_st',1,'bank_id',$bank_id,$this->branch_id);
	$collections = $col->result();
	$colb  = get_all_by_match_branch_two($bank_id,'collections','bank_id',$this->branch_id);
	$bcollections = $colb->result();

	$this->db->where('bank_id',$bank_id);
	$this->db->where('branch_id',$this->branch_id);
	$this->db->where('type_id',3);
	$qr = $this->db->get('other_accounts');
	$oexs = $qr->result();

	$this->load->view('report_popup/bank',compact('pram','sales','collections','purs','pays','oexs','previous_balance','withdraws','bcollections'));
		
	
}
public function loan_satement(){
	$previous_balance = 0;
	$pram = ['title' => 'Loan Statement'];
		if(count($this->input->post()) > 0) {

			$head_id = $this->input->post('head_id');
			
			//--
			$lg  = get_all_by_match_branch_two($head_id,'loan','head_id',$this->branch_id);
			$lgs = $lg->result();
			$lta  = get_all_by_match_branch_two($head_id,'take_loan','head_id',$this->branch_id);
			$ltas = $lta->result();


			$this->load->view('report/loan',compact('pram','ltas','lgs'));
		}else{
			
			// ++
			$prev_give = get_sum_prev_by_one('amount','loan','branch_id',$this->branch_id);
			$prev_col = get_sum_prev_by_one('amount','take_loan','branch_id',$this->branch_id);
			
			
			$balance = $prev_give - $prev_col; 
			$this->load->view('report/loan',compact('pram','balance'));
			//end prev
		}
	
}

public function loan_satement_print(){
	$previous_balance = 0;
	$pram = ['title' => 'Loan Statement'];
	$head_id = $this->uri->segment(3);
			
	//--
	$lg  = get_all_by_match_branch_two($head_id,'loan','head_id',$this->branch_id);
	$lgs = $lg->result();
	$lta  = get_all_by_match_branch_two($head_id,'take_loan','head_id',$this->branch_id);
	$ltas = $lta->result();


	$this->load->view('report_popup/loan',compact('pram','ltas','lgs'));
		
	
}
public function inv_led_cus(){
	$previous_balance = 0;
	$pram = ['title' => 'Customer History Ledger'];
	if(count($this->input->post()) > 0) :
	$customer_id = $this->input->post('customer_id');
	$invoice_number = $this->input->post('invoice_number');

	$prev_due = 0;
    $this->db->where('customer_id',$customer_id);
    $this->db->where('id',$invoice_number);
    $query = $this->db->get('product_sale_invoice');
    $sales = $query->result();

    $this->db->where('customer_id',$customer_id);
    $this->db->where('invoice_number',$invoice_number);
    $query = $this->db->get('collections');
    $collections = $query->result();

	$this->load->view('report/customer_history_ledger',compact('pram','sales','collections'));
	else :
		
	$this->load->view('report/customer_history_ledger',compact('pram'));
	endif;
	
}
public function inv_led_sub(){
	$previous_balance = 0;
	$pram = ['title' => 'Supplier History Ledger'];
	if(count($this->input->post()) > 0) :
	$supplier_id = $this->input->post('supplier_id');
	$invoice_number = $this->input->post('invoice_number');

	$prev_due = 0;
    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('id',$invoice_number);
    $query = $this->db->get('purchase_invoice');
    $sales = $query->result();

    $this->db->where('supplier_id',$supplier_id);
    $this->db->where('invoice_number',$invoice_number);
    $query = $this->db->get('payments');
    $collections = $query->result();

	$this->load->view('report/supplier_history_ledger',compact('pram','sales','collections'));
	else :
		
	$this->load->view('report/supplier_history_ledger',compact('pram'));
	endif;
	
}
public function item_ledger(){
	$previous_balance = 0;
	$pram = ['title' => 'Item Ledger'];
	if(count($this->input->post()) > 0) :


	$product_id = $this->input->post('product_id');
	$name = my_col('name','id',$product_id,'products');


    $this->db->where('name',$name);
    $query = $this->db->get('product_purchase');
    $purchases = $query->result();

    $this->db->where('product_id',$product_id);
    $query = $this->db->get('product_return');
    $return = $query->result();

    $this->db->where('product_id',$product_id);
    $query = $this->db->get('product_sale');
    $sales = $query->result();

    $this->db->where('product_id',$product_id);
    $query = $this->db->get('product_sale_return');
    $sa_return = $query->result();

    $this->db->where('id',$product_id);
    $query = $this->db->get('products');
    $price = $query->row()->cost_price;
    $saleprice = $query->row()->sale_price;

	$this->load->view('report/item_ledger',compact('pram','sales','sa_return','purchases','return','price','saleprice'));
	else :
		
	$this->load->view('report/item_ledger',compact('pram'));
	endif;
	
}
public function ime_inactive(){
    $id = $this->uri->segment(2);
    $product_id = my_col('product_id','id',$id,'imes');
    $this->db->set('status',0);
    $this->db->where('id',$id);
    $up =  $this->db->update('imes');
   
   if($up){
       
       $products = get_all_by_match_one($product_id,'imes','product_id');
	  $this->load->view('report_popup/stock_report_ime',compact('pram','products'));
   }else{
       exit;
   }   
}


public function vendor_return_report(){
	$pram = ['title' => 'Sale Return Report'];
		if(count($this->input->post()) > 0) :
		$date = $this->input->post('date');
		$supplier_id = $this->input->post('supplier_id');
		$this->db->where('branch_id',$this->branch_id);
		$this->db->where('date',$date);
		$this->db->where('supplier_id',$supplier_id);
		$products  = $this->db->get('vendor_return')->result();
	else:
	$products  = view_all_with_branch_report_date('vendor_return',$this->branch_id,$this->date);
	endif;
	$this->load->view('report/vendor_return_report',compact('pram','products'));
}
public function vendor_return_report_print(){
	$pram = ['title' => 'Sale Return Report'];
	$products  = view_all_with_branch_report_date('vendor_return',$this->branch_id,$this->date);
	$this->load->view('report_popup/vendor_return_report',compact('pram','products'));
}
public function vendor_return_report_search_date(){
	$pram = ['title' => 'Sale Return Report'];
	$from = date('Y-m-d',strtotime($this->input->post('from')));
    $to = date('Y-m-d',strtotime($this->input->post('to')));
	$products  = view_all_with_branch_report_date_search('vendor_return',$this->branch_id,$from,$to);
	$this->load->view('report/vendor_return_report',compact('pram','products'));
}

public function vendor_return_report_print_date(){
	$pram = ['title' => 'Sale Return Report'];
	$from = date('Y-m-d',strtotime($this->uri->segment(3)));
    $to = date('Y-m-d',strtotime($this->uri->segment(4)));
	$products  = view_all_with_branch_report_date_search('vendor_return',$this->branch_id,$from,$to);
	$this->load->view('report_popup/vendor_return_report',compact('pram','products'));
}

public function vendor_return_report_search_date_status(){
	$pram = ['title' => 'Sale Return Report'];
    
    
    $status = $this->input->post('status');
    //$supplier_id = $this->input->post('supplier_id');

    if($status == 0){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('taka_receive',0);
    	$this->db->where('product_receive',0);
    	//$this->db->where('supplier_id',$supplier_id);
    	$this->db->where('damage',0);
    	
    	
    	$products  = $this->db->get('vendor_return')->result();
    }
    if($status == 1){
        
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('taka_receive',1);
    	$this->db->group_start();
    	$this->db->or_where('product_receive',1);
    	$this->db->or_where('damage',1);
    	$this->db->group_end();
    	//$this->db->where('supplier_id',$supplier_id);
    	$products  = $this->db->get('vendor_return')->result();
    }
    if($status == 2){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('taka_receive',1);
    	//$this->db->where('supplier_id',$supplier_id);
    	
    	
    	$products  = $this->db->get('vendor_return')->result();
    }
    if($status == 3){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('product_receive',1);
    	//$this->db->where('supplier_id',$supplier_id);
    	
    	
    	$products  = $this->db->get('vendor_return')->result();
    }
    if($status == 4){
     //   exit;
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('damage',1);
    	//$this->db->where('supplier_id',$supplier_id);
    	
    	
    	$products  = $this->db->get('vendor_return')->result();
    }
	$this->load->view('vendor_return/manage',compact('pram','products'));
}

public function sale_return_report_search_date_status(){
	$pram = ['title' => 'Sale Return Report'];
    
    
    $status = $this->input->post('status');
    //$supplier_id = $this->input->post('supplier_id');

    if($status == 0){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('send',0);
    	$this->db->where('receive',0);
    	$this->db->where('delivery',0);
    	//$this->db->where('supplier_id',$supplier_id);
    	
    	
    	$products  = $this->db->get('product_sale_return_invoice')->result();
    }
    if($status == 1){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('send',1);
    	$this->db->or_where('receive',1);
    	$this->db->or_where('delivery',1);
    	//$this->db->where('supplier_id',$supplier_id);
    	
    	
    	$products  = $this->db->get('product_sale_return_invoice')->result();
    }
    if($status == 2){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('send',1);
    	//$this->db->where('supplier_id',$supplier_id);
    	
    	
    	$products  = $this->db->get('product_sale_return_invoice')->result();
    }
    if($status == 3){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('receive',1);
    	//$this->db->where('supplier_id',$supplier_id);
    	
    	
    	$products  = $this->db->get('product_sale_return_invoice')->result();
    }
    if($status == 4){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('delivery',1);
    	//$this->db->where('supplier_id',$supplier_id);
    	
    	
    	$products  = $this->db->get('product_sale_return_invoice')->result();
    }

	$this->load->view('sale_return/manage_sale_return',compact('pram','products'));
}
public function product_return_report_search_date_status(){
	$pram = ['title' => 'Sale Return Report'];
    
    
    $status = $this->input->post('status');
    //$supplier_id = $this->input->post('supplier_id');

    if($status == 0){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('receive',0);
    	$this->db->where('damage',0);
    	//$this->db->where('supplier_id',$supplier_id);
    	
    	
    	$products  = $this->db->get('purchase_return_invoice')->result();
    }
    if($status == 1){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('receive',1);
    	$this->db->or_where('damage',1);
    	//$this->db->where('supplier_id',$supplier_id);	
    	$products  = $this->db->get('purchase_return_invoice')->result();
    }
    if($status == 2){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('receive',1);
    	//$this->db->where('supplier_id',$supplier_id);
    	
    	
    	$products  = $this->db->get('purchase_return_invoice')->result();
    }
    if($status == 3){
    	$this->db->where('branch_id',$this->branch_id);
    	$this->db->where('damage',1);
    	//$this->db->where('supplier_id',$supplier_id);
    	
    	
    	$products  = $this->db->get('purchase_return_invoice')->result();
    }
    

	$this->load->view('purchase/manage_product_return',compact('pram','products'));
}
public function salary_ledger(){
	$previous_balance = 0;
	$pram = ['title' => 'Salary Ledger'];
	$employees = view_all_with_branch('employees',$this->branch_id);
		
	$this->load->view('report/salary_report',compact('pram','employees'));
	
}

public function salary_report_print_date(){
	$previous_balance = 0;
	$pram = ['title' => 'Salary Ledger'];
	$employees = view_all_with_branch('employees',$this->branch_id);
	$this->load->view('report_popup/salary_ledger',compact('pram','employees'));
	
}
//8.9.22
public function product_list(){
	$pram = ['title' => 'product list'];
	$this->db->where('branch_id',$this->branch_id);
	$product = $this->db->get('products');
	$products = $product->result();
	$this->load->view('product/product_list',compact('pram','products'));
}

}	