<?php 
  $this->load->view('includes/header');
  $this->load->view('includes/nav_header');
  $this->load->view('includes/sidebar_menu');
  $branch_id = $this->session->userdata('branch_id');
?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header" >
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Create Deposit</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <div class="res" style="text-align: center;font-weight: bold;"></div>
    <section class="content">
      <div class="container-fluid">
      <form method="POST" enctype="multipart/form-data" id="add_form">      
        <div class="row">
          <div class="card-body">
            <div class="row"> 
              
              <div class="col-md-6">
                <div class="form-group">
                  <label>Invoice Number</label>
                  <input type="text" placeholder="0.00" readonly="" class="form-control" value="<?= $code;?>">
                </div>                
              </div>

             
              <div class="col-md-6" id="bank">
                <div class="form-group">
                  <label>Bank Name</label>
                  <?php 
                    $combo_items = combobox_bind_branch('banks','id','name',$branch_id,'Bank');
                      echo form_dropdown('bank_id',$combo_items,'','class="form-control select2" id="bank_id" style="width: 100%;height:30px"');
                  ?>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Amount</label>
                  <input type="text" placeholder="0.00" class="form-control" name="amount" autocomplete="off">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Comment</label>
                  <textarea name="comment" class="form-control"></textarea>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Date</label>
                  <div class="input-group">
                    <div class="input-group-prepend">
                      <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                    </div>
                    <input type="text" onfocusout="this.type='text'" onfocus="this.type='date'" value="<?= date('Y-m-d')?>" class="form-control" name="date">
                    <input type="hidden" name="type_id" value="3">
                  </div>
                </div>
              </div>
            </div>
            <!-- /.row -->
          </div>
        </div>
        <div class="card-footer" style="text-align: center;">
          <button type="reset" class="btn btn-danger">Reset</button>
          <button type="submit" name="submit" class="btn btn-info">Submit</button>
        </div>
      </form>
      </div>
    </section>
  </div>
<script type="text/javascript">
  $(document).ready(function(){
    
     
    $('#add_form').on('submit',function(e){
      $.ajax({
             type:'post',
             url : '<?= base_url("deposit/create")?>',
             data:new FormData(this),
             processData:false,
             contentType:false,
             cache:false,
             async:false,
             
             success:function(res){
              $("html, body").animate({ scrollTop: 0 }, 150);
              if(res == 1)
               $('.res').html('<i class="fa fa-check" style="color:green;font-size:24px;"></i> Account Info Created Successfully');
              else if(res == 0)
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> Account Info Not Created'); 
             setTimeout(function(){
               location.reload();
             },200);
             }
      });
       e.preventDefault();
    });
  });
</script>
<?php 
  $this->load->view('includes/footer');
?>