<?php 
  $this->load->view('includes/header');
  $this->load->view('includes/nav_header');
  $this->load->view('includes/sidebar_menu');
  $accesss = $this->session->userdata('permission');
  $permission = explode(",", $accesss);
?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header" >
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Manage Branch</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <div class="res" style="text-align: center;font-weight: bold;"></div>
    <section class="content">
      <div class="container-fluid">
        <div class="card-body" id="scroll">
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th class="text-center">Sl</th>
                  <th class="text-center">Branch Name</th>
                  <th class="text-center">Address</th>
                  <th class="text-center">Contact No</th>
                  <th class="text-center">Logo</th>
                  <th class="text-center">Create Date</th>
                  <th class="text-center">Action</th>
                </tr>
                </thead>
                <tbody>
                  <?php
                    $i = 1;
                    foreach($branches as $branch):
                  ?>
                <tr>
                  <td class="text-center"><?= $i;?></td>
                  <td class="text-center"><?= $branch->name;?></td>
                  <td class="text-center"><?= $branch->address;?></td>
                  <td class="text-center"><?= $branch->contact_no;?></td>
                  <td class="text-center"><img src="<?= base_url($branch->logo);?>" style="height: 70px;width: 100px;"></td>
                  <td class="text-center"><?= date("F j, Y",strtotime($branch->date));?></td>
                  <td class="text-center">
                   <?php if(in_array("Setting_Edit", $permission)):?>
                    <a  class="btn btn-info"  href='<?= base_url("branch/show/{$branch->id}");?>' >
                    <i class="fa fa-edit "></i>
                  </a>
                  <?php endif; if(in_array("Setting_Delete", $permission)):?>
                    <a class="btn btn-danger delete-btn" href='<?= base_url("branch/delete/{$branch->id}");?>'  id="<?= $branch->id?>" >
                      <i class="fa fa-trash-o "></i>
                   </a>
                 <?php endif;?>
                  </td>
                </tr>
                <?php 
                  $i++;
                  endforeach;
                ?>
                </tbody>
              </table>
            </div>
      </div>
    </section>
  </div>
<script Branch="text/javascript">
 $(document).ready(function(){
     $(".delete-btn").on('click',function(e){
       var check = confirm("Are You Sure Want to Delete?");     
       if(check)
          {
           var href = $(this).attr("href");   
          $.ajax({
            type: "post",
            url: href,
            success: function(res)
            {
             
            if (res == 1)
            {            
            $("html, body").animate({ scrollTop: 0 }, 500);
                $('.res').html('<p class="alert alert-success"><i class="fa fa-check" ></i> Branch Info Deleted Successfully!</p>');          
                    setTimeout(function()
                     {
                      window.location.reload();
                     },300);
            }
            else
            {
              $("html, body").animate({ scrollTop: 0 }, 500);
               $('.res').html('<p class="alert alert-danger"><i class="fa fa-times"></i> Branch Info Not Deleted!</p>');
                  setTimeout(function()
                  {
                    window.location.reload();
                  },300);
            }

         },
         error:function(res)
         {
           $("html, body").animate({ scrollTop: 0 }, 1000);
          $('.res').html('<p class="alert alert-danger"><i class="fa fa-times" ></i> Branch Info Not Deleted !</p>');
             setTimeout(function()
                     {
                      window.location.reload();
                     },100);
         }
        });
        }
    e.preventDefault();
   }) 
  });

</script>
<?php 
  $this->load->view('includes/footer');
?>
