<?php 
  $this->load->view('includes/header');
  $this->load->view('includes/nav_header');
  $this->load->view('includes/sidebar_menu');
  $timezone = 'Asia/Dhaka';
  date_default_timezone_set($timezone);
  $branch_id = $this->session->userdata('branch_id');
?>
<style type="text/css">
  .bank{
  display: none;
}
</style>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header" >
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Create Collection</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <div class="res" style="text-align: center;font-weight: bold;"></div>
    <section class="content">
      <div class="container-fluid">
      <form method="POST" enctype="multipart/form-data" id="add_form">      
        <div class="row">
          <div class="card-body">
            <div class="row">
               <div class="col-md-4">
                <div class="form-group">
                  <label>Voucher Number</label>
                  <input type="text" placeholder="0.00" readonly="" class="form-control" value="<?= $code;?>">
                </div>                
              </div>
              
              <div class="col-md-4">
                <div class="form-group">
                  <label>Customer Name</label>
                  <select class="form-control select2" name="customer_id" id="customer_id">
                      <option value="">Select Customer</option>
                      <?php foreach($customers as $c):?>
                      <option value="<?= $c->id?>"> <?= $c->name?> <?= " ".$c->address?> <?= " ".$c->contact_no?> <?= " ".$c->nid?></option>
                      <?php endforeach;?>
                  </select>
                </div>                
              </div>
              <div class="col-md-4" style="display:none">
                <div class="form-group">
                  <label>Invoice Number</label>
                  <select class="form-control" name="invoice_number" id="invoice_number">
                   </select>
                </div>                
              </div>

              <div class="col-md-4">
                <div class="form-group">
                  <label>Previous Due</label>
                  <input type="text" name="previous_balance" placeholder="0.00" readonly="" class="form-control" required="true" id="previous_balance"style="font-weight: bold;font-size: 18px">
                </div>                
              </div>

              <div class="col-md-4">
                <div class="form-group">
                   <label>Payment Method</label>
                    <select class="form-control select2" style="width: 100%;height:30px" name="payment_method" id="payment_method" required="">
                      <option value="Cash">Cash</option>
                      <!-- <option value="Cheque">Cheque</option> -->
                      <option value="Bank">Bank</option>
                    </select>
                </div>                
              </div>
              <div class="col-md-4 bank bank_name">
                <div class="form-group">
                  <label>Bank Name</label>
                    <?php 
                      $combo_items = combobox_bind_branch('banks','id','name',$branch_id,'Bank');
                        echo form_dropdown('bank_id',$combo_items,'','class="form-control select2" id="bank_id" style="width: 100%;height:30px"');
                    ?>
                  </div>                
              </div> 

              <div class="col-md-4 bank_name" style="display: none">
                <div class="form-group">
                  <label>Bank Amount</label>
                  <input type="text" name="bank_amount" placeholder="0.00" id="bank_amn" class="form-control" style="border-radius: 0px;font-weight: bold;font-size: 18px">
                </div>               
              </div>

              <div class="col-md-4 bank">
                <div class="form-group">
                  <label>Check Number</label>
                  <input type="text" name="check_num" placeholder="xxx" id="check_num" class="form-control" style="border-radius: 0px">
                </div>                
              </div>  

             <div class="col-md-4 bank">
              <div class="form-group">
                <label>Check Amount</label>
                <input type="text" name="check_amount" placeholder="0.00" id="check_amn" class="form-control" style="border-radius: 0px;font-weight: bold;font-size: 18px">
              </div>               
            </div>

            <div class="col-md-4 bank">
              <div class="form-group">
                <label>Approve Date</label>
                <input type="date" name="check_appr_date" placeholder="xxx"  id="check_appr_date" class="form-control" style="border-radius: 0px">
              </div>              
            </div>
             <div class="col-md-4 ">
                <div class="form-group">
                  <label>Discount</label>
                  <input type="text" name="discount" placeholder="0.00" id="discount" class="form-control" style="border-radius: 0px;font-weight: bold;font-size: 18px">
                </div>               
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>Cash Paid</label>
                  <input type="text" name="paid" placeholder="Enter Amount" id="paid" class="form-control" required="true" style="font-weight: bold;font-size: 18px">
                </div>                
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>Balance</label>
                  <input type="text" name="balance" placeholder="0.00" readonly="" id="balance" class="form-control" required="true" style="font-weight: bold;font-size: 18px">
                </div>                
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>Comment</label>
                  <input type="text" name="comment" placeholder="Enter comment" id="comment" class="form-control"  style="font-weight: bold;font-size: 18px">
                </div>                
              </div>
              <!-- /.col -->
              <div class="col-md-4">
                  <div class="form-group">
                     <label>Date</label>
                    <input type="text" name="date" value="<?= date('Y-m-d');?>" class="form-control" required="true" onfocus="this.type='date'" onfocusout="this.type='text'">
                  </div>
              </div>
              <!-- /.col -->
            </div>
            <!-- /.row -->
          </div>
        </div>
        <div class="card-footer" style="text-align: center;">
          <button type="reset" class="btn btn-danger">Reset</button>
          <button type="submit" name="submit" class="btn btn-info">Submit</button>
        </div>
      </form>
      </div>
    </section>
  </div>
<script type="text/javascript">
  $(document).ready(function(){
    $("#payment_method").on("change",function(){
      var met = $(this).val();
      if(met == 'Cheque'){
        $('.bank').show();
        $('.bank_name').show();
        $('#paid').attr('readonly','readonly');
      }
      else if(met == 'Bank'){
        $('.bank').hide();
        $('.bank_name').show();
        $('#paid').attr('readonly','readonly');  
      }else{
        $('.bank').hide();
        $('.bank_name').hide();
        $('#paid').removeAttr('readonly','readonly');
      }

    });
    $('#name').focus();
    $('#customer_id').on('change',function(){
        var customer_id = $(this).val();
        $.ajax({
             type:'post',
             url : '<?= base_url("collection/info")?>',
             data:{customer:customer_id},             
             success:function(res){
                // alert(res);
              if(res){
                  var info = res.split('##');
                      var bal = info[0];
                      var pbal = info[1];
                      
                  $('#previous_balance').val(bal);
                  
               }
              }
      });
    });
    function invoices(customer_id){
      
      $.ajax({
             type:'post',
             url : '<?= base_url("collection/inv")?>',
             data:{customer:customer_id},  
             dataType: 'json',           
             success:function(res){
              if(res){
                    $("#invoice_number").empty();
                    $("#invoice_number").append('<option value="">Select Invoice</option>');
                    $.each(res,function(index,val){
                        $("#invoice_number").append('<option value="'+index+'">'+index+'</option>');
                    });
               }
               else{
                $("#invoice_number").empty();
               }
              }
      });
    }


    
    $('#paid').on('keyup',function(e){
        var paid = parseInt($("#paid").val()) || 0;
        var discount = parseInt($("#discount").val()) || 0;
        var bank_amn = parseInt($("#bank_amn").val()) || 0;
        var previous_balance  = parseInt($('#previous_balance').val()) || 0  ;
        var balance = previous_balance - paid - discount - bank_amn;
        $('#balance').val(balance);
        
    });
    $('#discount').on('keyup',function(e){
        var paid = parseInt($("#paid").val()) || 0;
        var discount = parseInt($("#discount").val()) || 0;
        var bank_amn = parseInt($("#bank_amn").val()) || 0;
        var previous_balance  = parseInt($('#previous_balance').val()) || 0  ;
        var balance = previous_balance - paid - discount - bank_amn;
        $('#balance').val(balance);
        
    });
    $('#bank_amn').on('keyup',function(e){
        var paid = parseInt($("#paid").val()) || 0;
        var discount = parseInt($("#discount").val()) || 0;
        var bank_amn = parseInt($("#bank_amn").val()) || 0;
        var previous_balance  = parseInt($('#previous_balance').val()) || 0  ;
        var balance = previous_balance - paid - discount - bank_amn;
        $('#balance').val(balance);
        
    });
    
    $('#add_form').on('submit',function(e){
      $.ajax({
             type:'post',
             url : '<?= base_url("collection/create")?>',
             data:new FormData(this),
             processData:false,
             contentType:false,
             cache:false,
             async:false,
             
             success:function(res){
             
              $("html, body").animate({ scrollTop: 0 }, 150);
              if(res != 0){

                  var domain = "<?= base_url();?>";
               $('.res').html('<i class="fa fa-check" style="color:green;font-size:24px;"></i> Collection Created Successfully');
                 
              }

              else if(res == 0)
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> Customer Name Not Created'); 
              else
                $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> '+res+' Customer Name  Aleady Existed');
             setTimeout(function(){
               location.reload();
             },200);
             }
      });
       e.preventDefault();
    });
  });
</script>
<?php 
  $this->load->view('includes/footer');
?>