<?php 
  $this->load->view('includes/header');
  $this->load->view('includes/nav_header');
  $this->load->view('includes/sidebar_menu');
  $timezone = 'Asia/Dhaka';
  date_default_timezone_set($timezone);
  $branch_id = $this->session->userdata('branch_id');
?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header" >
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Update Customer</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <div class="res" style="text-align: center;font-weight: bold;"></div>
    <section class="content">
      <div class="container-fluid">
      <form method="POST" enctype="multipart/form-data" id="add_form">      
        <div class="row">
          <div class="card-body">
            <div class="row">
              <div class="col-md-6" style="float: left;display: none;">
                <label>Salesman Name</label>
              <?php 
                $combo_items = combobox_bind_branch_row('salesmans','id','name',$branch_id,'Salesman');
                  echo form_dropdown('salesman',$combo_items,$customer->salesman,'class="form-control select2" id="salesman" ');
              ?>
            </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Customer Name</label>
                  <input type="text" name="name" placeholder="Enter Name" class="form-control" value="<?= $customer->name?>" required="true">
                   <input type="hidden" name="id" placeholder="Enter Name" class="form-control" value="<?= $customer->id?>" required="true">
                </div>                
              </div>
              
              <div class="col-md-6">
                <div class="form-group">
                  <label>Customer Address</label>
                  <input type="text" name="address" placeholder="Enter Name" class="form-control" value="<?= $customer->address?>" >
                </div>                
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Contact No</label>
                  <input type="text" name="contact_no" placeholder="Enter Name" class="form-control" value="<?= $customer->contact_no?>" >
                </div>                
              </div>
               
              <div class="col-md-6">
                <div class="form-group">
                  <label>Previous Balance</label>
                  <input type="text" name="previous_balance" placeholder="Enter Name" value="<?= $customer->previous_balance?>" class="form-control" >
                </div>                
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label> Balance</label>
                  <input type="text" name="balance" placeholder="Enter Name" value="<?= $customer->balance?>" class="form-control" >
                </div>                
              </div>
              <div class="col-md-6">
                <div class="form-group">
                <label for="exampleInputFile">Logo</label>
                <div class="input-group">
                  <div class="custom-file">
                    <input type="file" name="userfile" class="custom-file-input" id="exampleInputFile" >
                    <label class="custom-file-label" for="exampleInputFile">Choose file</label>
                  </div>
                </div>
              </div>
              <img src="<?= base_url($customer->logo);?>" style="height: 100px;width:100px">
              </div>
              <div class="col-md-6" style="display: none;">
                  <div class="form-group">
                     <label>Date</label>
                    <input type="text" name="date" value="<?= $customer->date?>" class="form-control" required="true" onfocus="this.type='text'" onfocusout="this.type='date'">
                  </div>
              </div>
              <!-- /.col -->
            </div>
            <!-- /.row -->
          </div>
        </div>
        <div class="card-footer" style="text-align: center;">
          <button type="reset" class="btn btn-danger">Reset</button>
          <button type="submit" name="submit" class="btn btn-info">Submit</button>
        </div>
      </form>
      </div>
    </section>
  </div>
<script type="text/javascript">
  $(document).ready(function(){
    $('#add_form').on('submit',function(e){
      $.ajax({
             type:'post',
             url : '<?= base_url("customer/update")?>',
             data:new FormData(this),
             processData:false,
             contentType:false,
             cache:false,
             async:false,
             
             success:function(res){
              $("html, body").animate({ scrollTop: 0 }, 150);
              if(res == 1)
               $('.res').html('<i class="fa fa-check" style="color:green;font-size:24px;"></i> customer Name Updated Successfully');
              else if(res == 0)
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> customer Name Not Updated'); 
              else
                $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> '+res+' customer Name  Aleady Existed');
             setTimeout(function(){
               location.href='<?=base_url("customer_manage")?>';
             },200);
             }
      });
       e.preventDefault();
    });
  });
</script>
<?php 
  $this->load->view('includes/footer');
?>