<?php 
  $this->load->view('includes/header');
  $this->load->view('includes/nav_header');
  $this->load->view('includes/sidebar_menu');
?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header" >
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Update Branch</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <div class="res" style="text-align: center;font-weight: bold;"></div>
    <section class="content">
      <div class="container-fluid">
      <form method="POST" enctype="multipart/form-data" id="add_form">      
        <div class="row">
          <div class="card-body">
            <div class="row">
              
              <div class="col-md-6">
                <div class="form-group">
                  <label>Branch Name</label>
                  <input type="text" name="name" placeholder="Enter Name" class="form-control" value="<?= $branch->name;?>" required="true">
                  <input type="hidden" name="id" placeholder="Enter Name" class="form-control" value="<?= $branch->id;?>" required="true">
                </div>
               
                 <div class="form-group">
                  <label>Address</label>
                  <input type="text" name="address" placeholder="Enter Address" class="form-control" value="<?= $branch->address;?>" required="true">
                </div>
                 <div class="form-group">
                  <label>Date</label>

                  <div class="input-group">
                    <div class="input-group-prepend">
                      <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                    </div>
                    <input type="text" class="form-control" value="<?= $branch->date;?>" onfocus="this.type='date'" onfocusout="this.type='text'" name="date">
                  </div>
                  <!-- /.input group -->
                </div>
                <!-- /.form-group -->
              </div>
              <!-- /.col -->
              <div class="col-md-6">
                <div class="form-group">
                  <label>Contact No</label>
                  <div class="input-group">
                  <div class="input-group-prepend">
                      <span class="input-group-text"><i class="fa fa-phone"></i></span>
                    </div>
                  <input type="text" name="contact_no" value="<?= $branch->contact_no;?>" placeholder="Enter Contact No" class="form-control" required="true">
                  </div>
                </div>
                <!-- /.form-group -->
                  <div class="form-group">
                    <label>Status</label>
                    <select class="form-control select2" style="width: 100%;height:30px" name="status">
                      <option value="1">Active</option>
                       <option value="0">Inactive</option>
                    </select>
                  </div>
                  <div class="form-group">
                    <label for="exampleInputFile">Logo</label>
                    <div class="input-group">
                      <div class="custom-file">
                        <input type="file" name="userfile" class="custom-file-input" id="exampleInputFile" >
                        <label class="custom-file-label" for="exampleInputFile">Choose file</label>
                      </div>
                      <br><br>                     
                    </div>
                    <img src="<?= base_url($branch->logo);?>" style="height: 100px;width:100px">
                  </div>
                <!-- /.form-group -->
              </div>
              <!-- /.col -->
            </div>
            <!-- /.row -->
          </div>
        </div>
        <div class="card-footer" style="text-align: center;">
          <button type="reset" class="btn btn-danger">Reset</button>
          <button type="submit" name="submit" class="btn btn-info">Update</button>
        </div>
      </form>
      </div>
    </section>
  </div>
<script type="text/javascript">
  $(document).ready(function(){
    $('#add_form').on('submit',function(e){

      $.ajax({
             type:'post',
             url : '<?= base_url("branch/update")?>',
             data:new FormData(this),
             processData:false,
             contentType:false,
             cache:false,
             async:false,
             
             success:function(res){
              
              $("html, body").animate({ scrollTop: 0 }, 150);
              if(res == 1)
               $('.res').html('<i class="fa fa-check" style="color:green;font-size:24px;"></i> Branch Created Successfully');
              else if(res == 0)
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> Branch Not Created'); 
              else if(res == 2)
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> File Already Existed'); 
              else if(res == 'f_t')
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> File Type Not Suported');
              else if(res == 'f_s')
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> File Size Too Large');
              else if(res == 'n_p')
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> File Not Uploaded');
              else
                $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> '+res+' Branch Name Aleady Existed');
             setTimeout(function(){
               location.href='<?= base_url('branch_manage')?>';
             },200);
             }
      });
       e.preventDefault();
    });
  });
</script>
<?php 
  $this->load->view('includes/footer');
?>