<?php 
  $this->load->view('includes/header');
  $this->load->view('includes/nav_header');
  $this->load->view('includes/sidebar_menu');
  $timezone = 'Asia/Dhaka';
  date_default_timezone_set($timezone);
  $branch_id = $this->session->userdata('branch_id');
?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header" >
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Update Monthly Salary</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <div class="res" style="text-align: center;font-weight: bold;"></div>
    <section class="content">
      <div class="container-fluid">
      <form method="POST" enctype="multipart/form-data" id="add_form">      
        <div class="row">
          <div class="card-body">
            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                  <label>Employee Name</label>
                  <?php 
                  $combo_items = combobox_bind_branch_row('employees','id','name',$branch_id,'Employee');
                    echo form_dropdown('employee_id',$combo_items,$mns->employee_id,'class="form-control select2" id="employee_id" required="true"');
                ?>
                </div>                
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>Day</label>
                  <input type="text" name="day" placeholder="Enter Day" class="form-control" value="<?= $mns->day?>" required="true" autocomplete="off">
                  <input type="hidden" name="id" placeholder="Enter Day" class="form-control" value="<?= $mns->id?>" required="true" autocomplete="off">
                </div>                
              </div>
              <div class="col-md-4">
                  <div class="form-group">
                     <label>Date</label>
                    <input type="text" name="date" value="<?= $mns->date;?>" class="form-control" required="true" onfocus="this.type='date'" onfocusout="this.type='text'">
                  </div>
                <!-- /.form-group -->
              </div>
              <!-- /.col -->
            </div>
            <!-- /.row -->
          </div>
        </div>
        <div class="card-footer" style="text-align: center;">
          <button type="reset" class="btn btn-danger">Reset</button>
          <button type="submit" name="submit" class="btn btn-info">Submit</button>
        </div>
      </form>
      </div>
    </section>
  </div>
<script type="text/javascript">
  $(document).ready(function(){
    $('#name').focus();
    $('#add_form').on('submit',function(e){
      $.ajax({
             type:'post',
             url : '<?= base_url("mns/update")?>',
             data:new FormData(this),
             processData:false,
             contentType:false,
             cache:false,
             async:false,
             
             success:function(res){
               //  alert(res);
              $("html, body").animate({ scrollTop: 0 }, 150);
              if(res == 1)
               $('.res').html('<i class="fa fa-check" style="color:green;font-size:24px;"></i> Brand Name Created Successfully');
              else if(res == 0)
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> Brand Name Not Created'); 
              else
                $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> '+res+' Brand  Name Aleady Existed');
             setTimeout(function(){
             location.href='<?= base_url('mns_manage')?>';
             },50);
             }
      });
       e.preventDefault();
    });
  });
</script>
<?php 
  $this->load->view('includes/footer');
?>