<?php 
  $this->load->view('includes/header');
  $this->load->view('includes/nav_header');
  $this->load->view('includes/sidebar_menu');
  $timezone = 'Asia/Dhaka';
  date_default_timezone_set($timezone);
?>
<style type="text/css">
  #table-div{
    width: 100%;
    height:350px;
    overflow: scroll;
  }
  #table-div-right{
    width: 100%;
    height:350px;
    overflow-y: scroll;
  }
  .table-striped tbody tr {
    background-color: #8EAFCA !important;
  }
  #payments-css{
      text-align: center;
      color: #ffffff;
      background: #00758f;
      padding: 10px;
      width: 100%
  }
 .dataTables_empty{
  display: none !important;
 }
 .pagination{
   display: none !important;
 }
 #example2_info{
   display: none !important;
 }
 #example2_filter{
  display: none !important;
 }
 #example2_length{
  display: none !important;
 }
 #namelist{
 position: absolute;
  z-index: 1;
  width:96%;
 
 }
 #namelist ul {
  border-radius: 5px;
  background: #fff;
  font-size: 16px;
  cursor: pointer;
  font-weight: 550;
  padding: 3px 10px;
  color: #000;
  box-shadow : inset 0 0 1px #000000;
}
#namelist ul li{
  list-style: none;
  padding: 5px;
  cursor: pointer;
}
#namelist ul li:hover{
  background: #e0e0e07a;
  cursor: pointer;
  border-radius: 3px;
}
#example2 .select2-container--default .select2-selection--single {
    background-color: #8eafca !important;
}
.bank{
  display: none;
}
input:read-only { 
  cursor:  not-allowed;
}
</style>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper" style="overflow-y: hidden;">
    <!-- Content Header (Page header) -->
    <div class="content-header" >
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Purchase Product</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>

    <div class="res" style="text-align: center;font-weight: bold;"></div>
    <section class="content">
      <div class="container-fluid">
        <div class="card-body">
          <form id="cusSupForm">
            <div class="row">
                <div class="col-md-4">
                <div class="form-group">
                  <label>Supplier Name</label>
                  <select class="form-control select2" style="width: 100%;height:30px" name="supplier_id" required="" id="supplier_id">
                    <option value="">Select Supplier</option>
                    <?php foreach($suppliers as $supplier):?>
                    <option value="<?= $supplier->id?>"><?= $supplier->name?> <?= " ".$supplier->address?> <?= " ".$supplier->contact_no?></option>
                    <?php endforeach; ?>
                  </select>
                </div>
                </div>
                <div class="col-md-2">
                <div class="form-group">
                  <label>Old Due</label>
                  <input type="text"  placeholder="0.00"  class="form-control" readonly="readonly" id="previous_balance">
                </div>
                </div>
                <div class="col-md-2"></div>
                <div class="col-md-2">
                <div class="form-group">
                  <label>Invoice Number</label>
                  <input type="text"  placeholder="Invoice Number"  class="form-control"  name="invoice_number">
                </div>
                </div> 
                <div class="col-md-2">
                <div class="form-group">
                  <label>Date</label>
                  <div class="input-group">
                    <div class="input-group-prepend">
                      <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                    </div>
                    <input type="text" onfocus="this.type='date'" onfocusout="this.type='text'" value="<?= date('Y-m-d');?>" id="date" class="form-control" name="date">
                  </div>
                </div>
              </div> 
             </div>
          </form>
          <br>
          <form id="product_form">  
            <div class="row">              
              <div class="col-md-4">
                <div class="form-group">
                  <label>Product Name &nbsp;&nbsp;<a id="ime_btn"  data-toggle="modal" data-target="#myModal" style="color:green;cursor:pointer">Add IMEI</a></label>
                  <input type="text" name="name" placeholder="Enter Name" id="name" class="form-control"   required="true" autocomplete="off" >
                   <input type="hidden" name="hidden_instock" class="form-control" required="true" id="hidden_instock" >
                   <input type="hidden" class="form-control" required="true" id="product_id" >
                   <div id="namelist"></div>
                </div>              
              </div>
              
              
              <div class="col-md-2">
                <div class="form-group">
                  <label>Quantity</label>
                  <input type="text" name="quantity" placeholder="0.00" id="qty" class="form-control" required="true" onkeyup="calculate.call(this);">
                </div>
              </div>
               <div class="col-md-2">
                <div class="form-group">
                  <label>Unit Price</label>
                  <input type="text" name="cost_price" placeholder="0.00" id="unit_price" class="form-control" required="true" onkeyup="calculate.call(this);" >
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group">
                  <label>Transport price</label>
                  <input type="text" name="poribahan" placeholder="0.00" id="poribahan" class="form-control" required="true" onkeyup="calculate.call(this);">
                  <input type="hidden"  placeholder="0.00" id="trns" class="form-control" required="true" >
                </div>
              </div>
               <div class="col-md-2">
                <div class="form-group">
                  <label>Total Price</label>
                  <input type="text" name="total_price" placeholder="0.00" class="form-control" id="total_price" required="true" readonly="">
                  <input type="hidden" name="size" placeholder="Enter Unit" id="size" class="form-control" value="PICS" required="true" readonly="">
                  <input type="hidden" id="instock" name="instock" placeholder="0.00" class="form-control" required="true" readonly="">
                  <input type="hidden" name="low_stock" placeholder="0.00" id="low_stock" class="form-control">
                  <input type="hidden" name="note" placeholder="Enter Note" id="note" class="form-control">
                  <input type="hidden" name="warranty" value="<?= date("Y-m-d");?>" id="warranty" class="form-control">
                </div>
              </div>
               <div class="col-md-2">
                <div class="form-group">
                  <label>Sale Price</label>
                  <input type="text" name="sale_price" placeholder="0.00" id="sale_price" class="form-control" required="true" onkeyup="calculate.call(this);">
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group">
                  <label>WholeSale Price</label>
                  <input type="text" name="wsale_price" placeholder="0.00" id="wsale_price" class="form-control" required="true" onkeyup="calculate.call(this);">
                  <input type="hidden"  placeholder="0.00" id="brand" class="form-control"  >
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>Shop & Deppriciation </label>
                  <select class="form-control select2" id="fixed_head" style="width: 100%;height:30px" >
                      <option value="">Select Head</option>
                      <?php foreach($asset_heads as $category):?>
                        <option value="<?= $category->id?>"><?= $category->name?></option>
                      <?php endforeach;?>
                  </select>
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group">
                  <label>Comment </label>
                  <input type="text" placeholder="Enter Comment" id="comment" class="form-control" >
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group">
                  <label>Amount </label>
                  <input type="text" placeholder="0.00" id="fixed_cost" class="form-control" >
                </div>
              </div>
              <div class="col-md-5">
                <div class="form-group">
                  <label>Pending Item</label>
                  <select class="form-control select2" id="pending_item" style="width: 100%;height:30px"  >
                      
                  </select>
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group">
                  <label>Warranty Voucher</label>
                  <input type="text" placeholder="Enter ID" id="warranty_ref" class="form-control" >
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group">
                  <label>Warranty Qty</label>
                  <input type="text" placeholder="0.00" id="warranty_qty" class="form-control" >
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group">
                  <label>Warranty Price</label>
                  <input type="text" placeholder="0.00" id="warranty_price" class="form-control" >
                </div>
              </div>
              
              
              <div class="col-md-3">
                <div class="form-group">
                  <label>Category Name</label>
                  <select class="form-control select2" id="category" style="width: 100%;height:30px" name="category_id" >
                      <option value="">Select Category</option>
                      <?php foreach($categories as $category):?>
                        <option value="<?= $category->id?>"><?= $category->name?></option>
                      <?php endforeach;?>
                  </select>
                </div>
              </div>
             
              
                             
            </div>
          </form>
          <div class="modal" id="myModal">
            <div class="modal-dialog">
              <div class="modal-content">
                <!-- Modal Header -->
                <div class="modal-header">
                  <h4 class="modal-title">Add IMEI <span title="Add Row" id="add_row_modal" style="color:green" >+</span></h4>
                </div>
                <!-- Modal body -->
                <div class="modal-body">
                  <form id="ime_form" onsubmit="return false;">
                    <table id="ime_tbl" class="table table-bordered">
                      <thead>
                        <tr>
                          <th class="text-center">*</th>
                          <th class="text-center">IMEI</th>
                          <th class="text-center">Qty</th>
                          <th class="text-center">Action</th>
                        </tr>
                      </thead>
                      <tbody>  
                        <tr >
                          <td class="text-center">1</td>
                          <td class="text-center"><input type="text" name="ime[]" class="form-control ime_number" placeholder="Enter IMEI" style="border-radius: 0px" autocomplete="off"></td>
                          <td class="text-center"><input type="text" name="ime_qty[]" class="form-control ime_qty" placeholder="Enter Qty" style="border-radius: 0px" autocomplete="off" value="1"></td>
                          <td class="text-center"><a id="remCF" class="btn btn-sm ibtnDelIme"><i class="fa fa-trash" style="color:red"></i></a></td>
                        </tr>                   
                      </tbody>  
                    </table> 
                  </form>
                </div>
                <!-- Modal footer -->
                <div class="modal-footer">
                  <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                </div>
              </div>
            </div>
          </div>    

          
           <a class="btn btn-info" id="add">Add List</a>    
            <form method="POST" id="add_form">
            <div class="row">
              <div class="col-md-12">
                <div id="table-div">
                  <table id="example2" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th class="text-center">*</th>
                      <th class="text-center">Product Name</th>
                      <th class="text-center">Unit</th>
                      <th class="text-center">Category</th>
                      <th class="text-center">Qty</th>
                      <th class="text-center">Unit Price</th>
                      <th class="text-center">Sale Price</th>
                      <th class="text-center">Total Price</th>
                      <th class="text-center">Warranty Qty</th>
                      <th class="text-center">Warranty Price</th>
                      <th class="text-center">Fixed Amount</th>
                      <th class="text-center">Low</th>
                      <th class="text-center">Instock</th>
                      <th class="text-center">Action</th>
                    </tr>
                    </thead>
                    <tbody>
                      <?php 
                        $tp = 0;
                      if($floats):
                        $i = 1;
                        $tp = 0;
                      foreach($floats as $float):?>
                     <tr>
                       <td style="text-align: center;"><?= $i;?></td>
                       <td><input type="text" name="name[]" class="form-control name"  readonly="true" value="<?= $float->name?>" style="background:none;border-radius:0px"  required="true"/></td>
                        <td>
                          <input type="text" name="size[]" placeholder="Enter Size" class="form-control size" value="<?= $float->size?>"  style="background:none;border-radius:0px">
                        </td>
                       <td><select class="form-control select2 cat" style="width: 100%;height:30px;background-color:none" name="category_id[]" ><?php foreach($categories as $cat):?>
                        <option value="<?= $cat->id?>" <?php if($float->category_id == $cat->id)echo "selected=selected";?>  ><?= $cat->name?></option><?php endforeach;?>
                        </select></td>
                        
                          <td><input type="text" name="quantity[]" class="form-control qty" readonly="true" value="<?= $float->quantity?>" style="background:none;border-radius:0px" onkeyup="calculator.call(this)" required="true"/><input type="hidden"  class="form-control hide_qty" name="hidden_qty" readonly="true" value="<?= $float->quantity?>" style="background:none;border-radius:0px"/></td>
                          <td><input type="text" name="cost_price[]" class="form-control up" readonly="true" value="<?= $float->cost_price?>" style="background:none;border-radius:0px" onkeyup="calculator.call(this)" required="true"/></td>
                          <td><input type="text" name="sale_price[]" class="form-control sp" readonly="true" value="<?= $float->sale_price?>" style="background:none;border-radius:0px" required="true"/></td>
                          <td><input type="text" name="total_price[]" class="form-control tp" readonly="true" value="<?= $float->total_price?>" style="background:none;border-radius:0px"/><input type="hidden" name="commision[]" class="form-control" readonly="true" value="0" style="background:none;border-radius:0px"/><input type="hidden" name="wsale_price[]" class="form-control" readonly="true" value="<?= $float->wsale_price?>" style="background:none;border-radius:0px"/><input type="hidden" name="poribahan[]" class="form-control" readonly="true" value="<?= $float->poribahan?>" style="background:none;border-radius:0px"/><input type="hidden" name="brand_id[]" class="form-control" readonly="true" value="<?= $float->brand_id?>" style="background:none;border-radius:0px"/><input type="hidden" name="note[]" class="form-control" readonly="true" value="<?= $float->note?>" style="background:none;border-radius:0px"/><input type="hidden" name="warranty[]" class="form-control" readonly="true" value="<?= $float->warranty?>" style="background:none;border-radius:0px"/></td>
                          <td><input type="text" name="low_stock[]" class="form-control low_stock" readonly="true" value="<?= $float->low_stock?>" style="background:none;border-radius:0px"/></td>
                          <td><input type="hidden" name="instock[]" class="form-control stock" readonly="true" value="<?= $float->instock?>" style="background:none;border-radius:0px"/><input type="text"  class="form-control hide_stock" name="hidden_instock[]" readonly="true" value="<?= $float->hidden_instock;?>" style="background:none;border-radius:0px"/></td>
                        
                          <td><a id="remCF" class="btn btn-sm ibtnUp"><i class="fa fa-pencil" style="color:#fff"></i></a> <a id="remCF" class="btn btn-sm ibtnDo" style="display:none;color:#fff" > <i class="fa fa-check" ></i></a> <a id="remCF" class="btn btn-sm ibtnDel"><i class="fa fa-trash" style="color:red"></i></a></td>
                     </tr>
                   <?php $i++;$tp += $float->total_price;endforeach;endif; ?>
                    </tbody>  
                    <tfoot>
                      <tr>
                        <td colspan="7"><b style="color:#05731eed">Total</b></td>
                        <td ><input type="text" readonly="true" name="total_amount" value="<?= $tp;?>" id="total_amount" placeholder="0.00" style="width:100px;background: #ececec;padding-left: 5px;height: 30px;text-align: center;;font-weight: bold;font-size: 18px"></td>
                        <td ></td>
                        <td ><input type="text" readonly="true" name="warranty_amount"  id="warranty_amount" placeholder="0.00" style="width:100px;background: #ececec;padding-left: 5px;height: 30px;text-align: center;;font-weight: bold;font-size: 18px"></td>
                        <td ><input type="text" readonly="true" name="fixed_amount"  id="fixed_amount" placeholder="0.00" style="width:100px;background: #ececec;padding-left: 5px;height: 30px;text-align: center;;font-weight: bold;font-size: 18px"></td>
                      </tr>
                    </tfoot>
                  </table>
                </div>
              </div>
              <div class="col-md-12" >
              <div class="row" >
                

                
                
                
                
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Discount</label>
                    <input type="text" name="discount" placeholder="0.00"  id="discount" class="form-control" onkeyup="finalCalculator()" style="border-radius: 0px">
                     <input type="hidden" name="chalan_no" placeholder="xxx" class="form-control" style="border-radius: 0px"  >
                  </div>
                </div>
                
                
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Cash Paid</label>
                    <input type="text" name="cash_paid" placeholder="0.00" id="cash_paid" class="form-control" onkeyup="finalCalculator()" style="border-radius: 0px;font-weight: bold;font-size: 18px">
                  </div>
                </div>
                
                
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Transport Amount</label>
                   
                    <input type="text" name="transport" placeholder="0.00" id="transport"  class="form-control" style="border-radius: 0px;font-weight: bold;font-size: 18px" readonly="" required="">
                  </div>
                </div>
                
                
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Due Amount</label>
                    <input type="text" name="due" placeholder="0.00" id="due" value="<?= $tp;?>" class="form-control" style="border-radius: 0px;font-weight: bold;font-size: 18px" readonly="" required="">
                    
                  </div>
                </div>
                
                
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Payment Method</label>
                      <select class="form-control select2" style="width: 100%;height:30px" name="payment_method" id="payment_method" required="">
                        <option value="Cash">Cash</option>
                        <option value="Due">Dues</option>
                        <option value="Cheque">Cheque</option>
                      </select>
                  </div>
                </div>
                
                
                
                <div class="col-md-3 bank">
                  <div class="form-group">
                    <label>Bank Name</label>
                    <select class="form-control select2" style="width: 100%;height:30px" name="bank_id" >
                        <option value="">Select Bank</option>
                        <?php foreach($banks as $bank):?>
                        <option value="<?= $bank->id?>"><?= $bank->name?></option>
                        <?php endforeach; ?>
                      </select>
                  </div>
                </div>
                
                
                <div class="col-md-3 bank">
                  <div class="form-group">
                    <label>Check Number</label>
                    <input type="text" name="check_num" placeholder="xxx" id="check_num" class="form-control" style="border-radius: 0px">
                  </div>
                </div>
                
                
                <div class="col-md-3 bank">
                  <div class="form-group">
                    <label>Check Amount</label>
                    <input type="text" name="check_amount" placeholder="0.00" id="check_amn" class="form-control" style="border-radius: 0px" onkeyup="finalCalculator()">
                  </div>
                </div>
                
                
                <div class="col-md-3 bank">
                  <div class="form-group">
                    <label>Approve Date</label>
                    <input type="date" name="check_appr_date" placeholder="xxx"  id="check_appr_date" class="form-control" style="border-radius: 0px">
                  </div>
                </div>
                </div>

              </div>
            </div>
            <div class="card-footer" style="text-align: center;margin-bottom: 10px;">
              <button type="reset" class="btn btn-danger">Reset</button>
              <button type="button" onclick="this.type='submit'" class="btn btn-info">Submit</button>
            </div>
          </form>
        </div>
      </div>
    </section>
  </div>
<script type="text/javascript">
       
   $(document).ready(function(){        
  $( "#name" ).autocomplete({
      //source: availableTags
      source: function (request, response) {
      $.ajax({
                    type: 'get',
                    url: '<?= base_url("product/auto")?>',
                    dataType: "json",
                    data: {
                        term: request.term,
                    },
                    success: function (data) {
                      
                        response(data);
                    }
                });
            },
    
            select: function (event, ui) {
              var dtt = ui.item.label;
              var dt = dtt.split("} ");
              var name = dt[1];
               // alert(name);
               $.ajax({
                    type: 'post',
                    url: '<?= base_url("auto/product")?>',
                    data: {name:name},
                     success: function (data) {
                       
                      var res = data.split('##');                 
                var stock = res[0];
                var price = res[1];
                var cost = res[2];
                var id = res[3];
                var size = res[4];
                var cat = res[5];
                var low = res[6];
                var commision = res[7];
                var brand_id = res[8];
                var name = res[11];
                $('#name').val(name);
                $('#product_id').val(id);
              $('#instock').val(parseFloat(stock));
              $('#hidden_instock').val(parseFloat(stock));
              $('#unit_price').val(parseFloat(cost));
              $('#sale_price').val(parseFloat(price));
              $('#low_stock').val(parseFloat(low));
              $('#qty').val(stock);
              $('#size').val(size);
              $('#wsale_price').val(commision);
               
              $('#note').val(res[9]);
              calculate();
              $("#brand").val(brand_id).trigger('change');
              $(" #category > option").each(function() {
                 var ct = this.value;
                 if(ct == cat){
                  document.getElementById("category").value=cat;
                 } 
                });
              $('.select2').select2();

                    }

                });
               
            }
    });
    });
    
    
    function  add_in_table(code){
           
            $.ajax({
                    type: 'post',
                    url: '<?= base_url("Product/barcode_data")?>',
                    data: {name:code},
                     success: function (data) {
                         //add_in_table(data);
                     // alert(data);
                     $('#qty').focus();
                      var res = data.split('##');                 
                var stock = res[0];
                var price = res[1];
                var cost = res[2];
                var id = res[3];
                var size = res[4];
                var cat = res[5];
                var low = res[6];
                var commision = res[7];
                var brand_id = res[8];
                var name = res[11];
                $('#name').val(name);
                $('#product_id').val(id);
              $('#instock').val(parseFloat(stock));
              $('#hidden_instock').val(parseFloat(stock));
              $('#unit_price').val(parseFloat(cost));
              $('#sale_price').val(parseFloat(price));
              $('#low_stock').val(parseFloat(low));
              $('#qty').val(stock);
              $('#size').val(size);
              $('#wsale_price').val(commision);
               
              $('#note').val(res[9]);
              calculate();
              $("#brand").val(brand_id).trigger('change');
              $(" #category > option").each(function() {
                 var ct = this.value;
                 if(ct == cat){
                  document.getElementById("category").value=cat;
                 } 
                });
              $('.select2').select2();

                    }

                });
           event.preventDefault();
      return false;
       }
</script>
<script type="text/javascript">

$(document).ready(function(){
$('#name').focus();
      $('#supplier_id').on('change',function(){
        var supplier_id = $(this).val();
        invoices(supplier_id);
        $.ajax({
             type:'post',
             url : '<?= base_url("payment/info")?>',
             data:{supplier:supplier_id},             
             success:function(res){
              if(res){
                  var info = res.split('##');
                      var bal = info[0];
                      var pbal = info[1];
                  $('#previous_balance').val(bal);
                  $('#name').focus();
               }
              }
      });
    });
 // $('#name').focus();

  $('#name').on('keypress',function(e){
    if(e.which == 13) {
        var code = $("#name").val();
        add_in_table(code);    
    }
  });
 $('#add').on('click',function(e){
    //if(e.which == 13) {
        AddData();    
  //  }
  });
  $("#payment_method").on("change",function(){
      var met = $(this).val();
      if(met == 'Cheque')
        $('.bank').show();
      else
        $('.bank').hide();

  });
   $("#name").on('change',function(){
  $('#namelist').fadeOut();
   });
    
   $('#ime_form').on('keypress',function(e){
    if(e.which == 13) {
        addIme();    
    }
  });
  $('#add_row_modal').on('click',function(e){
        addIme();
  });
});
function checkAllName($name){
  $('#namelist').fadeOut();
 var now = $name;
 $('#example2 tbody tr').each(function ()
    {
      $(this).find('.name').each (function() {
        var pro_name = $(this).val();
        if(pro_name == now){
         // alert('This Name Already in List');
          // $(this).css('background','#f1967a');
          return false;
        }
      })
    }
  );
}
function addIme(){
  var rows = "";
  var newRow = $("<tr>");
  var cols = "";
  var i = 0;
  cols += '<td style="text-align: center;"></td>';
  cols += '<td class="text-center"><input type="text" name="ime[]" class="form-control ime_number" placeholder="Ime Number" style="border-radius: 0px" autofocus></td>';
  cols += '<td class="text-center"><input type="text" name="ime_qty[]" class="form-control ime_qty" placeholder="Qty" style="border-radius: 0px"  value="1"></td>';
  cols += '<td class="text-center"><a id="remCF" class="btn btn-sm ibtnDelIme"><i class="fa fa-trash" style="color:red"></i></a></td>';   
  newRow.append(cols);          
  $("#ime_tbl tbody").append(newRow);
  sli();
  var last = $('#ime_tbl tr:last');
  last.find('.ime_number').focus();
  event.preventDefault();   
  
}
function AddData() {
   
    $('#add').attr('disabled',true);
    var name = document.getElementById("name").value;
    var cat = $("#category").val();
    var brand_id = $("#brand").val();
    var size = $("#size").val();
    var unit_price = document.getElementById("unit_price").value;
    var qty = document.getElementById("qty").value;
    var low = document.getElementById("low_stock").value;
    var sale_price = document.getElementById("sale_price").value;
    var total_price = document.getElementById("total_price").value;
    var instock = document.getElementById("instock").value;
    var date = document.getElementById("date").value;
    var note = document.getElementById("note").value;
    var warranty = document.getElementById("warranty").value;
    var poribahan = document.getElementById("poribahan").value;
    var wsale_price = document.getElementById("wsale_price").value;
    var trns = document.getElementById("trns").value;
    var product_id = document.getElementById("product_id").value;
    var fixed_cost = document.getElementById("fixed_cost").value;
    var fixed_head = document.getElementById("fixed_head").value;
    var warranty_qty = document.getElementById("warranty_qty").value;
    var warranty_price = document.getElementById("warranty_price").value;
    var warranty_ref = document.getElementById("warranty_ref").value;
    var comment = document.getElementById("comment").value;
    var commision = 0;
    
   
    if(name == ''){
        alert('Name Cant be Empty');
        return false;
    }else if(qty == ''){
       alert('Quantity Cant be Empty');
       return false;
    }
    else if(unit_price == ''){
       alert('Unit Price Cant be Empty');
       return false;
    }
    else if(sale_price == ''){
       alert('Sale Price Cant be Empty');
       return false;
    }
    else if(date == ''){
       alert('Date Cant be Empty');
       return false;
    }
   
    else {

        var rows = "";
        var newRow = $("<tr>");
        var cols = "";
        var i = 0;
      cols += '<td style="text-align: center;"></td>';
      cols += '<td><input type="text" name="name[]" class="form-control name"  readonly="true" value="'+name+'" style="background:none;border-radius:0px"  required="true"/><input type="hidden" name="warranty[]" class="form-control warranty"  readonly="true" value="'+warranty+'" style="background:none;border-radius:0px"  required="true"/><input type="hidden" name="product_id[]" class="form-control product_id"  readonly="true" value="'+product_id+'" style="background:none;border-radius:0px"  required="true"/></td>';
      cols += '<td><input type="text" name="size[]" placeholder="Enter Size" class="form-control size"   value="'+size+'" style="background:none;border-radius:0px"><input type="hidden" name="brand_id[]" placeholder="Enter Size" class="form-control brand_id"   value="'+brand_id+'" style="background:none;border-radius:0px"><input type="hidden" name="commision[]" placeholder="Enter commision" class="form-control commision" value="'+commision+'" style="background:none;border-radius:0px"><input type="hidden" name="note[]" placeholder="Enter commision" class="form-control note" value="'+note+'" style="background:none;border-radius:0px"><input type="hidden" name="poribahan[]" placeholder="Enter poribahan" class="form-control poribahan" value="'+poribahan+'" style="background:none;border-radius:0px"><input type="hidden" name="wsale_price[]" placeholder="Enter poribahan" class="form-control wsale_price" value="'+wsale_price+'" style="background:none;border-radius:0px"></td>';
      cols += '<td><select class="form-control select2 cat" style="width: 100%;height:30px;background-color:none" name="category_id[]" ><?php foreach($categories as $cat):?>
        <option value="<?= $cat->id?>"  ><?= $cat->name?></option><?php endforeach;?>
        </select></td>';
      cols += '<td><input type="text" name="quantity[]" class="form-control qty" readonly="true" value="'+qty+'" style="background:none;border-radius:0px" onkeyup="calculator.call(this)" required="true"/><input type="hidden"  class="form-control hide_qty" name="hidden_qty" readonly="true" value="'+qty+'" style="background:none;border-radius:0px"/><input type="hidden"  class="form-control trns"  readonly="true" value="'+trns+'" style="background:none;border-radius:0px"/></td>';
      cols += '<td><input type="text" name="cost_price[]" class="form-control up" readonly="true" value="'+unit_price+'" style="background:none;border-radius:0px" onkeyup="calculator.call(this)" required="true"/></td>';
      cols += '<td><input type="text" name="sale_price[]" class="form-control sp" readonly="true" value="'+sale_price+'" style="background:none;border-radius:0px" required="true"/></td>';
      cols += '<td><input type="text" name="total_price[]" class="form-control tp" readonly="true" value="'+total_price+'" style="background:none;border-radius:0px"/></td>';
      cols += '<td><input type="text" name="warranty_qty[]" class="form-control warranty_qty" readonly="true" value="'+warranty_qty+'" style="background:none;border-radius:0px"/></td>';
      cols += '<td><input type="text" name="warranty_price[]" class="form-control warranty_price" readonly="true" value="'+warranty_price+'" style="background:none;border-radius:0px"/><input type="hidden" name="warranty_ref[]" class="form-control warranty_ref" readonly="true" value="'+warranty_ref+'" style="background:none;border-radius:0px"/></td>';
      cols += '<td><input type="text" name="fixed_cost[]" class="form-control fixed_cost" readonly="true" value="'+fixed_cost+'" style="background:none;border-radius:0px"/><input type="hidden" name="fixed_head[]" class="form-control fixed_head" readonly="true" value="'+fixed_head+'" style="background:none;border-radius:0px"/></td>';
      cols += '<td><input type="text" name="low_stock[]" class="form-control low" readonly="true" value="'+low+'" style="background:none;border-radius:0px"/></td>';
      cols += '<td><input type="text" name="instock[]" class="form-control stock" readonly="true" value="'+instock+'" style="background:none;border-radius:0px"/><input type="hidden"  class="form-control hide_stock" name="hidden_instock[]" readonly="true" value="'+instock+'" style="background:none;border-radius:0px"/><input type="hidden"  class="form-control comment" name="comment[]" readonly="true" value="'+comment+'" style="background:none;border-radius:0px"/></td>';
      
      cols += '<td><a id="remCF" class="btn btn-sm ibtnUp"><i class="fa fa-pencil" style="color:#fff"></i></a> <a id="remCF" class="btn btn-sm ibtnDo" style="display:none;color:#fff" > <i class="fa fa-check" ></i></a> <a id="remCF" class="btn btn-sm ibtnDel"><i class="fa fa-trash" style="color:red"></i></a></td>';
       
      newRow.append(cols);  
           
      $("#example2 tbody").append(newRow);

      $(" .cat:last > option").each(function() {
         var ct = this.value;
         if(ct == cat){
           $(this).attr('selected', 'selected');
         } 
        });
      $('.select2').select2();
      save_float();     
      sl();   
      ResetForm(poribahan);
      ResetFormIme();
      $('#hidden_instock').val('0.00');
      AccountCalculation();
      $('#name').focus();
     }
}

function sl(){
  $('table#example2  tr').not(':first').not(':last').each(function($id){
  $(this).children().first().html($id + parseFloat(0));
})
}
function sli(){
  $('table#ime_tbl  tr').not(':first').not(':last').each(function($id){
  $(this).children().first().html($id + parseInt(1));
})
}
function save_float(){
 
  var datatring = $("#product_form, #ime_form").serialize();
 $.ajax({
       type:'post',
       url : '<?= base_url("product/float/create")?>',
       data: datatring,       
       success:function(res){
        console.log(res);
        //alert(res)
      }
  });
}
function AccountCalculation(){
    var sum = 0;
    var total = 0;
    var totalf = 0;
    var totalw = 0;
    $row = $('#example2 > tbody  > tr');
      $row.find('.tp').each (function() {
        sum += parseFloat($(this).val()) || 0;
      }); 

      $row.find('.trns').each (function() {
        total += parseFloat($(this).val()) || 0;
      });  
      $row.find('.fixed_cost').each (function() {
        totalf += parseFloat($(this).val()) || 0;
      });
      $row.find('.warranty_price').each (function() {
        totalw += parseFloat($(this).val()) || 0;
      });  
    $('#total_amount').val(sum.toFixed(2));
    $('#fixed_amount').val(totalf.toFixed(2));
    $('#warranty_amount').val(totalw.toFixed(2));
    $('#transport').val(total.toFixed(2));
    //$('#due').val(0);
    var cash = parseFloat(sum)+parseFloat(totalf)-parseFloat(totalw);
    $('#due').val(cash.toFixed(2));
}
function calculator(){
  $row = $(this).closest("tr");
  var oldqty = parseFloat($row.find('.hide_qty').val());
  var qty = parseFloat($row.find('.qty').val());
  var price = parseFloat($row.find('.up').val());
  var hide_stock = parseFloat($row.find('.hide_stock').val());
   if(isNaN(qty))
    qty = 0;
  if(isNaN(qty))
    price = 0;
  var aqty = qty - oldqty;
  var total = qty * price;
  var stck = hide_stock + aqty;
  if(isNaN(total)){
    total = 0;
  }
  if(isNaN(stck)){
    stck = 0;
  }
  $row.find('.tp').val(total.toFixed(2));
  $row.find('.stock').val(stck);
  AccountCalculation()
}
function finalCalculator(){
 var total_amount = parseFloat($('#total_amount').val());
 var check_amn = parseFloat($('#check_amn').val()) || 0;
 var fixed_amount = parseFloat($('#fixed_amount').val()) || 0;
 var warranty_amount = parseFloat($('#warranty_amount').val()) || 0;
 var discount = parseFloat($('#discount').val());
 var cash_paid = parseFloat($('#cash_paid').val());
 var transport = parseFloat($('#transport').val()) || 0;
 if(isNaN(total_amount)){
   total_amount = 0;
 }
 if(isNaN(discount)){
   discount = 0;
 }
 if(isNaN(cash_paid)){
   cash_paid = 0;
 }
 var due = total_amount + fixed_amount - warranty_amount - discount - cash_paid - check_amn;
 $('#due').val(Math.round(due));
}
function ResetForm(poribahan) {
    document.getElementById("product_form").reset();
    $("#category").val(null).trigger('change');
    $("#brand").val(null).trigger('change');
    $("#poribahan").val(poribahan);
    $('#add').attr('disabled',false);
}
function ResetFormIme() {
    document.getElementById("ime_form").reset();
    var tb = document.getElementById('ime_tbl');
      while(tb.rows.length > 2) {
      tb.deleteRow(1);
    }
}
function calculate() {
    var qty = parseFloat($("#qty").val()) || 0;
    var unit_price = parseFloat($("#unit_price").val()) || 0;
    var sale_price = parseFloat((unit_price * 70)/100) + parseFloat(unit_price) || 0;   
    var hidden_instock = parseFloat($("#hidden_instock").val()) || 0;
    var poribahan = parseFloat($("#poribahan").val()) || 0;
    var stock = hidden_instock + qty;
    var total_price = unit_price * qty;
    var wsale_price = parseFloat((unit_price / 5)) + parseFloat(unit_price) ;
    var trns = poribahan * qty;

    $('#instock').val(stock);
    $('#trns').val(trns);
    $('#total_price').val(total_price.toFixed(2));
    $('#wsale_price').val(wsale_price.toFixed(2));
    $('#sale_price').val(sale_price.toFixed(2));
    
}
$("table#example2").on("click", ".ibtnDel", function (event) {
  $(this).closest("tr").remove(); 
  sl();
  AccountCalculation();
  finalCalculator();
});
$("table#ime_tbl").on("click", ".ibtnDelIme", function (event) {
  $(this).closest("tr").remove(); 
  sli();
});
$("table#example2").on("click", ".ibtnUp", function (event) {
  $row = $(this).closest("tr");
  $(this).hide(); 
  $row.find('.ibtnDo').show();
  $row.find('.qty').removeAttr('readonly');
  $row.find('.up').removeAttr('readonly');
  $row.find('.sp').removeAttr('readonly');
  $row.find('.qty').css('background','#fff');
  $row.find('.sp').css('background','#fff');
  $row.find('.up').css('background','#fff');
});
$("table#example2").on("click", ".ibtnDo", function (event) {
  $row = $(this).closest("tr");
  $(this).hide(); 
  $row.find('.ibtnUp').show();
  $row.find('.qty').attr('readonly',true);
  $row.find('.up').attr('readonly',true);
  $row.find('.sp').attr('readonly',true);
  $row.find('.qty').css('background','none');
  $row.find('.sp').css('background','none');
  $row.find('.up').css('background','none');

});

</script>
<script type="text/javascript">
  $(document).ready(function(){
   
    $('#add_form').on('submit',function(e){
        if($("#supplier_id").val() == ''){alert("Supplier Cant be Empty");return false;}
       var dataString = $("#add_form, #cusSupForm").serialize();
      $.ajax({
             type:'post',
             url : '<?= base_url("product_purchase/create")?>',
             data:dataString,            
             success:function(res){
            //  alert(res);
              $("html, body").animate({ scrollTop: 0 }, 150);
              if(res == 1)
               $('.res').html('<i class="fa fa-check" style="color:green;font-size:24px;"></i>Product Purchased Successfully');
              else if(res == 0)
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i>Product Purchased Not Created'); 
              else
                $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> '+res+' Category Name  Aleady Existed');
             setTimeout(function(){
               location.reload();
             },50);
             }
      });
       e.preventDefault();
    });
  });
  function invoices(supplier_id){

      $("#pending_item").empty();
      $.ajax({
             type:'post',
             url : '<?= base_url("Main/vendor_return_supplier_product")?>',
             data:{supplier_id:supplier_id},  
             dataType: 'json',           
             success:function(res){
              if(res){
                  //alert(res);
               // alert(supplier_id);
                    $("#pending_item").empty();
                    $("#pending_item").append('<option value="">Check Item</option>');
                    $.each(res,function(index,val){
                        $("#pending_item").append('<option value="'+index+'">'+val+'</option>');
                    });
               }
               else{
                $("#pending_item").empty();
               }
              }
      });
    }
</script>
<?php 
  $this->load->view('includes/footer');
?>
