<?php 
  $this->load->view('includes/header');
  $this->load->view('includes/nav_header');
  $this->load->view('includes/sidebar_menu');
  $timezone = 'Asia/Dhaka';
  date_default_timezone_set($timezone);
?>
<style type="text/css">
  #table-div{
    width: 100%;
    height:350px;
    overflow: scroll;
  }
  #table-div-right{
    width: 100%;
    height:350px;
    overflow-y: scroll;
  }
  .table-striped tbody tr {
    background-color: #8EAFCA !important;
  }
  #payments-css{
      text-align: center;
      color: #ffffff;
      background: #00758f;
      padding: 10px;
      width: 100%
  }
 .dataTables_empty{
  display: none !important;
 }
 .pagination{
   display: none !important;
 }
 #example2_info{
   display: none !important;
 }
 #example2_filter{
  display: none !important;
 }
 #example2_length{
  display: none !important;
 }
 #namelist{
 position: absolute;
  z-index: 1;
  width:96%;
 
 }
 #namelist ul {
  border-radius: 5px;
  background: #fff;
  font-size: 16px;
  cursor: pointer;
  font-weight: 550;
  padding: 3px 10px;
  color: #000;
  box-shadow : inset 0 0 1px #000000;
}
#namelist ul li{
  list-style: none;
  padding: 5px;
  cursor: pointer;
}
#namelist ul li:hover{
  background: #e0e0e07a;
  cursor: pointer;
  border-radius: 3px;
}
#example2 .select2-container--default .select2-selection--single {
    background-color: #8eafca !important;
}
.bank{
  display: none;
}
input:read-only { 
  cursor:  not-allowed;
}
</style>
  <!-- Content Wrapper. Contains page content -->
  <?php $branch_id = $this->session->userdata('branch_id'); ?>
  <div class="content-wrapper" style="overflow-y: hidden;">
    <!-- Content Header (Page header) -->
    <div class="content-header" >
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Customer to Vendor</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>

    <div class="res" style="text-align: center;font-weight: bold;"></div>
    <section class="content">
      <div class="container-fluid">
        <div class="card-body">
          <form id="product_form">
            <div class="row">

             <div class="col-md-3">
                <div class="form-group">
                  <label>Customer</label>
                  <?php 
                    $combo_items = combobox_bind_branch('customers','id','name',$branch_id,'Customer');
                      echo form_dropdown('customer_id',$combo_items,'','class="form-control select2" id="customer_id" required="true" style="width: 100%;height:30px"');
                  ?>
                </div>
              </div>
              
              <div class="col-md-9"></div>
              
              <div class="col-md-3">
                <div class="form-group">
                  <label>IMEI</label>
                  <input type="text" name="ime"  placeholder="Enter IME" id="ime" class="form-control" autocomplete="off" style="z-index: 2;" nkeyup="autoCompleteIme.call(this)">
                </div>
              </div> 
              <div class="col-md-3">
                <div class="form-group">
                  <label>Product Name</label>
                  <input type="text"  placeholder="Enter Name" id="name" class="form-control" required="true" autocomplete="off">
                   <input type="hidden" name="hidden_instock" class="form-control" required="true" id="hidden_instock">
                   <input type="hidden" name="product_id" class="form-control" required="true" id="id">
                   
                   <div id="namelist"></div>
                </div>
                
              </div>
              
              <div class="col-md-2">
                <div class="form-group">
                  <label>Quantity</label>
                  <input type="text" name="quantity" placeholder="0.00" id="qty" class="form-control" required="true" onkeyup="calculate.call(this);" autocomplete="off">
                </div>
              </div>
              
              
              <div class="col-md-2">
                <div class="form-group">
                  <label>Warranty date</label>
                  <input type="text" name="sale_date" placeholder="Enter Date" class="form-control" id="sale_date" required="true" readonly="">
                  <input type="hidden" name="warranty_date" placeholder="Enter Date" id="warranty_date" class="form-control" required="true" readonly="">
                </div>
              </div>
              
               <div class="col-md-2">
                <div class="form-group">
                  <label>Sale Comment</label>
                  <input type="text" name="sale_comment" placeholder="Enter Comment" class="form-control" id="sale_comment" required="true" readonly="">
                </div>
              </div>
              
              
              <div class="col-md-3">
                <div class="form-group">
                  <label>Vendor</label>
                  <?php 
                    $combo_items = combobox_bind_branch('suppliers','id','name',$branch_id,'supplier');
                      echo form_dropdown('supplier_id',$combo_items,'','class="form-control select2" id="supplier_id" required="true" style="width: 100%;height:30px"');
                  ?>
                </div>
              </div> 
              <div class="col-md-3">
                <div class="form-group">
                  <label>Problem Details</label>
                    <input type="text" name="comment" placeholder="Enter Details" id="comment" class="form-control">
                </div>
              </div> 
                <div class="col-md-2"></div>
                <div class="col-md-3">
                <div class="form-group">
                  <label>Date</label>
                  <div class="input-group">
                    <div class="input-group-prepend">
                      <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                    </div>
                    <input type="text" onfocus="this.type='date'" onfocusout="this.type='text'" value="<?= date('Y-m-d');?>" id="date" class="form-control" name="date">
                  </div>
                </div>
              </div>
                              
            </div>

          
            <div class="card-footer" style="text-align: center;margin-bottom: 10px;">
              <button type="reset" class="btn btn-danger">Reset</button>
              <button type="button" onclick="this.type='submit'" class="btn btn-info">Submit</button>
            </div>
          </form>
        </div>
      </div>
    </section>
  </div>
 
<script type="text/javascript">
       
   $(document).ready(function(){        
  $( "#name" ).autocomplete({
      //source: availableTags
      source: function (request, response) {
      $.ajax({
                    type: 'get',
                    url: '<?= base_url("product/auto")?>',
                    dataType: "json",
                    data: {
                        term: request.term,
                    },
                    success: function (data) {
                      
                        response(data);
                    }
                });
            },
    
            select: function (event, ui) {
              var dtt = ui.item.label;
              var dt = dtt.split("} ");
              var name = dt[1];
              var type = $("#type").val();
                //alert(name);
               $.ajax({
                    type: 'post',
                    url: '<?= base_url("auto/product")?>',
                    data: {name:name},
                    success: function (data) {
                      var res = data.split('##');                 
                var stock = res[0];
                var price = res[1];
                var cost = res[2];
                var id = res[3];
                var brand = res[4];
                var cat = res[5];
                $('#qty').focus();
               $('#instock').val(parseFloat(stock));
               $('#id').val(parseFloat(id));
               $('#unit_price').val(parseFloat(price).toFixed(2));
               $('#cost_price').val(parseFloat(cost).toFixed(2));
               $('#hidden_instock').val(parseFloat(stock));

                    }
                    
                });
               event.preventDefault();
            }
    });
    });
</script>
<script type="text/javascript">

$(document).ready(function(){
  $('#ime').focus();

  $('#product_form').on('keypress',function(e){
    if(e.which == 13) {
        AddData();    
    }
  });
   $('#add').on('click',function(e){
    //if(e.which == 13) {
        AddData();    
  //  }
  });

 
 
   $("#ime").on('change',function(){
    var ime = $(this).val();
      $('#ime').val(ime);    
      if(ime !=''){
          $.ajax({
              url:"<?= base_url('auto_ime/product');?>",
              method:"POST",
              data:{name:ime},
              success:function(data){ 
              //alert(data);               
               var res = data.split('##');                 
                var stock = res[0];             
                var warranty_date = res[7];
                var sale_date = res[8];
                var cost = res[2];
                var id = res[3];
                var name = res[4];
                var supplier_id = res[9];
                var customer_id = res[10];
                var qty = res[14];

                 $('#instock').val(parseInt(stock));
                 $('#id').val(parseInt(id));
                 
                 $('#hidden_instock').val(parseInt(stock));
                 $('#name').val(name);
                 $('#warranty_date').val(warranty_date);
                 $('#sale_date').val(sale_date);
                 $('#sale_comment').val(res[16]);
                 $("#supplier_id").val(supplier_id).trigger('change');
                 $("#customer_id").val(customer_id).trigger('change');
                 $("#qty").val(qty);
                 $("#qty").focus();
               //  AddData();
              }              
          });
      }
      event.preventDefault();   
  });
});

</script>
<script type="text/javascript">
  $(document).ready(function(){
    $('#product_form').on('submit',function(e){
      $.ajax({
             type:'post',
             url : '<?= base_url("product_sale_return/create")?>',
             data:new FormData(this),
             processData:false,
             contentType:false,
             cache:false,
             async:false,            
             success:function(res){
              //alert(res);
              $("html, body").animate({ scrollTop: 0 }, 150);
              if(res == 1)
               $('.res').html('<i class="fa fa-check" style="color:green;font-size:24px;"></i>Product Sale Return Successfully');
              else if(res == 0)
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i>Product Sale Return Not Created'); 
              else
                $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> '+res+' Category Name  Aleady Existed');
             setTimeout(function(){
               location.reload();
             },50);
             }
      });
       e.preventDefault();
    });
  });
</script>
<?php 
  $this->load->view('includes/footer');
?>
