<?php 
  $this->load->view('includes/header');
  $this->load->view('includes/nav_header');
  $this->load->view('includes/sidebar_menu');
  $timezone = 'Asia/Dhaka';
  date_default_timezone_set($timezone);
  $branch_id = $this->session->userdata('branch_id');

?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header" >
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Create Service</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <div class="res" style="text-align: center;font-weight: bold;"></div>
    <section class="content">
      <div class="container-fluid">
      <form method="POST" enctype="multipart/form-data" id="add_form">      
        <div class="row">
          <div class="card-body">
            <div class="row">              
              
              <div class="col-md-3">
                <div class="form-group">
                  <label>Customer Name</label>
                  <?php 
                $combo_items = combobox_bind_branch_row('customers','id','name',$branch_id,'Customer');
                  echo form_dropdown('customer_id',$combo_items,'','class="form-control select2" id="customer_id" required="true"');
              ?>
                </div>                
              </div>
               <div class="col-md-6">
                                
              </div>
              <div class="col-md-3">
                  <div class="form-group">
                     <label>Date</label>
                    <input type="date" name="date" value="<?= date('Y-m-d');?>" class="form-control" required="true">
                  </div>
              </div>
               
              
              
              <div class="col-md-3">
                <div class="form-group">
                  <label>Description</label>
                  <input type="text" name="model" placeholder="Enter Description" class="form-control" id="model"  autocomplete="off">
                </div>                
              </div>
             
              <div class="col-md-3">
                <div class="form-group">
                  <label>Charge Amount</label>
                  <input type="text" name="charge" placeholder="0.00" class="form-control" id="charge"  autocomplete="off" onkeyup="calculate.call(this)">
                </div>                
              </div>  
              <div class="col-md-3">
                <div class="form-group">
                  <label>Paid</label>
                  <input type="text" name="paid" placeholder="0.00" class="form-control" id="paid"  autocomplete="off"  onkeyup="calculate.call(this)">
                </div>                
              </div>
              <div class="col-md-3">
                <div class="form-group">
                  <label>Due</label>
                  <input type="text" name="due" placeholder="0.00" class="form-control" id="due"  autocomplete="off" readonly="">
                </div>                
              </div> 
             
              <div class="col-md-3">
                <div class="form-group">
                  <label>Complete</label>
                  <select class="form-control select2" name="complete">
                       <option value='0'>No</option>
                      <option value='1'>Yes</option>
                  </select>
                </div>                
              </div>
              <div class="col-md-3">
                <div class="form-group">
                  <label>Delivery</label>
                  <select class="form-control select2" name="delivery">
                       <option value='0'>No</option>
                      <option value='1'>Yes</option>
                  </select>
                </div>                
              </div>
              
              
            </div>
          </div>
        </div>

        <div class="card-footer" style="text-align: center;">
          <button type="reset" class="btn btn-danger">Reset</button>
          <button type="submit" name="submit" class="btn btn-info">Submit</button>
        </div>
      </form>

    </section>
  </div>
<script type="text/javascript">
  
  

  
  function calculate($this) {
    let charge = parseFloat(document.querySelector('#charge').value) || 0;   
    let paid = parseFloat(document.querySelector('#paid').value) || 0;
    let due = charge - paid;
    document.querySelector('#due').value = due;
  }
  $(document).ready(function(){
    
    $('#add_form').on('submit',function(e){
      var dataString = $("#add_form").serialize();
      $.ajax({
             type:'post',
             url : '<?= base_url("service/create")?>',
             data:dataString,
             
             success:function(res){
             // alert(res);return false;
              $("html, body").animate({ scrollTop: 0 }, 150);
              if(res == 1)
               $('.res').html('<i class="fa fa-check" style="color:green;font-size:24px;"></i> Category Name Created Successfully');
              else if(res == 0)
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> Category Name Not Created'); 
              else
                $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> '+res+' Category Name  Aleady Existed');
             setTimeout(function(){
               location.reload();
             },200);
             }
      });
       e.preventDefault();
    });
  });
</script>
<?php 
  $this->load->view('includes/footer');
?>