<?php 
  $this->load->view('includes/header');
  $this->load->view('includes/nav_header');
  $this->load->view('includes/sidebar_menu');
  $timezone = 'Asia/Dhaka';
  date_default_timezone_set($timezone);
  $branch_id = $this->session->userdata('branch_id');
?>
<style type="text/css">
  .bank{
  display: none;
}
</style>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header" >
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Create Supplier Collection</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <div class="res" style="text-align: center;font-weight: bold;"></div>
    <section class="content">
      <div class="container-fluid">
      <form method="POST" enctype="multipart/form-data" id="add_form">      
        <div class="row">
          <div class="card-body">
            <div class="row">
              
              <div class="col-md-6">
                <div class="form-group">
                  <label>Supplier Name</label>
                  <?php 
                    $combo_items = combobox_bind_branch_row('suppliers','id','name',$branch_id,'Supplier');
                      echo form_dropdown('supplier_id',$combo_items,'','class="form-control select2" id="supplier_id" required="true" style="width: 100%;height:30px"');
                  ?>
                </div>                
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label>Previous Balance</label>
                  <input type="text" name="previous_balance" placeholder="0.00" readonly="" class="form-control" required="true" id="previous_balance">
                </div>                
              </div>
   

                     
              
              <div class="col-md-6">
                <div class="form-group">
                  <label>Cash Paid</label>
                  <input type="text" name="paid" placeholder="Enter Amount" id="paid" class="form-control" required="true">
                </div>                
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Balance</label>
                  <input type="text" name="balance" placeholder="0.00" readonly="" id="balance" class="form-control" required="true">
                </div>                
              </div>
              
              <!-- /.col -->
            </div>
            <!-- /.row -->
          </div>
        </div>
        <div class="card-footer" style="text-align: center;">
          <button type="reset" class="btn btn-danger">Reset</button>
          <button type="submit" name="submit" class="btn btn-info">Submit</button>
        </div>
      </form>
      </div>
    </section>
  </div>
<script type="text/javascript">
  $(document).ready(function(){
     
    $('#name').focus();
    $('#supplier_id').on('change',function(){
        var supplier_id = $(this).val();
        $.ajax({
             type:'post',
             url : '<?= base_url("payment/info")?>',
             data:{supplier:supplier_id},             
             success:function(res){
              if(res){
                  $('#previous_balance').val(res);
                  
               }
              }
      });
    });

    $('#paid').on('keyup',function(){
        var paid = $(this).val();
        var previous_balance  = $('#previous_balance').val();
        var balance = parseFloat(previous_balance) + parseFloat(paid);
        $('#balance').val(balance);
    });
    
    $('#add_form').on('submit',function(e){
      $.ajax({
             type:'post',
             url : '<?= base_url("supplier_collection/create")?>',
             data:new FormData(this),
             processData:false,
             contentType:false,
             cache:false,
             async:false,
             
             success:function(res){
              $("html, body").animate({ scrollTop: 0 }, 150);
              if(res == 1)
               $('.res').html('<i class="fa fa-check" style="color:green;font-size:24px;"></i> Customer Name Created Successfully');
              else if(res == 0)
               $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> Customer Name Not Created'); 
              else
                $('.res').html('<i class="fa fa-times" style="color:red;font-size:24px;"></i> '+res+' Customer Name  Aleady Existed');
             setTimeout(function(){
               location.reload();
             },200);
             }
      });
       e.preventDefault();
    });
  });
</script>
<?php 
  $this->load->view('includes/footer');
?>