window.onload = function () {
var options = {
  animationEnabled: true,
  theme: "dark2",
  title: {
    text: "Monthly Sales Data"
  },
  axisX: {
    valueFormatString: "MMM"
  },
  axisY: {
    prefix: "Tk ",
    labelFormatter: addSymbols
  },
  toolTip: {
    shared: true
  },
  legend: {
    cursor: "pointer",
    itemclick: toggleDataSeries
  },
  data: [
    {
      type: "column",
      name: "Actual Sales",
      showInLegend: true,
      xValueFormatString: "MMMM YYYY",
      yValueFormatString: "Tk #,##0",
      dataPoints: [
        { x: new Date(y, 0), y: jas },
        { x: new Date(y, 1), y: fes },
        { x: new Date(y, 2), y: mas },
        { x: new Date(y, 3), y: aps},
        { x: new Date(y, 4), y: mays },
        { x: new Date(y, 5), y: jus },
        { x: new Date(y, 6), y: juls },
        { x: new Date(y, 7), y: aus },
        { x: new Date(y, 8), y: ses },
        { x: new Date(y, 9), y: ocs },
        { x: new Date(y, 10), y: nos },
        { x: new Date(y, 11), y: des }
      ]
    },
    {
      type: "line",
      name: "Expected Sales",
      showInLegend: true,
      yValueFormatString: "Tk #,##0",
      dataPoints: [
        { x: new Date(y, 0), y: 500000 },
        { x: new Date(y, 1), y: 700000 },
        { x: new Date(y, 2), y: 400000 },
        { x: new Date(y, 3), y: 800000 },
        { x: new Date(y, 4), y: 300000 },
        { x: new Date(y, 5), y: 200000 },
        { x: new Date(y, 6), y: 500000 },
        { x: new Date(y, 7), y: 800000 },
        { x: new Date(y, 8), y: 400000 },
        { x: new Date(y, 9), y: 100000 },
        { x: new Date(y, 10), y: 1000000 },
        { x: new Date(y, 11), y: 500000 }
      ]
    },
    {
      type: "area",
      name: "Profit",
      markerBorderColor: "white",
      markerBorderThickness: 2,
      showInLegend: true,
      yValueFormatString: "Tk #,##0",
       dataPoints: [
        { x: new Date(y, 0), y: jap },
        { x: new Date(y, 1), y: fep },
        { x: new Date(y, 2), y: map },
        { x: new Date(y, 3), y: app},
        { x: new Date(y, 4), y: mayp },
        { x: new Date(y, 5), y: jup },
        { x: new Date(y, 6), y: julp },
        { x: new Date(y, 7), y: aup },
        { x: new Date(y, 8), y: sep },
        { x: new Date(y, 9), y: ocp },
        { x: new Date(y, 10), y: nop },
        { x: new Date(y, 11), y: dep }
      ]
    }]
};
$("#chartContainer").CanvasJSChart(options);

function addSymbols(e) {
  var suffixes = ["", "K", "M", "B"];
  var order = Math.max(Math.floor(Math.log(e.value) / Math.log(1000)), 0);

  if (order > suffixes.length - 1)
    order = suffixes.length - 1;

  var suffix = suffixes[order];
  return CanvasJS.formatNumber(e.value / Math.pow(1000, order)) + suffix;
}

function toggleDataSeries(e) {
  if (typeof (e.dataSeries.visible) === "undefined" || e.dataSeries.visible) {
    e.dataSeries.visible = false;
  } else {
    e.dataSeries.visible = true;
  }
  e.chart.render();
}


}